<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_social {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		if( isset($_arrParams['project']) ) {
			$this->gData['project'] = $_arrParams['project'];
		}
		if( isset($_arrParams['agent']) ) {
			$this->gData['agent'] = $_arrParams['agent'];
		}

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		return $this->gData;
	}

	// returns the 3 strings: URL, name, hash. The first three positions
	// represent where to fetch each parameter. The offset slot holds the 
	// offset in characters, thus convert to bytes.
	private function decodeMetadataObj($_mdObj) {
	
		$results = array();
		$dataStr = substr($_mdObj,2);
/*
		echo $dataStr.'<br>';
		//echo '0 ';
		for($j=0;$j<strlen($dataStr);$j++) {
			if( $j % 64 == 0 ) {
				echo "<br>";
			}
			echo $dataStr[$j];
		}
		echo "<br>";
*/
		$offset1 = (hex2decimal(substr($dataStr,0,64))*2);
		//echo 'offset1: '.$offset1.'<br>';
		$offset2 = (hex2decimal(substr($dataStr,64,64))*2);
		//echo 'offset2: '.$offset2.'<br>';
		$offset3 = (hex2decimal(substr($dataStr,(64+64),64))*2);
		//echo 'offset3: '.$offset3.'<br>';

		// parameter one is a string. How long is that string? 
		$len1 = hex2decimal(substr($dataStr,$offset1,64));
		//echo 'len1: '.$len1.'<br>';
		$start = $offset1+64;
		$param1 = substr($dataStr,$start,($len1*2));
		// hex2bin
		//echo 'param1: '.hex2bin($param1).'<br>';
		$results['url'] = hex2bin($param1);

		$len2 = hex2decimal(substr($dataStr,$offset2,64));
		//echo 'len2: '.$len2.'<br>';
		$start = $offset2+64;
		$param2 = substr($dataStr,$start,($len2*2));
		// hex2bin
		//echo 'param2: '.hex2bin($param2).'<br>';
		$results['name'] = hex2bin($param2);

		$len3 = hex2decimal(substr($dataStr,$offset3,64));
		//echo 'len3: '.$len3.'<br>';
		$start = $offset3+64;
		$param3 = substr($dataStr,$start,($len3*2));
		// hex2bin
		//echo 'param3: '.hex2bin($param3).'<br>';
		$results['hash'] = hex2bin($param3);

		return $results;
	}

	// need to sanitize the data.
	private function validateHash($_theStr,$_hash) {

		$theDecode = json_decode($_theStr);
		//echo var_dump($theDecode).'<br><br>';
		$theEncode = json_encode($theDecode,JSON_UNESCAPED_SLASHES|JSON_INVALID_UTF8_IGNORE);
		//echo $theEncode.'<br>';

		$curHash = sha1($theEncode);
		if( $curHash == $_hash) {
			return true;
		}
		return false;
	}

	private function getProject() {

		// TODO: Do we need to check to see if the contract supports the interface?
		if( !isset($this->gData['project']) ) {
			return null;
		}

		$contract = $this->gData['project'];
		$functionABI = 'projectDataCurrent()';
		$params = null;

		$metadataStr = callFunction($contract,$functionABI,$params);
		if( null != $metadataStr ) {
			//echo $metadataStr.'<br>';

			$data = self::decodeMetadataObj($metadataStr);

			// build the URL to the file.
			$theURL = $data['url'].$data['name'].'.json';
			//echo "fetch ".$theURL." and include it<br>";

			$theData = file_get_contents($theURL);
			if( null != $theData ) {
				if( self::validateHash($theData,$data['hash']) ) {
					$data['validatedHash'] = true;
				} else {
					$data['validatedHash'] = false;
				}

				//var_dump($theData).'<br>';
				$theDecode = json_decode($theData,true);
				//var_dump($theDecode).'<br>';
				//var_dump($theDecode['name']).'<br>';
				$data['data'] = $theDecode;
			}

			return $data;
		}
	}

	private function theRight($_data) {
		$theStr = '';

		$theStr .= "<div>";
			//$theStr .= "<span>".$verifyImg."</span>";
		$theStr .= "<span class='title' >".$_data['name']."</span>";
		$theStr .= "</div>";
		if( isset($_data['whitepaper']) ) {
			$src = $_data['whitepaper'];
			$theStr .= '<div class="link" >Whitepaper: <a href="'.$src.'" target="_self">'.$src.'</a></div>'; // Optional
		}
		if( isset($_data['description']) ) {
			$theStr .= "<div class='standard' >".$_data['description']."</div>";
		}
		if( isset($_data['external_url']) ) {
			$src = $_data['external_url'];
			$theStr .= '<div class="link" >More Info: <a href="'.$src.'" target="_self">'.$src.'</a></div>'; // Optional
		}
		if( isset($_data['creator']) ) {
			$theStr .= '<div class="standard">Creator: '.$_data['creator'].'</div>'; // Optional
		}
		if( isset($_data['artist']) ) {
			$theStr .= '<div class="standard">Artist: '.$_data['artist'].'</div>'; // Optional
		}
		if( isset($_data['collection']) ) {
			$theStr .= '<div class="standard">Collection: '.$_data['collection'].'</div>'; // Optional
		}
		// Also want a 'home' icon

		return $theStr;
	}

	private function theLeft($_data) {
		$theStyle = 'background-color:#f0f0f0;max-height: 250px;max-width: 250px;padding-top: 7px;border-radius: 5px;';
		// <img height="auto" width="96%" src="' + projectObj.image + '" >
		$theImage = '<img height="auto" width="96%" src="'.$_data['image'].'">';

		$theStr = '';
		$theStr .= '<center>';
		$theStr .= '<div style="'.$theStyle.'" width="100%" height="auto">'.$theImage.'</div>';
		$theStr .= '</center>';
		return $theStr;
	}

	private function socialNotice() {
		$theStr = '<div style="text-align:center;margin-bottom: 25px">';
		$theStr .= '<div>';
		$theStr .= "<span class='title' >Get Connected Socially!</span>";
		$theStr .= "<div class='natural' >Follow, like and share Social media content.</div>";
		$theStr .= '</div>';
		$theStr .= '';
		$theStr .= '</div>';
		return $theStr;
	}

	private function aRow($_left,$_right) {
		$theStr = '';
		$theStr .= '<div class="column" style="text-align: right;width: 45%;margin-right: 10px">';
		$theStr .= '<i>'.$_left.'</i>';
		$theStr .= "</div>";
		$theStr .= '<div class="column" style="text-align: left;width: 45%;background-color:#f5f5f5">';
		$theStr .= $_right;
		$theStr .= "</div>";
		return $theStr;
	}
	private function configureMetamask() {
		$theStr = '<center>';

		$theStr .= '<div class="row" style="margin-top: 10px">';

		$theStr .= self::aRow('Network Name','Theta Mainnet');
		$theStr .= self::aRow('Default RPC URL','https://eth-rpc-api.thetatoken.org/rpc');
		$theStr .= self::aRow('Chain Id','361');
		$theStr .= self::aRow('Currency Symbol','TFUEL');
		$theStr .= self::aRow('Block explorer URL','https://explorer.thetatoken.org');

		$theStr .= "</div>"; // row

		$theStr .= '</center>';
		$theStr .= "<div style='clear: both'></div>";
		return $theStr;
	}
	//
	// https://metamask.io/download
	//
	private function metamaskNotice() {
		$metaSrc = 'https://metamask.io/download';
		$metaLink = '<a href="'.$metaSrc.'" target="_self">Metamask</a>';

		$theStr = '<div style="text-align:center;margin-bottom: 25px">';
		$theStr .= '<div>';
		$theStr .= "<span class='title' >Product Purchasing Requiresments</span>";
		$theStr .= "<div class='natural' >Selene Network requires ".$metaLink."!</div>";
		$theStr .= "<div class='natural' >Download the browswer extension & install.</div>";
		$theStr .= "<div class='natural' >Configure for the Theta blockchain:</div>";

		$theStr .= self::configureMetamask();

		$theStr .= '<div class="natural" style="margin-top: 10px">When prompted, Connect to this website.</div>';
		$theStr .= '<div class="natural" >If you need TFUEL, click the Tfuel symbol on the top of page.</div>';
		$theStr .= '</div>';
		$theStr .= '';
		$theStr .= '</div>';
		return $theStr;
	}

	public function thePage($_arrParams)
	{
		$cDSNReadme = new CDSNReadme();
		$arrData = $cDSNReadme->data();

		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		echo "<!DOCTYPE html>";

		if( isset($arrData['tabTitle']) ) {
			$theTitle = $arrData['tabTitle'];
		} else {
			$theTitle = 'Selene Network Social';
		}
		$theDesc = "Automated Selene Network Social Page.";


		//var_dump($this->gData).'<br>';

		$data = self::getProject();
		if( null == $data ) {
			echo "Must provide valid project address '?x=0x123...xyz' on URL.<br>";
			return;
		}
		//var_dump($data['data']).'<br>';

		$theAgent = '';
		if( isset($this->gData['agent'])) {
			$theAgent = '&agent='.$this->gData['agent'];
		}

		// build the content URL
		$contentURL = $this->gData['root'].'x/?x='.$this->gData['project'].$theAgent;
		//echo $contentURL.'<br>';
		$contentTitle = $data['data']['name'];
		if( strlen($data['data']['description']) > 86 ) {
			$contentDescription = substr($data['data']['description'],0,86).' ...';
		} else {
			$contentDescription = $data['data']['description'];
		}
		//echo $contentDescription.'<br>';
		$contentImage = $data['data']['image'];


		// Want to add the header information needed for social media 
		$theHdr ='<meta name="twitter:card" content="summary"></meta>';
		$theHdr.='<meta name="twitter:site" content="@amorstyleyoga" />';
		$theHdr.= '<meta name="twitter:creator" content="@amorstyleyoga" />';
		$theHdr.= '<meta property="og:url" content="'.$contentURL.'" />';
		$theHdr.= '<meta property="og:title" content="'.$contentTitle.'" />';
		$theHdr.= '<meta property="og:description" content="'.$contentDescription.'" />';
		$theHdr.= '<meta property="og:image" content="'.$contentImage.'" />';
		$theHdr.= '<meta property="og:type" content="article" />';
		// optional
		$theHdr.= '<meta property="og:image:width" content="512" />';
		$theHdr.= '<meta property="og:image:height" content="512" />';

		echo $dsncommon->headerInfo($theTitle,$theDesc,$theHdr);

		// start of body.

		echo "<body>";
		echo $dsncommon->theCSS();

		$dsncommon->connectRow(null,false);

		// display the image, title, description
		$theStr = '';

		if( $this->gData['mobile'] ) {
			$theStr .= '<center><div class="row" style="margin-top: 15px;margin-bottom: 25px">';
			//$theStr .= '<div class="column left" style="margin-top: 15px;margin-bottom: 25px">';
			$theStr .= self::theLeft($data['data']);
			//$theStr .= "</div>";
			//$theStr .= '<div class="column right" style="margin-top: 15px;margin-bottom: 25px">';
			$theStr .= self::theRight($data['data']);
			$theStr .= "</div></center>"; // row
			$theStr .= "<div style='clear: both'></div>";
		} else {
			$theStr .= '<div class="row" >';
			$theStr .= '<div class="column left" style="margin-top: 15px;margin-bottom: 25px">';
			$theStr .= self::theLeft($data['data']);
			$theStr .= "</div>";
			$theStr .= '<div class="column right" style="margin-top: 15px;margin-bottom: 25px;margin-left: 10px">';
			$theStr .= self::theRight($data['data']);
			$theStr .= "</div>";
			$theStr .= "</div>"; // row
			$theStr .= "<div style='clear: both'></div>";
		}
		echo $theStr;

		// now help people understand that they need Metamask 
		echo self::socialNotice();
		$theStr = "<center><hr style='color:lightgray;width:75%'></center>";
		echo $theStr;
		echo self::metamaskNotice();

		echo $dsncommon->theFooter();

		echo "</body>";
		echo "</html>";
	}


}


