<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}

// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}

//
// This is the main file that should be called for default distributed sales netowrk functionality.
// ** dsn.php should not be called directly **
//
require_once($theRootDir.'/src/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir.'/dsn/wallet/wacore.php');


// main entry
function run_the_code() {

	$arrParams = [];
	if( isset($_GET['limit']) && is_numeric($_GET['limit'])) {
		$arrParams['limit']=$_GET['limit'];
		//echo "limit: ".$arrParams['limit']."<br>";
	}
	if( isset($_GET['account']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['account']) && (strlen($_GET['account']) == 42)) {
		$arrParams['account']=$_GET['account'];
		//echo "account: ".$arrParams['account']."<br>";
	}
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}


	$plugin = new Theta_wal();
	$plugin->thePage($arrParams);
}
run_the_code();
