<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
	//echo "Yes, mobile.<br>";
} 
//$globalMobile = true;
}

// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}


//
// This is the main file that should be called for default distributed sales netowrk functionality.
// ** dsn.php should not be called directly **
//
require_once($theRootDir.'/src/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir.'/dsn/video/vcore.php');


// main entry
function run_the_code() {

	$arrParams = [];
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['contract']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['contract']) && (strlen($_GET['contract']) == 42)) {
		$arrParams['contract']=$_GET['contract'];
		//echo "contract: ".$arrParams['contract']."<br>";
	}
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}

	// video_8yyib7gg8a1dke8m06khxg440c 
	if( isset($_GET['id']) &&
		substr($_GET['id'],0,6)=='video_' &&
		preg_match('/[^A-Fa-fXx0-9]/', substr($_GET['id'],6,26)) &&
		(strlen($_GET['id']) == 32)
	) {
		$arrParams['video_id']=$_GET['id'];
		//echo "id: ".$arrParams['video_id']."<br>";
	}

	// May also have a YouTube URL
	if( isset($_GET['yt'])) {
		$arrParams['video_yt']=$_GET['yt'];
	}

	$plugin = new Theta_video();
	$plugin->Init(null);
	$plugin->thePage($arrParams);
}
run_the_code();
