<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_tools {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		// capture the URL variables
		if(isset($_arrParams['file']) )
		{
			$this->gData['file'] = $_arrParams['file'];
		} 
		if(isset($_arrParams['type']) )
		{
			$this->gData['type'] = $_arrParams['type'];
		} 
		$this->gData['contractAddr'] = null; // defined, but null
		if(isset($_arrParams['contract']) )
		{
			$this->gData['contractAddr'] = $_arrParams['contract'];
		} 

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		// if the user provides an account on the URL, we name the page
		// 'The NFT Browser'. If there is no account, we're going to look
		// all all the metamask addresses. 'NFT Browsing Metamask Accounts'
		$pageTitle = 'Selene Network Tools';
		$this->gData['theTitle']=$pageTitle;

		return $this->gData;
	}

	public function globalHTML() {

		$rowId = "globalVars";

		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		$this->gData['error']=false;
		$this->gData['msg']='';
		$this->gData['indent']=16;

		foreach($this->gData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
	}

	// puts out a label and string
	private function rowElementEx($_label, $_str, $_bErr) {
		$theStr = '<div>';

		$theStr.= '<div class="column" style="margin-right: 5px;width: 18%">';

		$theStr.= '<div style="text-align: right">';
		if( $_bErr) { $theStr.= '<font color="#b30000">'; } 
		$theStr.= $_label;		
		if( $_bErr) { $theStr.= '</font>'; }

		$theStr.= ': ';
		$theStr.= '</div>';
		$theStr.= '</div>';

		$theStr.= '<div class="column" style="margin-left: 5px;width: 80%;text-align: left;">';
		$theStr.= '<span class="natural" style="max-width: 80%">';
		if( $_bErr) { 
			$theStr.= '<font color="#b30000">ERROR</font>: '; 
		}
		$theStr.= $_str;
		$theStr.= '</span>';
		$theStr.= '</div>';

		$theStr.= '</div>';
		$theStr .= "<div style='clear: both'></div>";
		return $theStr;
	}
/*
	// builds a path to the abi and byte code
	private function processABI($_root,$_name) {
	
		$theABIURL = $_root.$_name.'/project/'.$_name.'_abi.json';
		$theABILink = '<a href="'.$theABIURL.'" target=_self>'.$theABIURL.'</a>';

		$theByteCodeURL = $_root.$_name.'/project/'.$_name.'_bytecode.txt';
		$theByteCodeLink = '<a href="'.$theByteCodeURL.'" target=_self>'.$theByteCodeURL.'</a>';

		$theStr = '';
		// going to build 1 section for the page and center the three elements.
		$theStr .= '<div style="margin-bottom: 10px;margin-bottom: 10px">'; //;  

		$theStr .= '<div>';
		$theStr .= 'Launch ABI and ByteCode:';
		$theStr .= '</div>';

		$theStr .= '<div style="text-align: center">';

		// label on left, two images on right.

		// the ABI image
		$toolsABIId = 'toolsABIId';
		$toolsABIImageId = 'toolsABIImageId';
		$toolsABISrc = $GLOBALS['theRootURL'] .'/dsn/images/abi_small.png';

		$theABIStr = '<span>';
		$theABIStr .= '<span class="natural" id="'.$toolsABIId.'" hidden>'.$theABIURL.'</span>';
		$theABIStr .= '<img height="25" id="'.$toolsABIImageId.'" src="'.$toolsABISrc.'" onclick="toolsABI()">';
		$theABIStr .= "<span id='".$toolsABIId."' ></span>";
		$theABIStr .= "</span>";

		// the bytecode image
		$toolsBCId = 'toolsBCId';
		$toolsBCImageId = 'toolsBCImageId';
		$toolsBCSrc = $GLOBALS['theRootURL'] .'/dsn/images/bc_small.png';

		$theBCStr = "<span >";
		$theBCStr .= '<span class="natural" id="'.$toolsBCId.'" hidden>'.$theByteCodeURL.'</span>';
		$theBCStr .= '<img height="25" id="'.$toolsBCImageId.'" src="'.$toolsBCSrc.'" onclick="toolsBC()">';
		$theBCStr .= "<span id='".$toolsBCId."' ></span>";
		$theBCStr .= "</span>";

		$theStr .= self::rowElementEx('copy to clibboard',$theABIStr,false);
		$theStr .= self::rowElementEx('copy to clibboard',$theBCStr,false);

		$theStr .= '</div>';

		$theStr .= '</div>';
		$theStr .= "<div style='clear: both'></div>";
		return $theStr;

	}
*/
	// This function reads the URL that is provided and sets some globals
	// based on the results.
	private function readURL() {
		$this->gData['error']=false;

		if( !isset($this->gData['file']) ||  null == $this->gData['file'] || '' == $this->gData['file']) {
			$this->gData['error']=true;
			$this->gData['msg']='Invalid URL provided for read.';
			return;
		}

		ob_start();
		$this->gData['data'] = file_get_contents($this->gData['file']);
		$content = ob_get_clean();
		if( false != $this->gData['data'] ) {

			//echo $this->gData['data'].'<br>';
			//echo 'last Error: '.json_last_error().'<br>';

			// convert the data into JSON and back again as clean
			$this->gData['dataObj'] = json_decode($this->gData['data'],true);
			//echo 'last Error2: '.json_last_error().'<br>';
			//var_dump($this->gData['dataObj']).'<br>';
			$this->gData['dataClean'] = json_encode($this->gData['dataObj'],JSON_UNESCAPED_SLASHES);
			//echo $this->gData['dataClean'].'<br>';

			$this->gData['customHash'] = hash('sha1',$this->gData['dataClean'],false);

			$basename = basename($this->gData['file']);
			$_URL = $this->gData['file'];
			$this->gData['customRoot'] = str_replace($basename,"",$_URL,);

			$this->gData['customName'] = pathinfo($this->gData['file'],PATHINFO_FILENAME);

		} else {
			$this->gData['error']=true;
			$this->gData['msg']='file_get_contents() failed with file '.$this->gData['file'].'.';
		}	
	}

	//
	// hash the file and carve up the elements for the visitor.
	//
	private function processPU($_bShow) {

		$theStr = '';
		$this->gData['error']=false;

		ob_start();
		$this->gData['data'] = file_get_contents($this->gData['file']);
		$content = ob_get_clean();
		if( false != $this->gData['data'] ) {

			//echo $this->gData['data'].'<br>';
			//echo 'last Error: '.json_last_error().'<br>';

			$this->gData['dataObj'] = json_decode($this->gData['data'],true);
			//echo 'last Error2: '.json_last_error().'<br>';
			//var_dump($this->gData['dataObj']).'<br>';

			$this->gData['dataClean'] = json_encode($this->gData['dataObj'],JSON_UNESCAPED_SLASHES);
			//echo $this->gData['dataClean'].'<br>';
			//$param3 = hash('sha1',$this->gData['data'],false);
			$param3 = hash('sha1',$this->gData['dataClean'],false);
			$this->gData['customHash']=$param3;

			$basename = basename($this->gData['file']);
			$_URL = $this->gData['file'];
			$param1 = str_replace($basename,"",$_URL,);

			$this->gData['customRoot']=$param1;

			$param2 = pathinfo($this->gData['file'],PATHINFO_FILENAME);
			$this->gData['customName']=$param2;

			if( $_bShow ) {
				// going to build 1 section for the page and center the three elements.
				$theStr .= '<div style="margin-bottom: 10px;margin-bottom: 10px">'; //;  

				$theStr .= '<h3>';
				$theStr .= 'Smart Contract Initialization Data:';
				$theStr .= '</h3>';

				$theStr .= '<div style="text-align: center">';
				$theStr .= self::rowElementEx('URL',$param1,false);
				$theStr .= self::rowElementEx('Name',$param2,false);
				$theStr .= self::rowElementEx('SHA1',$param3,false);
				$theStr .= '</div>';

				$theStr .= '</div>';
				$theStr .= "<div style='clear: both'></div>";
			}
		} else {
			// error reading file.
			$this->gData['error']=true;
			$theStr .= 'Invalid Reference: '.$this->gData['file'].'<br>';
		}
		return $theStr;
	}
/*
	private function coreContracts() {
		$theStr = '';

		$theStr .= '<div style="margin-bottom: 10px;margin-bottom: 10px">'; //;  

		$theStr .= '<div>';
		$theStr .= 'Core Contracts:';
		$theStr .= '</div>';

		$theStr .= '<div style="text-align: center">';
		$theStr .= self::rowElementEx('Participant',$this->gData['participantAddr'],false);
		$theStr .= self::rowElementEx('Agent',$this->gData['agentAddr'],false);
		$theStr .= self::rowElementEx('Website',$this->gData['websiteAddr'],false);
		$theStr .= self::rowElementEx('Penny Oracle',$this->gData['PennyOracleAddr'],false);
		$theStr .= '</div>';

		$theStr .= '</div>';
		$theStr .= "<div style='clear: both'></div>";
		return $theStr;	
	}
*/
	//
	// $_nameStr is required (if $_bMustHave is true), optional otherwise.
	// Details: 
	//   The $_nameStr used as text and has an expected length.
	//   All the projects will warn of the $_nameStr is over $_warnLen characters.
	//   Fail over $_errLen characters.
	//
	// self:: checkStr($this->gData['dataObj'],'name',96,256)
	//
	// 
	//
	private function checkStr($_bMustHave,$_jsonObj, $_nameStr, $_warnLen, $_errLen) {
		$bRet = true;
		$theStr = '';

		if( isset($_jsonObj[$_nameStr]) ) {
			$clen = strlen($_jsonObj[$_nameStr]);
			if( $clen > 0 && $clen < $_warnLen ) {
				$theStr .= $_jsonObj[$_nameStr];
			} else if ( $clen >= $_warnLen && $clen < $_errLen ) {
				$theStr .= 'Warning: to long: '.$_jsonObj[$_nameStr];
			} else if ( $clen >= $_errLen  ) {
				$theStr .= 'Error: to long: '.$_jsonObj[$_nameStr];
				$bRet = false;
			} else {
				$theStr .= 'Error: no length: '.$_jsonObj[$_nameStr];
				$bRet = false;
			}

		} else {
			if( $_bMustHave ) {
				// error string
				$theStr .= 'JSON file <i>must contain</i> this StringProperty and be under about '.$_warnLen.' characters';
			}
		}

		echo self::rowElementEx($_nameStr,$theStr,false);
		return $bRet;
	}
	private function checkStrEx($_bMustHave, $_jsonObj, $_nameStr, $_warnLen, $_errLen) {
		$bRet = true;
		$theStr = '';

		if( isset($_jsonObj[$_nameStr]) ) {
			$clen = strlen($_jsonObj[$_nameStr]);
			if( $clen > 0 && $clen < $_warnLen ) {
				$theStr .= $_jsonObj[$_nameStr];
			} else if ( $clen >= $_warnLen && $clen < $_errLen ) {
				$theStr .= 'Warning: to long: '.$_jsonObj[$_nameStr];
			} else if ( $clen >= $_errLen  ) {
				$theStr .= 'Error: to long: '.$_jsonObj[$_nameStr];
				$bRet = false;
			} else {
				$theStr .= 'Error: no length: '.$_jsonObj[$_nameStr];
				$bRet = false;
			}

		} else {
			if( $_bMustHave ) {
				// error string
				$theStr .= 'JSON file <i>must contain</i> this StringProperty and be under about '.$_warnLen.' characters';
			}
		}

		// if error, pass it in globals
		$this->gData['error']=$bRet;

		$theRetStr = self::rowElementEx($_nameStr,$theStr,false);
		return $theRetStr;
	}

	// returns true if the start of the two strings are identical servers.
	// This routine will simply walk both strings comparing them until it hits
	// the first '/' after a '.'. If they match that far, they will be considered
	// the same.
	private function sameServer($_root,$_data) {
/*
		echo 'root: '.$_root.'<br>';
		echo 'data: '.$_data.'<br>';

		echo 'scheme: '.parse_url($_root,PHP_URL_SCHEME).'<br>';
		echo 'host: '.pathinfo($_root,PHP_URL_HOST).'<br>';
		echo 'path: '.pathinfo($_root,PHP_URL_PATH).'<br>';
*/
		$iElement = 0;
		$bHitPeriod = false;
		$bHitTrailingSlash = false;
		$iCount = mb_strlen($_root, 'UTF-8');
		for($i=0; $i < $iCount; $i++) {
			$rootchar = mb_substr($_root, $i, 1, 'UTF-8');
			$datachar = mb_substr($_data, $i, 1, 'UTF-8');

			$iElement++;
			//echo $rootchar.' '.$datachar.'<br>';

			if( $rootchar == '.' ) {
				//echo 'hit period<br>';
				$bHitPeriod = true;
			}
			if( $bHitPeriod || $rootchar == '/' ) {
				if( $iElement >= 8) {
					// we've consumed enough chars
					$bHitTrailingSlash = true;
					//echo 'hit trailing slash<br>';
					break;
				}
			}

			if( $rootchar != $datachar) {
				//echo 'different char<br>';
				break;
			}
		}
		if( $bHitPeriod || $bHitTrailingSlash) {
			return true;
		}
		return false;
	}

	//
	// external_url: This is expected to be a URL with a trailing slash. It points
	//   to a location where more information can be found about the project. The information
	//   found at that location can be dynamic. It is expected to contain updates and
	//   other current information.
	// Code expects:
	// 1) the location where the updates are displayed should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	// 2) expect trailing slash. (Not checked for now, not critical)
	//
	private function checkExternalUrl() {
		$bRet = false;
		$theStr = '';

		if( isset($this->gData['dataObj']['external_url'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['external_url'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {
					//echo $dataStr.'<br>';
					// Looks like a URL on the same server
					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					//$theStr .= 'external_url : "'.$hyperLink.'"';
					echo self::rowElementEx("external_url",$hyperLink,false);
					$bRet = true;
				} else {
					$theStr .= 'The path of the external_url is expected to be on the same server as the project.';
					echo self::rowElementEx("external_url",$theStr,false);
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file <i>should contain</i> an "external_url" StringProperty that is a URL to a location on the project server that allows for sharing more information about the project.';			
			echo self::rowElementEx("external_url",$theStr,false);
		}

		return $bRet;
	}
/*
	// 
	private function hashFile($_URL) {
		$data = file_get_contents($_URL);
		$param3 = hash('sha1',$data,false);
		return $param3;	
	}
*/
	//
	// whitepaper: This is expected to be a URL to a PDF file called whitepaper.pdf. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the whitepaper resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkWhitepaperUrl() {
		$bRet = false;
		$theStr = '';

		if( isset($this->gData['dataObj']['whitepaper'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['whitepaper'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					// Now validate that the filename and extension match "whitepaper.pdf"
					$basename = basename($dataStr);
					if( $basename == "whitepaper.pdf") {

						ob_start();
						$data = file_get_contents($dataStr);
						$content = ob_get_clean();
						if( false != $data ) {
							$theHash = hash('sha1',$data,false);

							// Looks like a URL on the same server
							$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
							echo self::rowElementEx('whitepaper',$hyperLink.', '.$theHash,false);
							$bRet = true;
						} 
					}
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file <i>should contain</i> a "whitepaper" StringProperty that is a URL to a location on the project server that shares a whitepaper.pdf file.';			
			echo self::rowElementEx('whitepaper',$theStr,false);
		}

		return $bRet;
	}
	//
	// image: This is expected to be a URL to a JPG, PNG or GIF file. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the image resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkImageUrl($_arrItem, $_bHash) {
		$bRet = false;
		$theStr = ''; //'<div>';

		if( isset($_arrItem['image'])) {
			// found in file.
			$dataStr = $_arrItem['image'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					if( $_bHash ) {
						// read the data and hash it.
						ob_start();
						$data = file_get_contents($dataStr);
						$content = ob_get_clean();
						if( false != $data ) {
							// Now validate that the filename and extension match "image.jpg, png or gif"
							$theHash = hash('sha1',$data,false);

							// Looks like a URL on the same server
							echo self::rowElementEx('image',$hyperLink.', '.$theHash,false);
						} 
					} else {
						// Looks like a URL on the same server
						//$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
						echo self::rowElementEx('image',$hyperLink,false);
					}
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file <i>should contain</i> a "image" StringProperty that is a URL to a location on the project server that shares a image JPG, PNG or GIF file.';			
			echo self::rowElementEx('image',$theStr,false);
		}
		//$theStr .= '</div>';
		//echo $theStr;

		return $bRet;
	}
	private function checkGenericImageUrl($_arrItem, $_key) {
		$bRet = false;
		$theStr = ''; //'<div>';

		if( isset($_arrItem[$_key])) {
			// found in file.
			$dataStr = $_arrItem[$_key];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					// Looks like a URL on the same server
					//$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					echo self::rowElementEx($_key,$hyperLink,false);
					$bRet = true;
				}
			}
		}

		if( $bRet == false ) {
			$theStr .= 'JSON file <i>should contain</i> a StringProperty that is a URL to a location on the server that shares a JPG, PNG or GIF image.';			
			echo self::rowElementEx($_key,$theStr,false);
		}

		return $bRet;
	}
	private function checkGenericImageUrlEx($_arrItem, $_key) {
		$bRet = false;
		$theStr = ''; //'<div>';
		$theRetStr = '';

		if( isset($_arrItem[$_key])) {
			// found in file.
			$dataStr = $_arrItem[$_key];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					// Looks like a URL on the same server
					//$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					$theRetStr.=self::rowElementEx($_key,$hyperLink,false);
					$bRet = true;
				}
				else {
					$theStr.='<font color="Blue"></font>sameServer didn\'t pass: ';
				}
			} 
			else {
				$theStr.="filter didn't pass: ";
			}
		} 
		else {
			$theStr.="Key not found: ";
		}

		if( $bRet == false ) {
			$theStr.= 'JSON file <i>should contain</i> a StringProperty that is a URL to a location on the server that shares a JPG, PNG or GIF image.';			
			$theRetStr.= self::rowElementEx($_key,$theStr,false);
		}

		$this->gData['error']=!$bRet;
		return $theRetStr;
	}

	//
	// This check builds a URL if the home element exists. The project owner will
	// want to make sure the link works as a link back to where the user can interact
	// with the smart contract.
	//
	private function checkHomeLink() {

		if( isset($this->gData['dataObj']['home'])) {
			// home exists in the file, let's build a clickable URL.
			$homeStr = $this->gData['dataObj']['home'];

			$theURL = $this->gData['customRoot'].$homeStr.'.php';

			$hyperLink = '<a href="'.$theURL.'" target=_self>'.$theURL.'</a>';
			echo self::rowElementEx('<i>homelnk</i>',$hyperLink,false);
		}
	}


	//
	// whitepaper: This is expected to be a URL to a PDF file called whitepaper.pdf. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the whitepaper resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkVideo_ReelUrl($_bMustHave) {
		$bRet = false;
		$theStr = ''; //'<div>';

		if( isset($this->gData['dataObj']['video_reel'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['video_reel'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					// Looks like a URL on the same server
					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					//$theStr .= 'video_reel : "'.$hyperLink.'"';
					echo self::rowElementEx('video_reel',$hyperLink,false);
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			if( $_bMustHave ) {
				$theStr .= 'If there is a "video_reel" StringProperty that is a URL to a location on the project server that shares a reel file.';
				echo self::rowElementEx('video_reel',$theStr,false);
			}
		}
		//$theStr .= '</div>';
		//echo $theStr;

		return $bRet;
	}

/*
	// This routine will evaluate the project file to make sure that it has all the elements
	// that are expected of it.
	private function processAsProject() {
		echo '<div style="margin-top: 10px;margin-bottom: 10px">';
		echo '<div >Processing Project File</div>'; // style="text-align: center"

		// start with "name"
		self::checkStr(true, $this->gData['dataObj'],'name',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);

		// URL items
		self::checkExternalUrl();
		self::checkWhitepaperUrl();
		self::checkImageUrl($this->gData['dataObj'],true);

		// optional items
		self::checkStr(false, $this->gData['dataObj'],'artist',96,256);
		self::checkStr(false, $this->gData['dataObj'],'creator',96,256);
		self::checkStr(false, $this->gData['dataObj'],'collection',96,256);
		self::checkStr(false, $this->gData['dataObj'],'home',96,256);
		self::checkHomeLink();
		self::checkVideo_ReelUrl(false);

		self::rawData();

		echo '</div>';
	}
*/
	// This routine will evaluate the token metadata file to make sure that it has all the elements
	// that are expected of it.
	private function processAsToken() {
		echo '<div >Processing Token File</div>';

		// start with "name"
		self::checkStr(true, $this->gData['dataObj'],'name',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);

		// URL items
		self::checkExternalUrl();
		//self::checkWhitepaperUrl();
		self::checkImageUrl($this->gData['dataObj'],false);

		// optional items
		self::checkStr(false, $this->gData['dataObj'],'artist',96,256);
		self::checkStr(false, $this->gData['dataObj'],'creator',96,256);
		self::checkStr(false, $this->gData['dataObj'],'collection',96,256);
		self::checkStr(false, $this->gData['dataObj'],'home',96,256);
		self::checkHomeLink();
		self::checkVideo_ReelUrl(false);
	}

	// This routine will evaluate the reel metadata file to make sure that it has all the elements
	// that are expected of it.
	// The structure of a reel file is two tear. There is a array of sections and each section
	// describes an array of videos. 
	// Note that reel files are meant to be edited over time. 
	private function processAsReel() {
		echo '<div >Processing Reel File</div>';

		self::checkStr(true, $this->gData['dataObj'],'title',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);
		echo '<br>';

		// the reel element is an array, let's get it's count and loop.
		if( isset($this->gData['dataObj']['reel']) ) {
			$arrReel = $this->gData['dataObj']['reel'];
			//echo 'reel count: '.count($arrReel).'<br>';

			for( $i = 0; $i < count($arrReel); $i++ ) {
				//echo $i.' ';
				self::checkStr(true, $arrReel[$i],'section',96,256);
				self::checkStr(true, $arrReel[$i],'description',1024,4096);
			
				if( isset($arrReel[$i]['videos']) ) {
					// now walk each entry and validate that it has what we expect.
					$arrVideos = $arrReel[$i]['videos'];
					for($v = 0; $v < count($arrVideos); $v++ ) {
						//echo $v.' ';
						self::checkStr(true, $arrVideos[$v],'name',96,256);
						self::checkImageUrl($arrVideos[$v],false);
						self::checkStr(true, $arrVideos[$v],'description',96,256);

						// Now, we check for the video link. it can be either 
						// youtube or video_id. If we have one, we'll build a hyperlink
						// to that resource.
						if( isset($arrVideos[$v]['youtube']) ) {
							// https://www.youtube.com/watch?v=XDRNlxaViKg
							$url = 'https://www.youtube.com/watch?v='.$arrVideos[$v]['youtube'];
							$hyperLink = '<a href="'.$url.'" target=_self>'.$url.'</a>';
							echo self::rowElementEx('youtube',$hyperLink,false);
						
						} else if( isset($arrVideos[$v]['video_id']) ) {
							// https://amorstyle.com/dsn/video/?id=video_638a3bpi64btq4f90hpneej28t
							$url = 'https://amorstyle.com/dsn/video/?id='.$arrVideos[$v]['video_id'];
							$hyperLink = '<a href="'.$url.'" target=_self>'.$url.'</a>';
							echo self::rowElementEx('video_id',$hyperLink,false);

						} else {
							// error.
						}
						echo '<br>';
					}
				} 
				echo '<br>';
			}
		
		} else {
			echo 'reel Array Property missing from reel file.<br>';
		}
	}

	private function processAsRecord() {
		echo '<div >Processing Record File</div>';

		self::checkStr(true, $this->gData['dataObj'],'name',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);
		echo '<br>';
		$theStr = $this->gData['dataClean'];
		return $theStr;
	}

	private function processDocs() {
		$theStr = '';
		$theStr.= '<center><div style="font-size: 1.25em">How to use tools</div></center>';

		$theStr.= '<center><p>This section of the Selene Network software is designed to help the project creator by checking to see if the JSON files associated with projects contain what is expected by the core software.</p></center>';
		$theStr.= '<center><p>The tools section expects to find a keyword followed by a path on the URL. An example would be<br>"?file=https://amorstyle.com/nfts/sc_simpv2/sc_simpv2.json"</p></center>';
		$theStr.= '<center><p>The tools code currently supports the following keywords.</p></center>';

		$theStr .= self::rowElementEx("<b>keyword</b>","<b>Description</b>",false);
		$theStr .= self::rowElementEx("file","Parses the project or gallery JSON file, checks the metadata elements and allows for general validation. Also provides deployment and update functionality for a smart contract.",false);
		$theStr .= self::rowElementEx("token","Parses a token JSON file.",false);
		$theStr .= self::rowElementEx("reel","Parses a reel JSON file.",false);
		$theStr .= self::rowElementEx("record","Parses a record JSON file for proof-of-origins.",false);

		return $theStr;
	}


	// --------------------------------------------------------------------------------

	// the 'sntype' in the file must be set to $_snType
	private function validateTypeMatch($_arrRoot,$_label,$_Value) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label])) || ($_arrRoot[$_label]!=$_Value)) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'":"'.$_Value.'" entry not found in JSON file.';
			return false;
		}
		return true;
	}

	// if it is value, it returns the address, else null.
	private function validateAddr($_arrData,$_key) {
		if( isset($_arrData[$_key]) && !preg_match('/[^A-Fa-fXx0-9]/', $_arrData[$_key]) && (strlen($_arrData[$_key]) == 42)) {
			return $_arrData[$_key];
		} else {
			return null;
		}
	}

	private function validateTypeAddress($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label]))  ) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'":"theta account address" entry not found in JSON file.';
			return false;
		}
		// now validate that the value found there is an address.
		$theValue = $_arrRoot[$_label];
		if( !preg_match('/[^A-Fa-fXx0-9]/', $theValue) && (strlen($theValue) == 42)) {
			return true;
		} else {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'":"'.$theValue.'" value does not qualify as address.';
			return false;
		}
	}
	private function validateTypeNumber($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label]))  ) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": Number - entry not found in JSON file.';
			return false;
		}

		if( !is_numeric($_arrRoot[$_label]) ) {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": Number - entry needs to be a number (no quotes).';
			return false;
		}
		return true;
	}
	private function validateTypeBoolean($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label]))  ) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": true or false - entry not found in JSON file.';
			return false;
		}

		if( !is_bool($_arrRoot[$_label]) ) {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": entry needs to be true of false (no quotes).';
			return false;
		}
		return true;
	}
	// name can be up to 96 characters long.
	private function validateTypeName($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label]))  ) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": "string" entry not found in JSON file.';
			return false;
		}

		$len = strlen($_arrRoot[$_label]);
		if( $len > 96 ) {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": Name too long.';
			return false;
		}
		return true;
	}
	// name can be up to 96 characters long.
	private function validateTypeDesc($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global
		// want to set the error if we get one.
		if( (!isset($_arrRoot[$_label]))  ) 
		{
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": "string" entry not found in JSON file.';
			return false;
		}

		$len = strlen($_arrRoot[$_label]);
		if( $len > 1024 ) {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": Name too long.';
			return false;
		}
		return true;
	}
	private function validateTypeImageURL($_arrRoot,$_label) {
		$this->gData['error']=false; // clear global

		if( isset($_arrRoot[$_label])) {
			// found in file.
			$dataStr = $_arrRoot[$_label];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {
					// success path
					return true;
				}
				else {
					//$theStr.='<font color="Blue"></font>sameServer didn\'t pass: ';
					$this->gData['error']=true;
					$this->gData['msg']='"'.$_label.'": URL path is expected to be your server.';
				}
			} 
			else {
				$this->gData['error']=true;
				$this->gData['msg']='"'.$_label.'": URL value not in standard form.';
			}
		} else {
			$this->gData['error']=true;
			$this->gData['msg']='"'.$_label.'": URL label not found in file.';
		}
		return false;
	}

	private function validateContracts() {
		if( isset($this->gData['dataObj']['contracts']) ) {
			$theJSON = $this->gData['dataObj']['contracts'];
			// Walk the list, each entry should be an address.
			$iCount = count($theJSON);
			for($i=0;$i<$iCount;$i++) {
				if( !self::validateTypeAddress($theJSON,$i) ) {
					return;
				} else {
					//echo 'Item: '.$i.' value: '.$theJSON[$i].'<br>';
				}
			}
		} else {
			$this->gData['error']=true;
			$this->gData['msg']='"contracts":"{...}" entry not found in JSON file.';
			return false;		
		}
		return true;
	}

	private function validatePayInit() {
		if( isset($this->gData['dataObj']['payInitalize']) ) {
			$theJSON = $this->gData['dataObj']['payInitalize'];

			if( !self::validateTypeNumber($theJSON,'costInPennies') ) {
				return false;		
			}
			if( !self::validateTypeNumber($theJSON,'daysToClaim') ) {
				return false;		
			}
			if( !self::validateTypeNumber($theJSON,'minCount') ) {
				return false;		
			}
			if( !self::validateTypeNumber($theJSON,'percentAgents') ) {
				return false;		
			}
			if( !self::validateTypeNumber($theJSON,'percentWebsites') ) {
				return false;		
			}

		} else {
			$this->gData['error']=true;
			$this->gData['msg']='"payInitalize":"{...}" entry not found in JSON file.';
			return false;		
		}
		return true;
	}

	// There is specific data that must be found in the gallery file to make it useful.
	// This routine will parse the data to validate that it holds what is needed.
	private function validateGalleryFile() {
		if( !self::validateTypeName($this->gData['dataObj'],'name') ) {
			return;
		}
		if( !self::validateTypeMatch($this->gData['dataObj'],'sntype','galleryv2') ) {
			return;
		}
		if( !self::validateTypeAddress($this->gData['dataObj'],'titled') ) {
			return;
		}
		if( !self::validateTypeNumber($this->gData['dataObj'],'limit') ) {
			return;
		}
		if( !self::validateTypeBoolean($this->gData['dataObj'],'showSimpleSwap') ) {
			return;
		}
		if (!self::validateContracts() ) {
			return;
		}
		if (!self::validateTypeImageURL($this->gData['dataObj'],'homeIcon') ) {
			return;
		}
		if (!self::validateTypeImageURL($this->gData['dataObj'],'image') ) {
			return;
		}
	}

	// There is specific data that must be found in the gallery file to make it useful.
	// This routine will parse the data to validate that it holds what is needed.
	private function validateProjectFile() {
		if( !self::validateTypeName($this->gData['dataObj'],'name') ) {
			return;
		}
		if( !self::validateTypeDesc($this->gData['dataObj'],'description') ) {
			return;
		}
		if( !self::validateTypeMatch($this->gData['dataObj'],'sntype','project') ) {
			return;
		}
		if( !self::validateTypeAddress($this->gData['dataObj'],'titled') ) {
			return;
		}
		if( !self::validateTypeNumber($this->gData['dataObj'],'mintLimit') ) {
			return;
		}
		if( !self::validateTypeBoolean($this->gData['dataObj'],'soulBound') ) {
			return;
		}
		if( !self::validateTypeBoolean($this->gData['dataObj'],'sendLock') ) {
			return;
		}

		if (!self::validatePayInit() ) {
			return;
		}

		if (!self::validateTypeImageURL($this->gData['dataObj'],'image') ) {
			return;
		}
		if (!self::validateTypeImageURL($this->gData['dataObj'],'whitepaper') ) {
			return;
		}
		// Don't need a external_url, but it's nice to have
		//if (!self::validateTypeImageURL($this->gData['dataObj'],'external_url') ) {
		//	return;
		//}

	}


	private function buildInterfaceList() {
		$theList = array();
		$theList['IERC165']="0x01ffc9a7";
		$theList['IERC721']="0x80ac58cd";
		$theList['IERC721Metadata']="0x5b5e139f";
		$theList['ISelNetV1']="0x01464b5a";
		$theList['IPennyOracleV1']="0x3c25e541";
		$theList['IMetadataV1']="0x2839ac8d";
		$theList['ICountV1']="0x18160ddd";
		$theList['IPayV1']="0x0c6b9d1c";
		$theList['IMintV1']="0x48165a5b";
		$theList['IBurnV1']="0x42966c68";
		$theList['IMemV1']="0x4748f28f";
		$theList['IPayV2']="0x17d67609";
		$theList['IERC721ExV1']="0x0416a63b";
		$theList['IERC721ExV1M']="0xb9fcec28";
		$theList['IRecordsV1']="0xc8e3ce8f";
		$theList['IGalleryV2']="0xdb5334d3";
		return $theList;
	}

	//
	// Going to call the contract to see 
	//
	private function validateContractURL() {

		$IList = self::buildInterfaceList();

		$this->gData['Owner']=null;
		$this->gData['Titled']=null;
		$this->gData['bIMetadataV1']=false;
		$this->gData['bIPayV1']=false;
		$this->gData['bIPayV2']=false;
		$this->gData['bIMemV1']=false;
		$this->gData['bIGalleryV2']=false;
		$this->gData['bIRecordsV1']=false;

		// for both IPayV1 and IPayV2
		$this->gData['bPayActive']=false; // commissions have been setup.

		$this->gData['bProjectActive']=false; // projectUpdate() has been called.

		// For IMemV1, payActive returns true if both payInitalize and memInitalize have
		// been called. Will want to actually get payInfo and memInfo to see the state.

		// if the caller places contract= on the URL, we'll have a non-null contractAddr.
		// This value has the correct form already.
		$contract = $this->gData['contractAddr'];
		if( null == $contract || '' == $contract ) {
			return false;
		}

		$functionABI = 'supportsInterface(bytes4)';
		$outputStr = callFunction($contract,$functionABI,substr($IList['IMetadataV1'], 2, 8));
		$this->gData['bIMetadataV1'] = parseAsBoolean($outputStr);

		if( false == $this->gData['bIMetadataV1'] ) {
			// everything must support this interface. If it's not, we don't
			// have a Selene Network contract on the URL
			return false;
		} else {
			// Every contract must support Titled() and Owner().

			$functionABI = 'titled()';
			$outputStr = callFunction($contract,$functionABI,'');
			$this->gData['Titled'] = parseAsAddress($outputStr);
			//echo 'Titled: '.$this->gData['Titled'].'<br>';

			$functionABI = 'owner()';
			$outputStr = callFunction($contract,$functionABI,'');
			$this->gData['Owner'] = parseAsAddress($outputStr);
			//echo 'Owner: '.$this->gData['Owner'].'<br>';

			$functionABI = 'projectDataCurrent()';
			$outputStr = callFunction($contract,$functionABI,'');
			$this->gData['projectUpdate'] = parseAsProjectMetadata($outputStr);
			if( null != $this->gData['projectUpdate'] ) {
				//echo 'Metadata URL: '.$this->gData['projectUpdate']['url'].'<br>';
				//echo 'Metadata Name: '.$this->gData['projectUpdate']['name'].'<br>';
				//echo 'Metadata Hash: '.$this->gData['projectUpdate']['hash'].'<br>';
				$this->gData['bProjectActive']=true;
			}

			// Generally, a contract will support either IPayV1 or IPayV2.
			$functionABI = 'supportsInterface(bytes4)';
			$outputStr = callFunction($contract,$functionABI,substr($IList['IPayV2'], 2, 8));
			$this->gData['bIPayV2'] = parseAsBoolean($outputStr);
			if( $this->gData['bIPayV2'] ) {
				//echo 'supports IPayV2<br>';
			} else {
				$functionABI = 'supportsInterface(bytes4)';
				$outputStr = callFunction($contract,$functionABI,substr($IList['IPayV1'], 2, 8));
				$this->gData['bIPayV1'] = parseAsBoolean($outputStr);
				if( $this->gData['bIPayV1'] ) {
					//echo 'supports IPayV1<br>';
				}
			}

			// For basic contracts, this will tell us if the information has been setup.
			if( $this->gData['bIPayV2'] || $this->gData['bIPayV1'] ) {
				// payActive will return true if the commissions have been setup.
				$functionABI = 'payActive()';
				$outputStr = callFunction($contract,$functionABI,'');
				$this->gData['bPayActive'] = parseAsBoolean($outputStr);
			}

			$functionABI = 'supportsInterface(bytes4)';
			$outputStr = callFunction($contract,$functionABI,substr($IList['IMemV1'], 2, 8));
			$this->gData['bIMemV1'] = parseAsBoolean($outputStr);
			if( $this->gData['bIMemV1'] ) {
				echo 'supports IMemV1<br>';

				//TODO: Need to fetch the memInfo()
				// use decodeMetadataObj() as the model
			}

			$functionABI = 'supportsInterface(bytes4)';
			$outputStr = callFunction($contract,$functionABI,substr($IList['IGalleryV2'], 2, 8));
			$this->gData['bIGalleryV2'] = parseAsBoolean($outputStr);
			//if( $this->gData['bIGalleryV2'] ) {
				//echo 'supports IGalleryV2<br>';

				//Q: How can we tell if the gallery has been initialized?
				// the projectUpdate data will have been set.
			//}
		}
		return true;
	}

	private function dumpAsString($_indent, $_label, $_value) {
		$mar = $_indent*$this->gData['indent'];
		$theStr = '<div style="margin-left: '.$mar.'px">"'.$_label.'" : <font color="green">"'.$_value.'"</font>'.'</div>';
		return $theStr;
	}
	private function dumpAsStringLink($_indent, $_label, $_value) {
		$mar = $_indent*$this->gData['indent'];
		$link = '<a href="'.$_value.'" target="_blank">'.$_value.'</a>';
		$theStr = '<div style="margin-left: '.$mar.'px">"'.$_label.'" : <font color="green">"'.$link.'"</font>'.'</div>';
		return $theStr;
	}
	private function dumpAsStringIndexed($_indent, $_label, $_value) {
		$mar = $_indent*$this->gData['indent'];
		$theStr = '<div style="margin-left: '.$mar.'px">'.$_label.' : <font color="green">"'.$_value.'"</font>'.'</div>';
		return $theStr;
	}
	private function dumpAsNumber($_indent, $_label, $_value) {
		$mar = $_indent*$this->gData['indent'];
		$theStr = '<div style="margin-left: '.$mar.'px">"'.$_label.'" : <font color="orange">'.$_value.'</font>'.'</div>';
		return $theStr;
	}
	private function dumpAsBoolean($_indent, $_label, $_value) {
		$mar = $_indent*$this->gData['indent'];
		if($this->gData['dataObj'][$_label]) {
			$theStr = '<div style="margin-left: '.$mar.'px">"'.$_label.'" : <font color="red">true</font>'.'</div>';
		} else {
			$theStr = '<div style="margin-left: '.$mar.'px">"'.$_label.'" : <font color="red">false</font>'.'</div>';
		}
		return $theStr;
	}

	private function dumpAsGallery($_indent) {
		$mar = $_indent*$this->gData['indent'];

		$theStr='';
		// must have:
		$theStr.= self::dumpAsString($_indent,'name',$this->gData['dataObj']['name']);
		$theStr.= self::dumpAsString($_indent,'sntype',$this->gData['dataObj']['sntype']);
		$theStr.= self::dumpAsString($_indent,'titled',$this->gData['dataObj']['titled']);
		// may have:
		if(isset($this->gData['dataObj']['limit'])) {
			$theStr.= self::dumpAsString($_indent,'limit',$this->gData['dataObj']['limit']);
		}
		if(isset($this->gData['dataObj']['showSimpleSwap'])) {
			$theStr.= self::dumpAsBoolean($_indent,'showSimpleSwap',$this->gData['dataObj']['showSimpleSwap']);
		}
		if(isset($this->gData['dataObj']['homeIcon'])) {
			$theStr.= self::dumpAsStringLink($_indent,'homeIcon',$this->gData['dataObj']['homeIcon']);
		}
		if(isset($this->gData['dataObj']['image'])) {
			$theStr.= self::dumpAsStringLink($_indent,'image',$this->gData['dataObj']['image']);
		}

		// the contracts
		$iCount = count($this->gData['dataObj']['contracts']);
		$theStr.='<div style="margin-left: '.$mar.'px">contracts: ['.$iCount.']</div>';
		for($i=0;$i<$iCount;$i++) {
			$theStr.= self::dumpAsStringIndexed(2,$i,$this->gData['dataObj']['contracts'][$i]);
		}

		return $theStr;
	}


	private function dumpAsProject($_indent) {
		$mar = $_indent*$this->gData['indent'];

		$theStr='';
		$theStr.= self::dumpAsString($_indent,'name',$this->gData['dataObj']['name']);
		$theStr.= self::dumpAsString($_indent,'description',$this->gData['dataObj']['description']);
		$theStr.= self::dumpAsString($_indent,'sntype',$this->gData['dataObj']['sntype']);
		$theStr.= self::dumpAsString($_indent,'titled',$this->gData['dataObj']['titled']);
		$theStr.= self::dumpAsStringLink($_indent,'image',$this->gData['dataObj']['image']);
		$theStr.= self::dumpAsStringLink($_indent,'whitepaper',$this->gData['dataObj']['whitepaper']);
		// may have:
		if( isset($this->gData['dataObj']['external_url'])) {
			$theStr.= self::dumpAsStringLink($_indent,'external_url',$this->gData['dataObj']['external_url']);
		}
		if( isset($this->gData['dataObj']['artist'])) {
			$theStr.= self::dumpAsString($_indent,'artist',$this->gData['dataObj']['artist']);
		}
		if( isset($this->gData['dataObj']['creator'])) {
			$theStr.= self::dumpAsString($_indent,'creator',$this->gData['dataObj']['creator']);
		}
		if( isset($this->gData['dataObj']['collection'])) {
			$theStr.= self::dumpAsString($_indent,'collection',$this->gData['dataObj']['collection']);
		}

		// more must have:
		// payInitalize structure
		$theStr.='<div style="margin-left: '.$mar.'px">payInitalize {4}</div>';
		$theStr.= self::dumpAsNumber($_indent+1,'costInPennies',$this->gData['dataObj']['payInitalize']['costInPennies']);
		$theStr.= self::dumpAsNumber($_indent+1,'daysToClaim',$this->gData['dataObj']['payInitalize']['daysToClaim']);
		$theStr.= self::dumpAsNumber($_indent+1,'minCount',$this->gData['dataObj']['payInitalize']['minCount']);
		$theStr.= self::dumpAsNumber($_indent+1,'percentAgents',$this->gData['dataObj']['payInitalize']['percentAgents']);
		$theStr.= self::dumpAsNumber($_indent+1,'percentWebsites',$this->gData['dataObj']['payInitalize']['percentWebsites']);

		$theStr.= self::dumpAsBoolean($_indent,'soulBound',$this->gData['dataObj']['soulBound']);
		$theStr.= self::dumpAsBoolean($_indent,'sendLock',$this->gData['dataObj']['sendLock']);
		$theStr.= self::dumpAsNumber($_indent,'mintLimit',$this->gData['dataObj']['mintLimit']);
		return $theStr;
	}

	private function dumpFile($_type) {		
		$_indent=1;
		$mar = $_indent*$this->gData['indent'];

		$theStr = '<div id="dumpURLId" style="margin-top: 10px;margin-bottom: 10px" >'; //hidden
		$theStr.= '<center><h3>Selene Network values in JSON file.</h3></center>';
		$theStr.= '<center><p>Validate that all these values are correct. If not, edit your file and try again.</p></center>';
		$theStr.= '<div style="margin-left: 0px">{'.'</div>';

		if( 'project'==$_type ) {
			$theStr.=self::dumpAsProject($_indent);
		} elseif( 'galleryv2' == $_type) {
			$theStr.=self::dumpAsGallery($_indent);
		}

		$theStr.= '<div style="margin-left: 0px">}'.'</div>';
		$theStr.= '</div>';
		return $theStr;
	}



	private function rawData() {

		$theStr = '';
		$theStr.= '<div>';
		$theStr.= '<center><h3>Raw Data</h3></center>';
		$theStr.= '<div style="word-wrap: break-word;width: 100%">'.$this->gData['dataClean'].'</div>';
		$theStr.= '</div>';
		return $theStr;
	}




	// State information about the contractAddr on the URL.
	private function writeContractData() {
		// if $this->gData['bIMetadataV1'] is true we have a Selene Network compatible
		// smart contract. This should also mean that Owner and Titled are non-zero.
		// 
		// If payInitialilze() has been called, payActive() will return true. 
		// 

		$theStr='';
		$theStr.='<div id="contractOwnerId" hidden>'.$this->gData['Owner'].'</div>';
		$theStr.='<div id="contractTitledId" hidden>'.$this->gData['Titled'].'</div>';
		// if a contract has been deployed, we'll have owner & titled
		if( null != $this->gData['Owner'] && null != $this->gData['Titled']) {
			$theStr.='<div id="contractIsDeployedId" hidden>true</div>';
		} else {
			$theStr.='<div id="contractIsDeployedId" hidden>false</div>';
		}
		// If the contract supports IPayV1 or IPayV2, this will be true and we know
		// that we can call payInitalize()
		if( $this->gData['bIPayV2'] || $this->gData['bIPayV1'] ) {
			$theStr.='<div id="contractIsIPayId" hidden>true</div>';
		} else {
			$theStr.='<div id="contractIsIPayId" hidden>false</div>';
		}
		if( $this->gData['bPayActive'] ) {
			$theStr.='<div id="contractActiveId" hidden>true</div>';
		} else {
			$theStr.='<div id="contractActiveId" hidden>false</div>';
		}

		// now for projectUpdate data
		if($this->gData['bProjectActive']) {
			$theStr.='<div id="contractProjectActiveId" hidden>true</div>';
		} else {
			$theStr.='<div id="contractProjectActiveId" hidden>false</div>';
		}

		// if bProjectActive is non-zero, these will be non-zero. else, these will be null.
		$theStr.='<div id="contractURLId" hidden>'.$this->gData['projectUpdate']['url'].'</div>';
		$theStr.='<div id="contractNameId" hidden>'.$this->gData['projectUpdate']['name'].'</div>';
		$theStr.='<div id="contractHashId" hidden>'.$this->gData['projectUpdate']['hash'].'</div>';

		return $theStr;	
	}


	// some of the params needed for deploying a basic project
	private function writeDeployData($_type) {

		$arrJSON = $this->gData['dataObj'];
		$po = self::validateAddr($this->gData,'PennyOracleAddr');

		$theStr='';
		$theStr.='<div id="_theTitledId" hidden>'.$arrJSON['titled'].'</div>';
		$theStr.='<div id="_thePennyOracleId" hidden>'.$po.'</div>';
		if( 'project'== $_type ) {
			$theStr.='<div id="_strProjectNameId" hidden>'.$this->gData['customName'].'</div>';
			$theStr.='<div id="_bSoulboundId" hidden>'.($arrJSON['soulBound']?"true":"false").'</div>';
			$theStr.='<div id="_bSendLockId" hidden>'.($arrJSON['sendLock']?"true":"false").'</div>';
			$theStr.='<div id="_limitId" hidden>'.$arrJSON['mintLimit'].'</div>';
		}
		return $theStr;
	}
	// params needed for projectUpdate()
	private function writeProjectUpdateData() {
		$theStr='';
		$theStr.='<div id="_URIId" hidden>'.$this->gData['customRoot'].'</div>'; // URL
		$theStr.='<div id="_ProjectId" hidden>'.$this->gData['customName'].'</div>'; // Name
		$theStr.='<div id="_hashId" hidden>'.$this->gData['customHash'].'</div>'; // SHA1
		return $theStr;
	}
	private function writePayInitalizeData() {
		$theJSON = $this->gData['dataObj']['payInitalize'];
		$theStr='';
		$theStr.='<div id="_mintPenniesId" hidden>'.$theJSON['costInPennies'].'</div>';
		$theStr.='<div id="_timeoutDaysId" hidden>'.$theJSON['daysToClaim'].'</div>';
		$theStr.='<div id="_minCountId" hidden>'.$theJSON['minCount'].'</div>';
		$theStr.='<div id="_cutPercentAgentId" hidden>'.$theJSON['percentAgents'].'</div>';
		$theStr.='<div id="_cutPercentWebsiteId" hidden>'.$theJSON['percentWebsites'].'</div>';
		return $theStr;
	}


	//
	// When deploying a basic sample, we have the following parameters to find:
	//
	private function runWithDeployBtn($_type) {
		$secId = 'deployProject'; // either +Id or +ErrId or +btnId
		$theStyle = 'padding:15px;background-color:#dce6f5'; //
	
		// the type
		$typeName = 'Project';
		if( 'galleryv2' == $_type ) {
			$typeName = 'Gallery';
		}

		$secTitle = 'Deploy Basic '.$typeName.' Smart Contract';
		$btnName = 'Deploy New '.$typeName;

		$txt = array();
		$txt[0] = 'Press the "Deploy New '.$typeName.'" button to write this smart contract bytecode to the blockchain.';
		$txt[1] = 'Copy and save the returned address. This is your smart contract address.';

		$theStr='';
		$theStr.='<div id="'.$secId.'Id" style="'.$theStyle.'" hidden>'; //  - start of deploy section
		$theStr.= '<h3>'.$secTitle.'</h3>';

		$theStr.= '<p>'.$txt[0].'</p>';
		$theStr.= '<p>'.$txt[1].'</p>';

		if( 'project' == $_type ) {
			$theStr.=self::writeDeployData($_type);
			$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="deployProject()" disabled> '.$btnName.' </button>';
		} elseif( 'galleryv2' == $_type ) {
			$theStr.=self::writeDeployData($_type);
			$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="deployGallery()" disabled> '.$btnName.' </button>';
		}

		// Data looks correct, allow person to deploy this contract.
		//$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="deployContract()" disabled> '.$btnName.' </button>';
		// If we are successful, we want to show the person the contract.
		$theStr.='<div id="'.$secId.'TrxnId" class="natural" style="margin-top: 5px" hidden></div>'; // 
		$theStr.='<div id="'.$secId.'AddrId" class="natural" style="margin-top: 5px" hidden></div>'; // 
		$theStr.='<div id="'.$secId.'ContractAddrId" class="natural" style="margin-top: 5px" hidden></div>'; // 

		$theStr.=self::runWithContinueBtn('deploy'); // $_type

		$theStr.='</div>'; // end of deploy section
		return $theStr;
	}


	private function runWithProjectIPay() {
		$secId = 'payInitalize'; // either +Id or +ErrId or +btnId
		$theStyle = 'padding:15px;background-color:#dce6f5'; //

		$secTitle = 'Set Price and Sales Commissions for Contract';
		$btnName = 'Set Sales Conditions';

		$txt = array();
		$txt[0] = 'To set the cost and commissions, as defined in the payInitalize object in this json file, click the "'.$btnName.'" button.';
		$txt[1] = 'Warning: this smart contract call can only be made once.';

		$theStr='';
		// Now the initialize section
		$theStr.= '<div id="'.$secId.'Id" style="'.$theStyle.'" hidden>'; // 
		$theStr.= '<h3>'.$secTitle.'</h3>';
		$theStr.= '<div id="ContractAddrId"></div>';
		$theStr.= '<p>'.$txt[0].'</p>';

		$theStr.=self::writePayInitalizeData();

		$theStr.= '<p>'.$txt[1].'</p>';
		$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="payInitalize()" disabled> '.$btnName.' </button>';

		$theStr.='<div id="'.$secId.'TrxnId" class="natural" style="margin-top: 5px" hidden></div>';

		$theStr.=self::runWithContinueBtn('pay'); // "project"
		$theStr.='</div>';

		// error block for ownership check
		$txterr = array();
		$txterr[0] = 'You must be either the Titled or Owner of the project to update it.';
		$theStr.=self::runWithErrorSec($secId,$theStyle,$secTitle,$txterr[0]);

		return $theStr;
	}


	private function runWithContinueBtn($_sub) {
	
		$secId = 'continue'.$_sub; // +Param1Id, +Param2Id, +BtnId

		$btnName = 'Continue';

		$txt = 'After the blockchain transaction completes, click the '.$btnName.' button.';

		$theStr='<div>';
		// stuff for building the URL
		$theStr.='<div id="'.$secId.'Param1Id" hidden>'.$this->gData['siteURL'].'dsn/tools/</div>';
		$theStr.='<div id="'.$secId.'Param2Id" hidden>'.$this->gData['file'].'</div>';

		$theStr.='<p>'.$txt.'</p>';

		$func = "continueHandler('pay')";
		if( 'deploy' == $_sub) {
			$func = "continueHandler('deploy')";
		} else if ('update' == $_sub ) {
			$func = "continueHandler('update')";
		}
		$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="'.$func.'" disabled> '.$btnName.' </button>'; // 
		$theStr.='</div>';
		return $theStr;
	}

	private function runWithProjectUpdateBtn() {

		$secId = 'projectUpdate'; // either +Id or +ErrId or +btnId
		$theStyle = 'padding:15px;background-color:#dce6f5'; //

		$secTitle = 'Initialize or Update the Smart Contract';
		$btnName = 'Register JSON File';

		$txt = array();
		$txt[0] = 'To register the current JSON file to the given contract, click the "'.$btnName.'" button.';
		$txt[1] = 'You must be either the Titled or Owner of the smart contract to update it.';

		$theStr='';
		$theStr .='<div id="'.$secId.'Id" style="'.$theStyle.'" hidden>';
		$theStr.= '<h3>'.$secTitle.'</h3>';
		$theStr.= '<div id="'.$secId.'AddrId"></div>';
		$theStr.= '<p>'.$txt[0].'</p>';

		$theStr.=self::writeProjectUpdateData();

		$theStr.='<button id="'.$secId.'BtnId" class="land" onClick="projectUpdate()" disabled> '.$btnName.' </button>'; // 

		$theStr.='<div id="'.$secId.'TrxnId" class="natural" style="margin-top: 5px" hidden></div>';

		$theStr.=self::runWithContinueBtn('update');

		$theStr.=self::runWithErrorSec($secId,$theStyle,$secTitle,$txt[1]);
		$theStr.='</div>';
		return $theStr;
	}


	private function runWithErrorSec($_secId,$_theStyle,$_secTitle,$_str) {
		$theStr='';
		$theStr .='<div id="'.$_secId.'ErrId" style="'.$_theStyle.'" hidden>'; // 
		$theStr.= '<h3>'.$_secTitle.'</h3>';
		$theStr.= '<p>'.$_str.'</p>';
		$theStr.='</div>';
		return $theStr;
	}



	private function buildBaseSec($_siteURL,$_locRoot) {
		$theABIURL = $_locRoot.'_abi.json';
		$theABILink = '<a href="'.$theABIURL.'" target=_self>'.$theABIURL.'</a>';

		$theByteCodeURL = $_locRoot.'_bytecode.txt';
		$theByteCodeLink = '<a href="'.$theByteCodeURL.'" target=_self>'.$theByteCodeURL.'</a>';

		$theStr ='<center><div id="galleryBaseId" style="margin-top: 10px;margin-bottom: 10px" >'; // hidden
		$theStr.='<h3>Smart Contract Data for ThetaScan.</h3>';

		// the ABI image
		$toolsABIId = 'toolsABIId';
		$toolsABIImageId = 'toolsABIImageId';
		$toolsABISrc = $_siteURL.'dsn/images/abi_small.png';

		$theABIStr = '<span style="padding: 10px">';
		$theABIStr .= '<span class="natural" id="'.$toolsABIId.'" hidden>'.$theABIURL.'</span>';
		$theABIStr .= '<img height="25" id="'.$toolsABIImageId.'" src="'.$toolsABISrc.'" onclick="toolsABI()">';
		$theABIStr .= "<span id='".$toolsABIId."' ></span>";
		$theABIStr .= "</span>";

		// the bytecode image
		$toolsBCId = 'toolsBCId';
		$toolsBCImageId = 'toolsBCImageId';
		$toolsBCSrc = $_siteURL.'dsn/images/bc_small.png';

		$theBCStr = '<span style="padding: 10px">';
		$theBCStr .= '<span class="natural" id="'.$toolsBCId.'" hidden>'.$theByteCodeURL.'</span>';
		$theBCStr .= '<img height="25" id="'.$toolsBCImageId.'" src="'.$toolsBCSrc.'" onclick="toolsBC()">';
		$theBCStr .= "<span id='".$toolsBCId."' ></span>";
		$theBCStr .= "</span>";

		$theStr .= $theABIStr;
		$theStr .= $theBCStr;

		$theStr.='<div>';
		$theStr.='<div class="natural">'.$this->gData['customRoot'].'</div>';
		$theStr.='<div class="natural">'.$this->gData['customName'].'</div>';
		$theStr.='<div class="natural">'.$this->gData['customHash'].'</div>';
		$theStr.='</div>';

		$theStr.='</div></center>';
		return $theStr;
	}

	// Builds the section that shows the ABI, Bytecode and three parameters.
	private function buildBase($_type) {

		// default to project
		$siteURL = $this->gData['siteURL'];
		$theRoot = $siteURL.'nfts/'.$this->gData['customName'].'/project/'.$this->gData['customName'];
		if( 'galleryv2'== $_type) {
			$siteURL = $this->gData['siteURL'];
			$theRoot = $siteURL.'src/galleryv2/project/galleryv2';
		}
		return self::buildBaseSec($siteURL, $theRoot);
	}

	private function blueRibbon() {
		$secId = 'blueRibbonId';

		$recordImgId = "blueRibbonImgId";
		$recordSize = 32; //24;
		$recordSrc = $GLOBALS['theRootURL'].'/dsn/images/verified_small.png';
		$recordImg = '<img id="'.$recordImgId.'" height="'.$recordSize.'" src="'.$recordSrc.'" >';

		$theStr='';
		$theStr.='<center id="'.$secId.'" hidden><div>'.$recordImg.'</div></center>';
		return $theStr;
	}

	private function buildStructure($_type) {

		$txt = array();
		$txt[0] = '* Metamask is required for deploying smart contracts.';

		$theStr = '';
		$theStr.='<center>';
		$theStr.='<div style="width:80%;padding: 0px 10px 2px 10px">';
		$theStr.='<hr style="margin: 5px;width:50%">';

		$msg = 'Visitor cannot write to contract, check active Metamask account.';
		$theStr.='<center><div id="noPrivilegesId" style="margin-top: 10px;margin-bottom: 10px" hidden>'.$msg.'</div></center>';

		// need a blue ribbon section
		$theStr.=self::blueRibbon();

		// a project also might need to set the pay variables.
		$theStr.=self::runWithDeployBtn($_type);
		if( 'project' == $_type ) {
			$theStr.=self::runWithProjectIPay();
		} 
		$theStr.=self::runWithProjectUpdateBtn();

		// This is the 'metamask is required...' line
		$theStr.= '<p><i>'.$txt[0].'</i></p>';
		$theStr.='</div>';
		$theStr.='</div>';
		$theStr.='</center>';

		return $theStr;
	}


	private function handleProcess($_type) {
		// get the globals associated with the URL
		//self::readURL();

		$theStr = '';
/*
		// we're processing a project'
		$theStr.='<div id="toolsTypeId" hidden>'.$_type.'</div>';
		if( true == $this->gData['error'] ) {
			$theStr.='<center><div style="margin-top: 10px;margin-bottom: 10px">ERROR: '.$this->gData['msg'].'</div></center>';
			return $theStr;
		}
*/
		if( 'project' == $_type ) {
			self::validateProjectFile();
		} elseif( 'galleryv2' == $_type ) {
			self::validateGalleryFile();
		} else {
			$this->gData['error']=true;
			$this->gData['msg']='ERROR: handleProcess consuming unknown type.';
		}
		if( true == $this->gData['error'] ) {
			$theStr.='<center><div style="margin-top: 10px;margin-bottom: 10px">ERROR: '.$this->gData['msg'].'</div></center>';
			return $theStr;
		}

		// If there is a contract on the URL, we're going to check that address out too
		if( self::validateContractURL() ) {
			$theStr.=self::writeContractData();
		}

		// At this point, we've validated that the project file holds
		// the values that we're expecting.
		$theStr .= self::dumpFile($_type);

		// This is the interactive section for the user.
		$theStr .= self::buildStructure($_type);

		// Show the ThetaScan info and raw data.
		$theStr .= self::buildBase($_type);
		$theStr .= self::RawData();
		return $theStr;
	}

	public function thePage($_arrParams)
	{
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		echo "<!DOCTYPE html>";

		$theTitle = "AmorStyle DApp";
		$theDesc = "Distributed Sales Network with Custom NFTs.";

		echo $dsncommon->headerInfo($theTitle,$theDesc);

		// load project common functionality
		$theCommonJSFile = $this->gData['root'].'dsncommon.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theCommonJSFile."' defer></script>";

		// When we add script for the client machine to fetch, it has to be built off
		// the URL (theRootUR). 

		$theVJSFile = $this->gData['root'].'tools/tools.js';
		//var_dump($theVJSFile);
		echo "<script type='text/javascript' src='".$theVJSFile."' defer></script>";

		//
		// Start of the body here...
		//
		echo "<body>";
		echo $dsncommon->theCSS();
		echo '<div class="blackout" id="blackoutId" >';
		echo self::globalHTML();

		//var_dump($this->gData);
		//echo '<br>';

		// Here is were the page gets built. 
		echo $dsncommon->connectRow(null);
		echo $dsncommon->errorRow();

		// for JavaScript errors:
		$errStr = '<center><div class="natural" id="toolsErrId" hidden>';
		$errStr.= '<span ><font color="red" >Msg: </font></span><span id="toolsErrMsgId" ></span>';
		$errStr.= '</div></center>';
		echo $errStr;

		// Every JSON file used in this project will get hashed so that the projectUpdate() 
		// variables can be displayed.

		// here is where each of the different types of JSON files are parsed out.
/*
		if( $this->gData['type'] == 'project') {
			echo self::handleProcess('project');

		} else if( $this->gData['type'] == 'gallery') {
			echo self::handleProcess('galleryv2');

		} else 
*/
		if( $this->gData['type'] == 'token') {
			echo '<div style="margin-bottom: 15px">';
			echo self::processPU(false);
			if( false == $this->gData['error']) {
				echo self::processAsToken();
			}
			echo '</div>';
		} else if( $this->gData['type'] == 'reel') {
			echo '<div style="margin-bottom: 15px">';
			echo self::processPU(false);
			if( false == $this->gData['error']) {
				echo self::processAsReel();
			}
			echo '</div>';
		} else if( $this->gData['type'] == 'record') {
			echo '<div style="margin-bottom: 15px">';
			echo self::processPU(true);
			if( false == $this->gData['error']) {
				echo self::processAsRecord();
			}
			echo '</div>';
		} else if( $this->gData['type'] == 'docs') {
			echo '<div style="margin-bottom: 15px">';
			echo self::processDocs();
			echo '</div>';
		} else if( $this->gData['type'] == 'unknown') {
			echo '<div style="margin-bottom: 15px">';
			self::readURL();
			if( false == $this->gData['error'] ) {
				if( isset($this->gData['dataObj']['sntype'])) {
					//echo 'sntype: '.$this->gData['dataObj']['sntype'].'<br>';
					if( 'project' == $this->gData['dataObj']['sntype'] ) {
						echo self::handleProcess($this->gData['dataObj']['sntype']);
					} elseif( 'galleryv2' == $this->gData['dataObj']['sntype'] ) {
						echo self::handleProcess($this->gData['dataObj']['sntype']);
					} else {
						echo 'ERROR: unknown "sntype" in file.<br>';
					}
				} else {
					echo 'ERROR: missing "sntype" entry in JSON file. Set to either "project" or "galleryv2"<br>';
				}
				// we're going off the snType in the file.'
			} else {
				echo 'ERROR: Unable to read JSON file.';
			}
			echo '</div>';
 		}else {
			echo "Invalid type specified.<br>";
		}

		echo $dsncommon->theFooter();
		echo "</div>";
		echo "</body>";
		echo "</html>";
	}
}


