let arrGlobals = [];

function readItem(_item, _asNumber) {
    let g_object;
    //console.log('reading: ' + _item + "Id");
    g_object = document.getElementById(_item + "Id");
    if (null != g_object) {
        if (_asNumber) {
            arrGlobals[_item] = Number(g_object.innerHTML);
        } else {
            arrGlobals[_item] = g_object.innerHTML;
        }
        if (arrGlobals['debugjs'] >= 1) { console.log(_item + ': ' + arrGlobals[_item]); }
    } else {
        console.log('g_object=null');
    }
}

function readGlobals() {

    // now 
    readItem('debugjs', true);
    readItem('siteURL', false);
    readItem('path', false);
    readItem('root', false);
    readItem('participantAddr', false);
    readItem('agentAddr', false);
    readItem('websiteAddr', false);

    readItem('agent', true);
    readItem('theTitle', false);

    readItem('GalleryAddr', false); // is there a default gallery
    readItem('contractAddr', false); // did user specify gallery
}


let g_accounts = [];

document.getElementById('walletAddress').innerHTML = '<span id="connectId" style="line-height:40px">Connect</span>';
arrGlobals['BalanceTfuel'] = null; // amount of Tfuel in account

document.addEventListener("DOMContentLoaded", async function () {
    console.log("In JavaScript video routine");

    readGlobals();

    // Set the title of the page
    document.getElementById("titleId").innerHTML = arrGlobals['theTitle'];
    // We are on the tools page, thus do not display the tools icon
    let theIconObj = document.getElementById('toolsIconId');
    if (null != theIconObj) {
        theIconObj.style.display = 'none';
    }

    //TODO: We will check to see if the visitor is connected to metamask.
    // if so, we'll be able to deploy and setup contracts. If not, we'll 
    // just show basic functionality.

    window.web3 = null;
    if (window.ethereum) {
        await window.ethereum.request({ method: 'eth_accounts' });
        window.web3 = new Web3(window.ethereum);

        // first thing it to check chain id.
        var id = await web3.eth.getChainId();
        if (id != 361) {
            console.log("not Theta network");
            wrongNetwork();
        } else {
            console.log('correct network');

            g_accounts = await web3.eth.getAccounts();
            //console.log('number of accounts: ' + g_accounts.length);
            //console.log(g_accounts);
            arrGlobals['visitor'] = g_accounts[0];

            try {
                //console.log('getting balance');
                await web3.eth.getBalance(arrGlobals['visitor']).then(g_accountBalanceWei => {
                    // When we get our response, we'll calculate our balance and display what we can.
                    console.log("Balance: " + g_accountBalanceWei);
                    balance = Number(BigInt(g_accountBalanceWei) / BigInt(10000000000000000)) / 100;
                    arrGlobals['BalanceTfuelWei'] = g_accountBalanceWei;
                    arrGlobals['BalanceTfuel'] = balance;
                    button = '<span style="font-size:1em;"><center><b>';
                    accountShort = arrGlobals['visitor'].substring(0, 5).concat('...', arrGlobals['visitor'].substring(38, 42));
                    button = button.concat(accountShort, ' </b><br> <img src=\'https://www.thetascan.io/tfuel_dapp.png\'><span style="font-size:0.90em;"> ', arrGlobals['BalanceTfuel'], ' </span></center></span>');
                    document.getElementById('walletAddress').innerHTML = button
                });
            } catch (error) { }

            console.log("The Account: " + arrGlobals['visitor']);

            // In order to play, the visiting address needs to hold a participant NFT
            // in the active account. 
            let okPart = await partProject(window.web3);
            if (okPart) {
                //console.log('active account can launch contract');
                toolsWork();
            } else {
                // http://localhost/amorstyle/dsn/?contract=0xd1ccd1983e010aa4319631b8e2b2a25bd62d4bae
                // if the visitor has metamask but no participant, let's send them 
                // to the enter page.
                let href = arrGlobals['root'] + '?contract=' + arrGlobals['participantAddr'];
                let link = '<a href="' + href+'" target="_self">Get Participant NFT</a>';
                toolsErrorMsg('Visitor does not hold a Participant NFT.<br>' + link +'<br>(Click Enter button)');
            }

            console.log(arrGlobals);
        }
    } else {
        noMetamask();
    }
});

function toolsErrorMsg($_msg) {

    let theErrMsgObj = document.getElementById('toolsErrMsgId'); // Msg
    if (null != theErrMsgObj) {
        theErrMsgObj.innerHTML = $_msg;
    }

    let theErrObj = document.getElementById('toolsErrId'); // block
    if (null != theErrObj) {
        theErrObj.style.display = 'block';
    }
}

// This routine queries the participant NFT project to see if this address holds a token.
// Note that we serialize here because we want to know this before continuing.
async function partProject(_web3) {
    //console.log('checking: ' + arrGlobals['visitor']);

    let theABI = [];
    theABI['ABI'] = [];
    theABI['ABI'].push({ "inputs": [{ "internalType": "address", "name": "owner", "type": "address" }], "name": "balanceOf", "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }], "stateMutability": "view", "type": "function" });

    contractPart = new _web3.eth.Contract(theABI['ABI'], arrGlobals['participantAddr']);
    let resultCount = await contractPart.methods.balanceOf(arrGlobals['visitor']).call();

    let bRet = false;
    if (resultCount > 0) {
        //console.log("Holds Participant");
        arrGlobals['IsParticipant'] = true;
        bRet = true;
    } else {
        //console.log("No Participant");
        arrGlobals['IsParticipant'] = false;
        //document.getElementById("noParticipantId").style.display = 'block';
    }
    return bRet;
}



async function displayABI() {
    //console.log('flash the image here');
    let theSrc = document.getElementById("toolsABIImageId").src;
    let theCopiedSrc = theSrc.replace('.png', '_copied.png');
    document.getElementById("toolsABIImageId").src = theCopiedSrc;
    await delay(1000);
    document.getElementById("toolsABIImageId").src = theSrc;
}

async function toolsABI() {

    let srcURL = '';
    let theObj = document.getElementById("toolsABIId");
    if (null != theObj) {
        srcURL = theObj.innerHTML;
    }
    //console.log(srcURL);

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + srcURL;
    //console.log($url);
    fetch($url).then(response => {
        response.json().then(projectObj => {
            //console.log(JSON.stringify(projectObj));
            navigator.clipboard.writeText(JSON.stringify(projectObj)).then(() => {
                //console.log('clipboard successfully set');
                displayABI();

            }, () => {
                //console.log('clipboard write failed');
            });
        });
    });
}

async function displayBC() {
    //console.log('flash the image here');
    let theSrc = document.getElementById("toolsBCImageId").src;
    let theCopiedSrc = theSrc.replace('.png', '_copied.png');
    document.getElementById("toolsBCImageId").src = theCopiedSrc;
    await delay(1000);
    document.getElementById("toolsBCImageId").src = theSrc;
}

async function toolsBC() {

    let srcURL = '';
    let theObj = document.getElementById("toolsBCId");
    if (null != theObj) {
        srcURL = theObj.innerHTML;
    }
    console.log('srcURL: '+srcURL);

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + srcURL;
    //console.log($url);
    fetch($url).then(response => {
        response.json().then(projectObj => {
            let theStr = JSON.stringify(projectObj);
            //console.log(theStr);

            navigator.clipboard.writeText(theStr).then(() => {
                //console.log('clipboard successfully set');
                displayBC();

            }, () => {
               //console.log('clipboard write failed');
            });
        });
    });
}

function showDeploy() {

    let sec = 'deployProject';
    let buttonObj = document.getElementById(sec+"BtnId");
    if (null != buttonObj) {
        buttonObj.disabled = false;
    }
    // now show the section
    let deploySecObj = document.getElementById(sec+"Id");
    if (null != deploySecObj) {
        deploySecObj.style.display = 'block';
    }
}
function showIPay() {
    let sec = 'ipayProject';
    let buttonObj = document.getElementById(sec + "BtnId");
    if (null != buttonObj) {
        buttonObj.disabled = false;
    }
    // now show the section
    let deploySecObj = document.getElementById(sec + "Id");
    if (null != deploySecObj) {
        deploySecObj.style.display = 'block';
    }
}
function showProjectUpdate() {
    let sec = 'projectUpdate';
    let buttonObj = document.getElementById(sec + "BtnId");
    if (null != buttonObj) {
        buttonObj.disabled = false;
    }
    // now show the section
    let deploySecObj = document.getElementById(sec + "Id");
    if (null != deploySecObj) {
        deploySecObj.style.display = 'block';
    }
}
function showPayInitalize() {
    let sec = 'payInitalize';
    let buttonObj = document.getElementById(sec + "BtnId");
    if (null != buttonObj) {
        buttonObj.disabled = false;
    }
    // now show the section
    let deploySecObj = document.getElementById(sec + "Id");
    if (null != deploySecObj) {
        deploySecObj.style.display = 'block';
    }
}
function showBlueRibbon() {
    let sec = 'blueRibbon';
    let deploySecObj = document.getElementById(sec + "Id");
    if (null != deploySecObj) {
        deploySecObj.style.display = 'block';
    }
}

//
// When we get here, we know that the visitor holds a participant NFT and
// we need to enable some section. 
//
async function toolsWork() {
    console.log('toolsWork');

    // When handling the state changes for a basic project, we're first going
    // to read the values that we expect and then test where we're at in order
    // to show the appropriate section.
    readDeployBasic();
    readProjectUpdate();
    readPayInitalize();
    readContract();

    // if arrGlobals['contractAddr'] is empty, we don't have a contract yet.
    if ('' == arrGlobals['contractAddr']) {
        //console.log('need deploy functionality');
        showDeploy();

    } else {
        console.log('we have contract, what state are we in?');

        // First check is to make sure the visitor can actually write to this contract.
        if ((arrGlobals['visitor'].toLowerCase() != arrGlobals['readContract']['contractOwner'].toLowerCase()) &&
            (arrGlobals['visitor'].toLowerCase() != arrGlobals['readContract']['contractTitled'].toLowerCase())) {
            // hey, visitor can not write to this contract!

            console.log('visitor has no privileges on this contract.');
            // MSG: you must be the contract owner to update it.

            let regErrObj = document.getElementById("noPrivilegesId");
            if (null != regErrObj) {
                regErrObj.style.display = 'block';
            }
            return;
        }

        // If the hash on the contract matches the hash of this current JSON file,
        // there is nothing to do (no changes).
        if (arrGlobals['readContract']['contractHash'].toLowerCase() == arrGlobals['projectUpdate']['_hash'].toLowerCase()) {
            // show a blue ribbon, nothing to do.
            //console.log('show blue ribbon, no work to do.');
            showBlueRibbon();
            return;
        }

        console.log('There is work to do.');
        // just confirm that it's deployed
        if (!arrGlobals['readContract']['contractIsDeployed']) {
            console.log('contractIsDeployed should be true.');
            return;
        }

        // is this contract an IPay* contract?
        if (arrGlobals['readContract']['contractIsIPay']) {
            // why, yes it is. Have commissions been set yet?
            if (!arrGlobals['readContract']['contractIsActive']) {
                // commissions have not been set on this contract, set them
                console.log('show commissions section!');
                showPayInitalize();
                return;
            }
        }

        // last thing is to show projectUpdate section.
        console.log('show projectUpdate section');
        showProjectUpdate();
    }
}


// The PHP will have put a URL in this _theId location. That URL represents
// a file that can be read and interpreted as JSON data.
async function idToJson(_theId) {

    let theJSON = null;
    // get the item to fetch.
    let srcURL = '';
    let theObj = document.getElementById(_theId);
    if (null != theObj) {
        srcURL = theObj.innerHTML;
    }
    if (arrGlobals['debugjs'] >= 1) {
        console.log('srcURL: ' + srcURL);
    }

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + srcURL;
    //console.log($url);
    let theStr = '';
    let responseABI = await fetch($url);
    if (null != responseABI) {
        theJSON = await responseABI.json();
        if (null != theJSON) {
            theStr = JSON.stringify(theJSON);
        }
    }
    // The amount of data overwhelms the console.log
    if (arrGlobals['debugjs'] >= 1) {
        console.log(theStr.substring(0, 20) + '...' + theStr.substring(theStr.length - 20));
    }
    return theJSON;
}

//
// The visitor clicked the "Deploy this Gallery" button on the tools page. Let's
// get this info to Metamask and capture the address returned on success.
//
let giCount;

//
// When we're polling for deployment info, we need to make sure we handle the completion
// process correctly. 
//
async function getContract(transactionHash) {
    //console.log('getContract()');
    //console.log('txnHash: ' + transactionHash);

    giCount++;
    var contract = 0;
    var url = "https://eth-rpc-api.thetatoken.org/rpc";
    var postData = { jsonrpc: "2.0", method: "eth_getTransactionReceipt", params: [transactionHash], id: 1 }
    fetch(url, { method: "POST", headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(postData) })
        .then(res => res.json())
        .then(function (data) {
            try {
                console.log(data);
                contract = JSON.stringify(data["result"]["contractAddress"]);
                //console.log('contract: '+data["result"]["contractAddress"]);
                contract = contract.replace(/\"/g, '');
                //console.log('contract2: ' + contract);
            } catch{ }
            if (contract == 0) {
                if (giCount < 15) {
                    function checkTimer() { getContract(transactionHash); } setTimeout(checkTimer, 3000);
                    //console.log('Keep waiting');
                } else {
                    console.log('Polling giCount: ' + giCount);
                }
            } else {

                console.log('contract:' + contract);

                let theTrxn = document.getElementById('deployProjectTrxnId');
                if (null != theTrxn) {
                    // https://explorer.thetatoken.org/txs/0x1f6f9b14762fcd80b1b1257cad7f52f682328534f171c7445080387af661e040
                    let theHref = 'https://explorer.thetatoken.org/txs/' + transactionHash;
                    let theLink = '<a href="'+theHref+'" target="_blank">Trxn Hash</a>';
                    theTrxn.innerHTML = theLink;
                    // now show the item
                    theTrxn.style.display = 'block';

                }

                let theContract = document.getElementById('deployProjectAddrId');
                if (null != theContract) {
                    // https://explorer.thetatoken.org/account/0x9d039e337e7edf45cef6772cb9eaf702cc169069
                    let theHref = 'https://explorer.thetatoken.org/account/' + contract;
                    let theLink = '<a href="'+theHref+'" target="_blank">'+contract+'</a>';
                    theContract.innerHTML = 'Contract Address: '+theLink;
                    // now show the item
                    theContract.style.display = 'block';

                    // save for later
                    arrGlobals['contractAddr'] = contract;
                }

                let theContract2 = document.getElementById('deployProjectContractAddrId');
                if (null != theContract2) {
                    theContract2.innerHTML = contract;
                    console.log('contractAddr: ' + contract);
                }

                // Now disable the button that the user just pressed.
                let theDeployBtn = document.getElementById('deployProjectBtnId');
                if (null != theDeployBtn) {
                    theDeployBtn.disabled = true;
                }

                // enable the redirect button
                let theRedirect = document.getElementById('continuedeployBtnId');
                if (null != theRedirect) {
                    theRedirect.disabled = false;
                }

                document.body.style.cursor = 'default';
            }
        }).catch((error) => {
            console.log(error);
            function checkTimer2() { getContract(transactionHash); } setTimeout(checkTimer2, 3000);

            document.body.style.cursor = 'default';
        });
}


//
// we need two parameters for deploying a new gallery.
// arrGlobals['deployBasic']['_theTitled']
// arrGlobals['deployBasic']['_thePennyOracle']
//
async function deployGallery() {
    console.log('deployGallery');

    let theABIJSON = await idToJson("toolsABIId");
    let theBCJSON = await idToJson("toolsBCId");

    var argumentsVar = [];
    if (web3.length < 8) {
        connect();
        return;
    }

    if (await IsCorrectNetwork()) {
        var abi = theABIJSON;
        //console.log(theABIJSON);
        var bytecode = theBCJSON['object'];
        //console.log(theBCJSON['object']);
        //console.log(bytecode.substring(0, 20) + '...' + bytecode.substring(bytecode.length - 20));

        argumentsVar[0] = arrGlobals['deployBasic']['_theTitled'];
        argumentsVar[1] = arrGlobals['deployBasic']['_thePennyOracle'];
        console.log(argumentsVar);

        giCount = 0;

        document.body.style.cursor = 'wait';

        currentGasPrice = await web3.eth.getGasPrice();
/*
        // TODO: This section for testing.
        console.log('fake the deploy for now...');
        //transactionHash = '0x1f6f9b14762fcd80b1b1257cad7f52f682328534f171c7445080387af661e040'; // random hash
        transactionHash = '0x03631b6a2a807f28410354770a3f39fce9b6018acc26a279e8efa8e5fc446122';
        getContract(transactionHash);
        // TODO: End test section
*/

        const contract = new web3.eth.Contract(abi);
        estimateGas = 175 * bytecode.length;
        contract.deploy({ data: bytecode, arguments: argumentsVar }).send(
            {
                from: arrGlobals['visitor'],
                gas: estimateGas,
                gasPrice: currentGasPrice
            }).on('transactionHash', (transactionHash) => {
                console.log(transactionHash);
                getContract(transactionHash);
            }).catch(function (err) {
                console.log(err);
                document.body.style.cursor = 'default';
            }).catch((error) => {
                console.log(error);
                document.body.style.cursor = 'default';
            });

    }
}

//
// Need a larger collection of parameters for the launching of a basic project.
//
// arrGlobals['deployBasic']['_theTitled']
// arrGlobals['deployBasic']['_thePennyOcracle']
// _theParticipant = arrGlobals['participantAddr']
// _theAgent = arrGlobals['agentAddr']
// _theWebsite = arrGlobals['websiteAddr']
// _strProjectName = arrGlobals['deployBasic']['_strProjectName']
// _bSoulBound = (arrGlobals['deployBasic']['_bSoulbound']?Number(1):Number(0))
// _bSendLock = (arrGlobals['deployBasic']['_bSendLock']?Number(1):Number(0))
// _limit = Number(arrGlobals['deployBasic']['_limit'])
//
async function deployProject() {
    //console.log('deployProject');

    let theABIJSON = await idToJson("toolsABIId");
    let theBCJSON = await idToJson("toolsBCId");

    var argumentsVar = [];
    if (web3.length < 8) {
        connect();
        return;
    }

    if (await IsCorrectNetwork()) {
        var abi = theABIJSON;
        //console.log(theABIJSON);
        var bytecode = theBCJSON['object'];
        //console.log(theBCJSON['object']);
        //console.log(bytecode.substring(0, 20) + '...' + bytecode.substring(bytecode.length - 20));

        // build parameter list.
        argumentsVar[0] = arrGlobals['deployBasic']['_theTitled'];
        argumentsVar[1] = arrGlobals['deployBasic']['_thePennyOracle'];
        argumentsVar[2] = arrGlobals['participantAddr'];
        argumentsVar[3] = arrGlobals['agentAddr'];
        argumentsVar[4] = arrGlobals['websiteAddr'];
        argumentsVar[5] = arrGlobals['deployBasic']['_strProjectName'];
        argumentsVar[6] = (arrGlobals['deployBasic']['_bSoulbound'] ? Number(1) : Number(0));
        argumentsVar[7] = (arrGlobals['deployBasic']['_bSendLock'] ? Number(1) : Number(0));
        argumentsVar[8] = Number(arrGlobals['deployBasic']['_limit']);

        giCount = 0;

        document.body.style.cursor = 'wait';

        currentGasPrice = await web3.eth.getGasPrice();

        console.log(argumentsVar);
/*
// When testing...
        // TODO: This section for testing.
        //transactionHash = '0x1f6f9b14762fcd80b1b1257cad7f52f682328534f171c7445080387af661e040'; // random hash
        transactionHash = '0x03631b6a2a807f28410354770a3f39fce9b6018acc26a279e8efa8e5fc446122';
        getContract(transactionHash);
        // TODO: End test section
*/
// When running....
        const contract = new web3.eth.Contract(abi);
        estimateGas = 175 * bytecode.length;
        contract.deploy({ data: bytecode, arguments: argumentsVar }).send(
            {
                from: arrGlobals['visitor'],
                gas: estimateGas,
                gasPrice: currentGasPrice
            }).on('transactionHash', (transactionHash) => {
                console.log(transactionHash);
                getContract(transactionHash);
            }).catch(function (err) {
                console.log(err);
                document.body.style.cursor = 'default';
            }).catch((error) => {
                console.log(error);
                document.body.style.cursor = 'default';
            });

// End test block...
    }
}


async function IsCorrectNetwork() {
    var id = await web3.eth.getChainId();
    if (id != 361) {
        alert('MetaMask is not connected to the Theta Network. Please reconnect to the Theta Network.');
        return false;
    }
    return true;
}

//
// Used to call projectUpdate()
//
async function projectUpdate() {
    console.log('projectUpdate()');

    let theABIJSON = await idToJson("toolsABIId");

    console.log('Addr: ' + arrGlobals['contractAddr']);

    if (await IsCorrectNetwork()) {

        // now the writing process...
        document.body.style.cursor = 'wait';

        const contract = new web3.eth.Contract(theABIJSON, arrGlobals['contractAddr']);
        let currentGasPrice = await web3.eth.getGasPrice();
        console.log('_URI: ' + arrGlobals['projectUpdate']['_URI']);
        console.log('_Project: ' + arrGlobals['projectUpdate']['_Project']);
        console.log('_hash: ' + arrGlobals['projectUpdate']['_hash']);
/*
// When testing...
        console.log('pretend to do work.');
        transactionHash = '0x03631b6a2a807f28410354770a3f39fce9b6018acc26a279e8efa8e5fc446122';

        var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + transactionHash + '" target="_blank">Trxn Link & Hash</a>';
        console.log(transactionRef);
        let theTrxn = document.getElementById('projectUpdateTrxnId');
        if (null != theTrxn) {
            theTrxn.innerHTML = transactionRef;
            // now show the item
            theTrxn.style.display = 'block';
        }
*/
// when running...

        await contract.methods.projectUpdate(
                arrGlobals['projectUpdate']['_URI'],
                arrGlobals['projectUpdate']['_Project'],
                arrGlobals['projectUpdate']['_hash']).send({
            from: arrGlobals['visitor'],
            gasPrice: currentGasPrice
        }).on('error', (error) => {
            console.log('on handler');
            console.log(error);
        }).then(tx => {
            //console.log(tx);
            var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
            console.log(transactionRef);
            //dataObj.innerHTML = transactionRef;

            let theTrxn = document.getElementById('projectUpdateTrxnId');
            if (null != theTrxn) {
                theTrxn.innerHTML = transactionRef;
                // now show the item
                theTrxn.style.display = 'block';
            }
        });

// End test block...
        document.body.style.cursor = 'default';
    }
}

//
// Used to call payInitalize(). This routine requires the following parameters:
// _mintPennies
// _timeoutDays
// _minCount
// _cutPercentAgent
// _cutPercentWebsite
//
async function payInitalize() {
    console.log('payInitalize()');

    let theABIJSON = await idToJson("toolsABIId");

    console.log('Addr: ' + arrGlobals['contractAddr']);

    if (await IsCorrectNetwork()) {

        // now the writing process...
        document.body.style.cursor = 'wait';

        const contract = new web3.eth.Contract(theABIJSON, arrGlobals['contractAddr']);
        let currentGasPrice = await web3.eth.getGasPrice();
        console.log('_mintPennies: ' + arrGlobals['PayInitalize']['_mintPennies']);
        console.log('_timeoutDays: ' + arrGlobals['PayInitalize']['_timeoutDays']);
        console.log('_minCount: ' + arrGlobals['PayInitalize']['_minCount']);
        console.log('_cutPercentAgent: ' + arrGlobals['PayInitalize']['_cutPercentAgent']);
        console.log('_cutPercentWebsite: ' + arrGlobals['PayInitalize']['_cutPercentWebsite']);
/*
// When testing...
        console.log('pretend to do work.');
        transactionHash = '0x03631b6a2a807f28410354770a3f39fce9b6018acc26a279e8efa8e5fc446122';

        var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + transactionHash + '" target="_blank">Trxn Link & Hash</a>';
        console.log(transactionRef);

        let theTrxn = document.getElementById('payInitalizeTrxnId');
        if (null != theTrxn) {
            theTrxn.innerHTML = transactionRef;
            // now show the item
            theTrxn.style.display = 'block';
        }
        // enable the redirect button
        let theRedirect = document.getElementById('continuepayBtnId');
        if (null != theRedirect) {
            theRedirect.disabled = false;
        }
*/
// When running...
        
        await contract.methods.payInitalize(
            arrGlobals['PayInitalize']['_mintPennies'],
            arrGlobals['PayInitalize']['_timeoutDays'],
            arrGlobals['PayInitalize']['_minCount'],
            arrGlobals['PayInitalize']['_cutPercentAgent'],
            arrGlobals['PayInitalize']['_cutPercentWebsite']).send({
                from: arrGlobals['visitor'],
                gasPrice: currentGasPrice
            }).on('error', (error) => {
                console.log('on handler');
                console.log(error);
            }).then(tx => {
                //console.log(tx);
                var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                console.log(transactionRef);
                //dataObj.innerHTML = transactionRef;

                let theTrxn = document.getElementById('PayInitalizeTrxnId');
                if (null != theTrxn) {
                    theTrxn.innerHTML = transactionRef;
                    // now show the item
                    theTrxn.style.display = 'block';
                }

                // enable the redirect button
                let theRedirect = document.getElementById('continuepayBtnId');
                if (null != theRedirect) {
                    theRedirect.disabled = false;
                }

            });
        
// End test block...
        document.body.style.cursor = 'default';
    }
}

//
// When the visitor clicks the 'continue' button, they end up here.
// 
function continueHandler(_sub) {

    let secId = 'continue' + _sub;

    // the site
    let r1Str = '';
    let r1Obj = document.getElementById(secId+"Param1Id");
    if (null != r1Obj) {
        r1Str = r1Obj.innerHTML;
        console.log(r1Str);
    }

    // The file
    let r2Str = '';
    let r2Obj = document.getElementById(secId +"Param2Id");
    if (null != r2Obj) {
        r2Str = r2Obj.innerHTML;
        console.log(r2Str);
    }

    let theURL = r1Str + '?file=' + r2Str + '&contract=' + arrGlobals['contractAddr'];
    console.log(theURL);
    window.location.href = theURL;
}


//
// In order to deploy a basic contract, we've got to have the basic 
// parameters. We read those off the page here.
//
function readDeployBasic() {
    //console.log('readDeployBasic');

    arrGlobals['deployBasic'] = [];

    let elObj = document.getElementById("_theTitledId");
    if (null != elObj) {
        arrGlobals['deployBasic']['_theTitled'] = elObj.innerHTML;
    }
    elObj = document.getElementById("_thePennyOracleId");
    if (null != elObj) {
        arrGlobals['deployBasic']['_thePennyOracle'] = elObj.innerHTML;
    }
    elObj = document.getElementById("_strProjectNameId");
    if (null != elObj) {
        arrGlobals['deployBasic']['_strProjectName'] = elObj.innerHTML;
    }
    elObj = document.getElementById("_bSoulboundId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['deployBasic']['_bSoulbound'] = true;
        } else {
            arrGlobals['deployBasic']['_bSoulbound'] = false;
        }
    }
    elObj = document.getElementById("_bSendLockId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['deployBasic']['_bSendLock'] = true;
        } else {
            arrGlobals['deployBasic']['_bSendLock'] = false;
        }
    }
    elObj = document.getElementById("_limitId");
    if (null != elObj) {
        arrGlobals['deployBasic']['_limit'] = Number(elObj.innerHTML);
    }
}

//
// In order to update a project with a new JSON file, we've got to read
// a few values off the page. 
//
function readProjectUpdate() {
    //console.log('readProjectUpdate');

    arrGlobals['projectUpdate'] = [];

    let elObj = document.getElementById("_URIId");
    if (null != elObj) {
        arrGlobals['projectUpdate']['_URI'] = elObj.innerHTML;
    }
    elObj = document.getElementById("_ProjectId");
    if (null != elObj) {
        arrGlobals['projectUpdate']['_Project'] = elObj.innerHTML;
    }
    elObj = document.getElementById("_hashId");
    if (null != elObj) {
        arrGlobals['projectUpdate']['_hash'] = elObj.innerHTML;
    }
    //TODO: for testing
    //arrGlobals['projectUpdate']['_hash'] = "50fb65b6d4402522d2f72195647e68b7718b232d";
}

function readPayInitalize() {
    //console.log('readPayInitalize');

    arrGlobals['PayInitalize'] = [];

    let elObj = document.getElementById("_mintPenniesId");
    if (null != elObj) {
        arrGlobals['PayInitalize']['_mintPennies'] = Number(elObj.innerHTML);
    }
    elObj = document.getElementById("_timeoutDaysId");
    if (null != elObj) {
        arrGlobals['PayInitalize']['_timeoutDays'] = Number(elObj.innerHTML);
    }
    elObj = document.getElementById("_minCountId");
    if (null != elObj) {
        arrGlobals['PayInitalize']['_minCount'] = Number(elObj.innerHTML);
    }
    elObj = document.getElementById("_cutPercentAgentId");
    if (null != elObj) {
        arrGlobals['PayInitalize']['_cutPercentAgent'] = Number(elObj.innerHTML);
    }
    elObj = document.getElementById("_cutPercentWebsiteId");
    if (null != elObj) {
        arrGlobals['PayInitalize']['_cutPercentWebsite'] = Number(elObj.innerHTML);
    }
}
/*
-contractOwnerId - the owner() of the contract
-contractTitledId - the titled() of the contract
-contractIsDeployedId - has the contract been deployed?
-contractIsIPayId - does this contract use IPay?
-contractActiveId - Is contract ready to use?
-contractProjectActiveId - has projectUpdate() been called?

contractURLId - contract URL
contractNameId - contract name
contractHashId - hash on contract.
*/
function readContract() {
    //console.log('readContract');

    arrGlobals['readContract'] = [];

    let elObj = document.getElementById("contractOwnerId");
    if (null != elObj) {
        arrGlobals['readContract']['contractOwner'] = elObj.innerHTML;
    }
    elObj = document.getElementById("contractTitledId");
    if (null != elObj) {
        arrGlobals['readContract']['contractTitled'] = elObj.innerHTML;
    }
    elObj = document.getElementById("contractIsDeployedId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['readContract']['contractIsDeployed'] = true;
        } else {
            arrGlobals['readContract']['contractIsDeployed'] = false;
        }
    }
    elObj = document.getElementById("contractIsIPayId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['readContract']['contractIsIPay'] = true;
        } else {
            arrGlobals['readContract']['contractIsIPay'] = false;
        }
        //TODO: for testing....
        //arrGlobals['readContract']['contractIsIPay'] = true;
    }
    elObj = document.getElementById("contractActiveId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['readContract']['contractIsActive'] = true;
        } else {
            arrGlobals['readContract']['contractIsActive'] = false;
        }
        // TODO: For testing
        //arrGlobals['readContract']['contractIsActive'] = false;
    }
    elObj = document.getElementById("contractProjectActiveId");
    if (null != elObj) {
        if (elObj.innerHTML === 'true') {
            arrGlobals['readContract']['contractProjectIsActive'] = true;
        } else {
            arrGlobals['readContract']['contractProjectIsActive'] = false;
        }
    }

    elObj = document.getElementById("contractURLId");
    if (null != elObj) {
        arrGlobals['readContract']['contractURL'] = elObj.innerHTML;
    }
    elObj = document.getElementById("contractNameId");
    if (null != elObj) {
        arrGlobals['readContract']['contractURL'] = elObj.innerHTML;
    }
    elObj = document.getElementById("contractHashId");
    if (null != elObj) {
        arrGlobals['readContract']['contractHash'] = elObj.innerHTML;
    }
    //TODO: for testing
    //arrGlobals['readContract']['contractHash'] = "50fb65b6d4402522d2f72195647e68b7718b232d";
}

