<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
	//echo "Yes, mobile.<br>";
} 
//$globalMobile = true;
}

// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}


//
// This is the main file that should be called for default distributed sales netowrk functionality.
// ** dsn.php should not be called directly **
//
require_once($theRootDir.'/dsn/theta.php');
require_once($theRootDir.'/src/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir.'/dsn/tools/tools.php');


// main entry
function run_the_code() {

	$arrParams = [];
/*
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['contract']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['contract']) && (strlen($_GET['contract']) == 42)) {
		$arrParams['contract']=$_GET['contract'];
		//echo "contract: ".$arrParams['contract']."<br>";
	}
*/
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}

	if( isset($_GET['project']) && (strlen($_GET['project']) <= 256) && filter_var($_GET['project'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['project'];
		$arrParams['type']="project";
		//echo "project: ".$arrParams['file']."<br>";

		// The project allows for providing a contract
		if( isset($_GET['contract']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['contract']) && (strlen($_GET['contract']) == 42)) {
			$arrParams['contract']=$_GET['contract'];
			//echo $arrParams['contract'].'<br>';
		}


	} else if( isset($_GET['token']) && (strlen($_GET['token']) <= 256) && filter_var($_GET['token'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['token'];
		$arrParams['type']="token";
		//echo "token: ".$arrParams['file']."<br>";
	} else if( isset($_GET['gallery']) && (strlen($_GET['gallery']) <= 256) && filter_var($_GET['gallery'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['gallery'];
		$arrParams['type']="gallery";
		//echo "gallery: ".$arrParams['file']."<br>";

		// The gallery allows for providing a contract
		if( isset($_GET['contract']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['contract']) && (strlen($_GET['contract']) == 42)) {
			$arrParams['contract']=$_GET['contract'];
			//echo $arrParams['contract'].'<br>';
		}

	} else if( isset($_GET['file']) && (strlen($_GET['file']) <= 256) && filter_var($_GET['file'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['file'];
		$arrParams['type']="unknown";
		//echo "determine type: ".$arrParams['file']."<br>";

		// The gallery allows for providing a contract
		if( isset($_GET['contract']) && !preg_match('/[^A-Fa-fXx0-9]/', $_GET['contract']) && (strlen($_GET['contract']) == 42)) {
			$arrParams['contract']=$_GET['contract'];
			//echo $arrParams['contract'].'<br>';
		}

	} else if( isset($_GET['reel']) && (strlen($_GET['reel']) <= 256) && filter_var($_GET['reel'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['reel'];
		$arrParams['type']="reel";
		//echo "reel: ".$arrParams['file']."<br>";
	} else if( isset($_GET['record']) && (strlen($_GET['record']) <= 256) && filter_var($_GET['record'],FILTER_VALIDATE_URL)) 
	{
		$arrParams['file']=$_GET['record'];
		$arrParams['type']="record";
		//echo "reel: ".$arrParams['file']."<br>";
	} else {
		// display documentation
		$arrParams['file']='';
		$arrParams['type']="docs";
		//echo "docs<br>";
	}

	// need to have data to proceed
	if( !isset($arrParams['file']) || !isset($arrParams['type'])) {
		echo 'Invalid URL Usage.<br>';
	} else {
		$plugin = new Theta_tools();
		$plugin->Init(null);
		$plugin->thePage($arrParams);
	}
}
run_the_code();
