<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
		$isLocal = true;
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
	//echo "Yes, mobile.<br>";
} 
//$globalMobile = true;
}

// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}

//
// This is the main file that should be called for default distributed sales netowrk functionality.
// ** dsn.php should not be called directly **
//

class Theta_setup
{
	private $data = array();

	function __construct() {
	}

	private function theCSS() {
		$theStr = '<style>
    body {
      background-color: rgb(194, 196, 196);
    }

    img.logo {
      width: 250px;
      margin-top: 60px;
    }

    button.button {
      font-size: 16px;
      padding: 5px 15px 5px 15px;
    }

</style>';
		return $theStr;
	}

	private function theHead()
	{
		$theStr = '<head>';
		$theStr.= self::theCSS();
		$theStr.= '</head>';

		return $theStr;
	}

	private function theScript()
	{
		$theStr = '<script>
async function downloadFile(_theFile) {

	// read the path "theRootDirId"
	let root = "";
    let theObj = document.getElementById("theRootDirId");
    if (null != theObj) {
		root = theObj.innerHTML;
    }

	let fullURL = root + "src/" + _theFile + "__";
	console.log(fullURL);

    fetch(fullURL, {
        method: "GET",
        headers: {
            "Content-Type": "text/plain",
            Accept: "text/plain"
        },
        mode: "cors",
        cache: "default",
    }).then(response => {
        console.log("The Fetch: ");
        console.log(response);

        //console.log("Request Headers:", response.url); // URL requested
        //console.log("Response Status:", response.status);
        //console.log("Response Content-Type:", response.headers.get("Content-Type"));

        response.blob().then(resultsblob => {

            // For the download version, just want the results to say "passed".
            console.log("Signature Results: ");
            console.log(resultsblob);

            const objectUrl = URL.createObjectURL(resultsblob);
            const link = document.createElement("a");
            link.href = objectUrl;
            link.download = _theFile;
            link.click();
            URL.revokeObjectURL(objectUrl);
        })
    });
}

async function saveDSNFile() {
	//console.log("saveDSNFile()");
	await downloadFile("dsnreadme.php");
}
async function saveGalleryFile() {
	//console.log("saveGalleryFile()");
	await downloadFile("gallery.json");
}
</script>';
		return $theStr;
	}

	private function buildFolder($_destDir)
	{
		//echo 'the file: '.$_destDir.'<br>';
		if( !file_exists($_destDir) ) {
			//echo 'folder does not exist, make it<br>';
			if( mkdir($_destDir,0777) ) {
				chmod($_destDir,0705);
			}
		} //else {
		//	echo 'folder does exist, ignore<br>';
		//}
	}
	
	private function extractSubs()
	{
		$zipFile = 'dsn/docs/galleryv2.zip';
		//echo 'the zipFile: '.$zipFile.'<br>';
		$extractTo = $this->data['src'].'/galleryv2';
		//echo 'extractTo: '.$extractTo.'<br>';

		$zip = new ZipArchive; 
		if( $zip->open($zipFile) === TRUE) {
			//echo 'Opened the zip file.<br>';
			$zip->extractTo($extractTo);
			$zip->close();
		} //else {
		//	echo 'Failed to open the zip file.<br>';
		//}

		// copy agent*.zip to nfts\agentv1
		$zipFile = 'dsn/docs/agentv1_v1.2.zip';
		//echo 'the zipFile: '.$zipFile.'<br>';
		$extractTo = $this->data['nfts'].'/agentv1';
		//echo 'extractTo: '.$extractTo.'<br>';

		if( $zip->open($zipFile) === TRUE) {
			//echo 'Opened the zip file.<br>';
			$zip->extractTo($extractTo);
			$zip->close();
		} //else {
		//	echo 'Failed to open the zip file.<br>';
		//}
	}

	// Explain what needs to be done here.
	private function downloadDSNFile() 
	{
		$exRef = $this->data['siteURL'].'dsn/api/gallery/';
		$exLink='<a href="'.$exRef.'" target="_blank">'.$exRef.'</a>';

		$title = 'Customize your install with a Gallery.';
		$txt = array();

		$txt[0] = 'The dsnreadme.php file is fully documented and can be edited using a standard text editor like notepad. It is the configuration file for the Selene Network install.  Please read it and make the appropriate edits.';
		$txt[1] = 'You are responsible for editing and uploading your changes to your server. The file must be placed in the "src" folder.';

		$theStr='';
		$theStr.= '<center>';
		$theStr.= '<div style="width: 80%;text-align: left;margin-bottom: 15px">';
		$theStr.= '<h2>'.$title.'</h2>';
		$theStr.= '<center>';
		$theStr.= '<button class="button" onclick="saveDSNFile()"> Download dsnreadme.php File </button>';
		$theStr.= '</center>';
		$theStr.= '<p>'.$txt[0].'</p>';
		$theStr.= '<p>'.$txt[1].'</p>';
		$theStr.= '</div>';
		$theStr.= '<hr style="width:50%">';
		$theStr.= '</center>';
		return $theStr;
	}

	// Explain what needs to be done here.
	private function downloadGalleryFile() 
	{
		$exRef = $this->data['siteURL'].'dsn/tools/?file='.$this->data['siteURL'].'src/gallery.json';
		$exLink='<a href="'.$exRef.'" target="_blank">'.$exRef.'</a>';

		$title = 'Create a Gallery that can be used.';
		$txt = array();
		$txt[0] = 'The gallery.json file holds configuration settings that are specific to the gallery being displayed. Click to download the file for editing. Once completed, upload the file to '.$this->data['siteURL'].'src/gallery.json.';
		//$txt[1] = 'Use the Selene Network tools page to walk you through the process of deploying and configuring your own Gallery smart contract. Use the following link: '.$exLink.'.';

		$theStr='';
		$theStr.= '<center>';
		$theStr.= '<div style="width: 80%;text-align: left;margin-bottom: 15px">';
		$theStr.= '<h2>'.$title.'</h2>';
		$theStr.= '<center>';
		$theStr.= '<button class="button" onclick="saveGalleryFile()"> Download gallery.json File </button>';
		$theStr.= '</center>';
		$theStr.= '<p>'.$txt[0].'</p>';
		$theStr.= '</div>';
		$theStr.= '<hr style="width:50%">';
		$theStr.= '</center>';
		return $theStr;
	}
	private function deployingGallery() 
	{
		$exRef = $this->data['siteURL'].'dsn/tools/?file='.$this->data['siteURL'].'src/gallery.json';
		$exLink='<a href="'.$exRef.'" target="_blank">'.$exRef.'</a>';

		$title = 'Deploying or Interacting with a Gallery';
		$txt = array();
		$txt[0] = 'The Selene Network tools will help you launch a new gallery smart contract to the blockchain. See the "Deploy Gallery Smart Contract" section at this link: '.$exLink.' for details.';

		$theStr='';
		$theStr.= '<center>';
		$theStr.= '<div style="width: 80%;text-align: left;margin-bottom: 15px">';
		$theStr.= '<h2>'.$title.'</h2>';
		$theStr.= '<p>'.$txt[0].'</p>';
		$theStr.= '</div>';
		$theStr.= '<hr style="width:50%">';
		$theStr.= '</center>';
		return $theStr;
	}

	private function reinstallMsg() 
	{
		$exRef = $this->data['siteURL'].'dsn';

		$title = 'The Install has already been run.';
		$txt = array();
		$txt[0] = 'The installation process has already been run on this server. To perform a clean install, delete the files in the '.$exRef.' directory and extract the version of the Selene Network that you want to install.';

		$theStr='';
		$theStr.= '<center>';
		$theStr.= '<div style="width: 80%;text-align: left;margin-bottom: 15px">';
		$theStr.= '<h2>'.$title.'</h2>';
		$theStr.= '<p>'.$txt[0].'</p>';
		$theStr.= '</div>';
		$theStr.= '<hr style="width:50%">';
		$theStr.= '</center>';
		return $theStr;
	}
	// 
	public function thePage()
	{
		// This is where we expect the install to occur.
		$this->data['siteURL']=$GLOBALS['theRootURL'].'/';

		$theStr = '<html>';
		$theStr.= self::theHead();

		$theStr.= '<body >';
		$theStr.= self::theScript();
		$theStr.= '<center>';
		// logo      
		$theStr.= '<div style="width:500px;">';
		$theStr.= '<img class="logo" src="./images/selene.png">'; // style="width: 250px;margin-top: 60px;" 
		$theStr.= '<h1>Server Setup</h1>';

		// for testing
		$this->data['src']='src';
		$this->data['nfts']='nfts';

		// get into the correct directory, we're starting in 'dsn'
		chdir('..');
		//echo getcwd().'<br>';

		// build the layout off the root location
		self::buildFolder($this->data['src']);
		self::buildFolder($this->data['nfts']);

		chdir($this->data['src']);
		//echo 'Should be in src: '.getcwd().'<br>';
		self::buildFolder('galleryv2');
		chdir('..');
		chdir($this->data['nfts']);
		//echo 'Should be in nfts: '.getcwd().'<br>';
		self::buildFolder('agentv1');
		chdir('..');
		//echo 'Should be in root: '.getcwd().'<br><br>';

		echo '<div id="theRootDirId" hidden>'.$this->data['siteURL'].'</div>';
		//chdir('dsn');
		//echo 'Should be in dsn: '.getcwd().'<br>';
		//chdir('docs');
		//echo 'Should be in docs: '.getcwd().'<br>';

		$curDir = getcwd();
		// Now, if the dsnreadme.php file doesn't exist in the src location, move it there.
		if( isset($GLOBALS['isLocal']) && $GLOBALS['isLocal']) {
			// windows can find either way, unix needs /

			// First one is the lock file.
			$lockFile = $curDir.'\dsn\delete_to_unlock.txt';

			// second one is for dsnreadme.php file
			$srcdsnFile = $curDir.'\dsn\docs\dsnreadme.php';
			$dstdsnFile = $curDir.'\src\dsnreadme.php';

			// third one is gallery.json file
			$srcgalFile = $curDir.'\dsn\docs\gallery.json';
			$dstgalFile = $curDir.'\src\gallery.json';

		} else {
			// use unix paths
			//echo "unix use /<br>";
			$lockFile = $curDir.'/dsn/delete_to_unlock.txt';

			$srcdsnFile = $curDir.'/dsn/docs/dsnreadme.php';
			$dstdsnFile = $curDir.'/src/dsnreadme.php';

			$srcgalFile = $curDir.'/dsn/docs/gallery.json';
			$dstgalFile = $curDir.'/src/gallery.json';
		}

		if( file_exists($lockFile) ) {
			$theStr.= '</center>';
			// message to user to delete the delete_to_unlock.txt file in order to install a second time.
			$theStr.= self::reinstallMsg();

		} else {
			// perform the install.
			self::extractSubs();

			// first dsnreadme.php file.
			if( !file_exists($dstdsnFile) ) {
				copy($srcdsnFile,$dstdsnFile);
				$newdsnDstFile = $dstdsnFile.'__';
				copy($srcdsnFile,$newdsnDstFile);
			}
			// second gallery.json file.
			if( !file_exists($dstgalFile) ) {
				copy($srcgalFile,$dstgalFile);
				$newgalDstFile = $dstgalFile.'__';
				copy($srcgalFile,$newgalDstFile);
			}

			// now create a lock file.
			$content = 'The existence of this file prevents the setup script from running a second time.';
			file_put_contents($lockFile,$content);

			// pretending that the work is already done.
			$theStr.= '<h2>Next Steps</h2>';
			$theStr.= '</center>';
		}

		// manual steps
		$theStr.= self::downloadDSNFile();
		$theStr.= self::downloadGalleryFile();
		$theStr.=self::deployingGallery();

		$theStr.= '</div>';

		$theStr.= '</body>';
		$theStr.= '</html>';
		echo $theStr;
	}

}


if( !function_exists("run_the_code") ) {
function run_the_code() {

	//TODO: want a clean option for removing the files.
	//TODO: want a verbose for debug spew.

	$plugin = new Theta_setup();
	$plugin->thePage();
}
run_the_code();
}
