<?php

/*
This class is designed to display a linkBlock to a project that is part of
the Selene Network. The eight array variables in the contructor should be 
modified to point to the project that will be linked. 

This code will fetch the image from the location supplied and the links
built for the icons will point to the supplied project.

dsnURL - should point to the root location where the dsn is installed

root - server where the project is located
path - path on server
name - project name. The file at root.path.name.'.json' should exist.

agentId - id of the refering agent in the network.
contractAddr - project smart contract address

theTotalWidth - desired width of linkBlock. min 260.
theFloat - either left, default or right.

Example URL:
http://localhost/amorstyle/dsn/dsnlink.php?display=mobile&float=right&width=380
*/
class CSeleneNetworkLinkBlock
{
	private $data = array();

	private $bMobile;

	function __construct($_width,$_float) 
	{
		// NOTE: always place slash on end of paths
		// dsn root Location
		$this->data['dsnURL'] = 'http://localhost/amorstyle/dsn/';
		// project root location
		$this->data['name'] ='drmnftv1';
		$this->data['path'] = 'nfts/drmnftv1/';
		$this->data['root'] = 'http://localhost/amorstyle/';

		$this->data['agentId'] = '1001';
		$this->data['contractAddr'] = '0xef414cd6ff65ee300236666e7beb86bc05e4e100';

		$this->data['theTotalWidth'] = $_width;
		$this->data['theFloat'] = $_float;

		self::defaults();
		$this->bMobile = false;
	}

	private function defaults()
	{
		$this->data['copyIcon'] = $this->data['dsnURL'].'images/copy_small.png';
		$this->data['copyIconCopied'] = $this->data['dsnURL'].'images/copy_small_copied.png';
		$this->data['homeIcon'] = $this->data['dsnURL'].'images/home_small.png';
		$this->data['infoIcon'] = $this->data['dsnURL'].'images/info_small.png';
		$this->data['networkInfo'] = 'https://amorstyle.com/2024/03/07/amorstyle-distributed-sales-network-nfts/';
	}

	private function theLocation()
	{
		return $this->data['root'].$this->data['path'].$this->data['name'].'.php';
	}

	private function fetchProject()
	{
		$theFile = $this->data['root'].$this->data['path'].$this->data['name'].'.json';
		$content = file_get_contents($theFile);
		$this->data['metadata'] = json_decode($content,true);
		//var_dump( $this->data['metadata']);
		//echo $this->data['metadata']['name']."<br>";
	}

	private function css()
	{
$theStr = '<style>
div.total {
	background-color: #f2d9d9;
    text-align: center;
    float: default;
    padding: 0px 2px 0px 2px;
    margin: 0px 10px 0px 10px;
    border-radius: 3px;
}
div.title {
    text-align: center;
    font-size: 1.25em;
    padding: 2px 2px 2px 2px;
    margin: 2px 0px 7px 0px;
	background-color: #e6e6e6;
}
div.titlem {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 2px 2px 2px;
    margin: 2px 0px 7px 0px;
	background-color: #e6e6e6;
}
div.footer {
    text-align: center;
    font-size: 0.65em;
    padding: 0px 0px 2px 0px;
    margin: 0px 0px 2px 0px;
	/*background-color: #e6e6e6;*/
}

div.lcolumn {
    /*text-align: center;*/
    /*float: left;*/
	background-color: #e6e6e6;
    margin: 5px 0px 5px 0px;
    border-radius: 3px;
}
div.rcolumn {
    /*text-align: center;*/
    /*float: right;*/
	/*background-color: #99ff99;*/
    margin: 5px 0px 5px 0px;
}

div.relative {
  position: relative;
  /*border: 3px solid #aaAD21;*/
} 

div.absolute {
  position: absolute;
  top: 0px;
  left: 0px;
  width: 200px;
  height: 100px;
  /*border: 3px solid #73ff21;*/
}
div.absolutetools {
  position: absolute;
  top: 0px;
  left: 200px;
  width: 100px;
  height: 200px;
  /*border: 3px solid #73AD21;*/
}

img {
	position: fixed;
	top: 25px;
	left: 25px;
}
img.absolute {
  position: absolute;
  top: 0px;
  left: 0px;
  /*width: 200px;*/
  /*height: 42px;*/
}
img.active {
	cursor: pointer;
}
img.main {
    border-radius: 10px;
}
.imgA1 {
	z-index: 1;
}
.imgB1 {
	z-index: 3;
}
</style>';	
		return $theStr;
	}


	// The script touches a few different variables on the page.
	private function script()
	{
		$theLocation = self::theLocation();

		$theStr = '<div id="scriptVars">';
		$theStr.= "<div id='theShareURLId' hidden>".$theLocation."</div>";
		$theStr.= "<div id='theShareAgentId' hidden>".$this->data['agentId']."</div>";
		$theStr.= "<div id='theShareContractId' hidden>".$this->data['contractAddr']."</div>";
		$theStr.= "<div id='theShareCopiedId' hidden>".$this->data['copyIconCopied']."</div>";
		$theStr.= '</div>';

		$theStr.= "<script>
const delay = ms => new Promise(res => setTimeout(res, ms));

async function displayCopy(_newImage) {
    let obj = document.getElementById('shareImageId');
	let oldImage = obj.src;
	obj.src = _newImage;
    await delay(1000);
	obj.src = oldImage;
}

async function copyURI() {
    let theURL = document.getElementById('theShareURLId').innerHTML;
    let theAgent = document.getElementById('theShareAgentId').innerHTML;
    let theContract = document.getElementById('theShareContractId').innerHTML;
	let newImage = document.getElementById('theShareCopiedId').innerHTML;
	let copyTxt = theURL + '?agent=' + theAgent + '&contract='+ theContract;
	//console.log(copyTxt);
    navigator.clipboard.writeText(copyTxt).then(() => {
        //console.log('clipboard successfully set');
        displayCopy(newImage);

    }, () => {
        //console.log('clipboard write failed');
    });
}
</script>";
		return $theStr;
	}

	private function html()
	{
		$margSize=10;
		$margTB=5;

		// calculate sizes
		$theTotalWidth = max($this->data['theTotalWidth'],160); // 260
		$imageWidthSize = ($theTotalWidth * 0.80)-($margSize*2);
		$lColumnHeight = $imageWidthSize+($margTB*2);
		$sideBarWideSize = ($theTotalWidth * 0.20);
		$iconWidth = min((int)($theTotalWidth*0.14),42);

		$mainDivWidth = $imageWidthSize;
		$mainDivHeight = $lColumnHeight-($margTB*2);

		$toolsDivWidth = $sideBarWideSize-($margSize*2);
		$toolsDivHeight = $mainDivHeight;
		$toolsDivLeft = $mainDivWidth+($margSize*3);

		// There will be four slots for icons
		$iconHeight = ($iconWidth+2);
		$theFloat = $this->data['theFloat'];

		$theTitle = $this->data['metadata']['name'];
		$theLocation = self::theLocation();
		$theHomeIcon = $this->data['homeIcon'];
		$theImage = $this->data['metadata']['image'];
		$theCopyIcon = $this->data['copyIcon'];
		$theNetworkInfo = $this->data['networkInfo'];
		$theInfoIcon = $this->data['infoIcon'];

		$cssTitle = 'title';
		if( $this->bMobile )
		{
			$cssTitle = 'titlem';
		}
		$cssFooter = 'footer';
		$theStr = '';
/*
		// layout old
		$theStr = "<div class='total' style='width:".$theTotalWidth."px;float:".$theFloat."'>";
		$theStr .= "<div class='".$cssTitle."' id='titleId' >".$theTitle."</div>";

		$theStr .= "<div class='lcolumn'  >";

		$theStr .= "<div class='relative' style='width:".$theTotalWidth."px;height:".$lColumnHeight."px'>";

		$theStr .= "<div class='absolute' style='top:5px;left:5px;width:".$mainDivWidth."px;height:".$mainDivHeight."px'>";
		$theStr .= "<a href='".$theLocation."' target=_self>";
		$theStr .= "<img class='absolute imgB1 active' width='".$iconWidth."' src='".$theHomeIcon."' >";
		$theStr .= "</a>";
		$theStr .= "<img class='absolute imgA1 main' src='".$theImage."' style='width:".$imageWidthSize."px'>";
		$theStr .= "</div>"; // absolute

		$theStr .= "<div class='absolutetools' style='top:5px;left:".$toolsDivLeft."px;width:".$toolsDivWidth."px;height:".$toolsDivHeight."px'>";
		$theStr .= "<img id='shareImageId' class='absolute active' width='".$iconWidth."' style='left:0px;' src='".$theCopyIcon."' onclick='copyURI()'>";
		$theStr .= "<a href='".$theNetworkInfo."' target=_self>";
		$theStr .= "<img class='absolute active' width='".$iconWidth."' style='left:0px;top:".($iconHeight*4)."px' src='".$theInfoIcon."' >";
		$theStr .= "</a>";
		$theStr .= "</div>"; // absolutetools

		$theStr .= "</div>"; // relative

		$theStr .= "</div>"; // lcolumn

		//$theStr .= "<a href='".$theNetworkInfo."' target=_self>";
		//$theStr .= "<div class='".$cssFooter."' id='titleId' >Selene Network</div>";
		//$theStr .= "</a>";
		$theStr .= "</div>"; // total
*/
		// new layout
		$theStr .= "<div class='total' style='width:".$theTotalWidth."px;float:".$theFloat."'>";
		$theStr .= "<div class='".$cssTitle."' id='titleId' >".$theTitle."</div>";

		$theStr .= "<div class='lcolumn'  >";

		$theStr .= "<div class='relative' style='width:".$theTotalWidth."px;height:".$lColumnHeight."px'>";

		$theStr .= "<div class='absolute' style='top:5px;left:5px;width:".$mainDivWidth."px;height:".$mainDivHeight."px'>";
		//$theStr .= "<a href='".$theLocation."' target=_self>";
		//$theStr .= "<img class='absolute imgB1 active' width='".$iconWidth."' src='".$theHomeIcon."' >";
		//$theStr .= "</a>";
		$theStr .= "<img class='absolute imgA1 main' src='".$theImage."' style='width:".$imageWidthSize."px'>";
		$theStr .= "</div>"; // absolute

		$theStr .= "<div class='absolutetools' style='top:5px;left:".$toolsDivLeft."px;width:".$toolsDivWidth."px;height:".$toolsDivHeight."px'>";
		// home
		$theStr .= "<a href='".$theLocation."' target=_self>";
		$theStr .= "<img class='absolute active' width='".$iconWidth."' style='left:0px;' src='".$theHomeIcon."' >";
		$theStr .= "</a>";
		// copy
		$theStr .= "<img id='shareImageId' class='absolute active' width='".$iconWidth."' style='left:0px;top:".($iconHeight)."px' src='".$theCopyIcon."' onclick='copyURI()'>";
		//$theStr .= "<a href='".$theNetworkInfo."' target=_self>";
		//$theStr .= "<img class='absolute active' width='".$iconWidth."' style='left:0px;top:".($iconHeight*4)."px' src='".$theInfoIcon."' >";
		//$theStr .= "</a>";
		$theStr .= "</div>"; // absolutetools

		$theStr .= "</div>"; // relative

		$theStr .= "</div>"; // lcolumn

		$theStr .= "<a href='".$theNetworkInfo."' target=_self>";
		$theStr .= "<div class='".$cssFooter."' id='titleId' >Selene Network</div>";
		$theStr .= "</a>";
		$theStr .= "</div>"; // total

		return $theStr;
	}

	// main function
	public function main()
	{
		$theStr = '';
		self::fetchProject();
		//var_dump($_SERVER);

		$this->bMobile = false;
		if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
			$this->bMobile = true;
		} 
		if( isset($_GET['display']) && $_GET['display'] == 'mobile') 
		{
			$this->bMobile = true;
		}

		$theStr.= self::css();
		$theStr.= self::script();
		$theStr.= self::html();
		return $theStr;
	}
}

if( !function_exists("selNetLinkBlock") ) 
{
function selNetLinkBlock() {

	$width = 260;
	$float = 'default';

	if( isset($_GET['width']) && '' != $_GET['width']) {
		//echo "width: ".$_GET['width']."<br>";
		$width = $_GET['width'];
	}
	if( isset($_GET['float']) && '' != $_GET['float']) {
		//echo "float: ".$_GET['float']."<br>";
		$float = $_GET['float'];
	}

	$work = new CSeleneNetworkLinkBlock($width,$float);
	echo $work->main();
}

selNetLinkBlock();
// bring in the following for testing.

echo "<h1>Creative Writing</h1>";
echo "<p>Generating random paragraphs can be an excellent way for writers to get their creative flow going at the beginning of the day. The writer has no idea what topic the random paragraph will be about when it appears. This forces the writer to use creativity to complete one of three common writing challenges. The writer can use the paragraph as the first one of a short story and build upon it. A second option is to use the random paragraph somewhere in a short story they create. The third option is to have the random paragraph be the ending paragraph in a short story. No matter which of these challenges is undertaken, the writer is forced to use creativity to incorporate the paragraph into their writing.</p>";

echo "<h1>Tackle Writers' Block</h1>";
echo "<p>A random paragraph can also be an excellent way for a writer to tackle writers' block. Writing block can often happen due to being stuck with a current project that the writer is trying to complete. By inserting a completely random paragraph from which to begin, it can take down some of the issues that may have been causing the writers' block in the first place.</p>";

echo "<h1>Beginning Writing Routine</h1>";
echo "<p>Another productive way to use this tool to begin a daily writing routine. One way is to generate a random paragraph with the intention to try to rewrite it while still keeping the original meaning. The purpose here is to just get the writing started so that when the writer goes onto their day's writing projects, words are already flowing from their fingers.</p>";


}
?>


