<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}


/*
The information that is common across multiple pages is in this class
*/
class DSNCommon {

	private $globalData = array();

	function __construct() {
	}

	// This routine should provide the bulk of the server local server information
	// so the links can be built correctly. The information is provided in a 
	// keyed array.
	//
	// 
	public function globalVars($_arrParams) {

		// Get the site wide defaults
		$site = new CDSNReadme();
		$siteData = $site->data();

		// the global version of the code is tracked here
		$this->globalData['SelNetVersion'] = "v1.28";

		// Move each one into the global data array.
		foreach($siteData as $key => $item) {
			//echo $key.": ".$item."<br>";

			// now override
			if( $key == 'agent') {
				if(isset($_arrParams['agent']) && ( null != $_arrParams['agent'] ) )
				{
					// user provided agent id. use it.
					//echo "URL override for agent<br>";
					$this->globalData[$key] = (int)$_arrParams['agent'];
				} else {
					//echo "Default value for ".$key."<br>";
					$this->globalData[$key] = $item;
				}
			}
			else {
				//echo "Default value for ".$key."<br>";
				$this->globalData[$key]=$item;
			}
		}

		// The mobile display option is supported across all pages.
		if(isset($_arrParams['mobile']) )
		{
			$this->globalData['mobile'] = 1;
		} else {
			$this->globalData['mobile'] = 0;
		}

		// Other data we want to show up in the globals but is set in the 
		// different index files.

		// If the page provides contact, we'll set that here.
		if(isset($_arrParams['contract']) )
		{
			$this->globalData['contract'] = $_arrParams['contract'];
		} 
		// else, it's undefined.

		// If the page provides a gallery address, we'll set that here.
		if(isset($_arrParams['gallery']) )
		{
			$this->globalData['GalleryAddr'] = $_arrParams['gallery'];
		} 
		$this->globalData['bGalleryIndex'] = false;
		if( isset($_arrParams['GalleryIndex']) ) {
			$this->globalData['GalleryIndex'] = $_arrParams['GalleryIndex'];
			$this->globalData['bGalleryIndex'] = true;
		}
		// else, it's undefined.

		// If the page provides account, we'll set that here.
		if(isset($_arrParams['account']) )
		{
			$this->globalData['account'] = $_arrParams['account'];
		} 
		// else, it's undefined.

		// If the page provides limit, we'll set that here.
		if(isset($_arrParams['limit']) )
		{
			$this->globalData['limit'] = $_arrParams['limit'];
		} 
		// else, it's undefined.

		// If the install didn't set these, get them here.
		if( !isset($this->globalData['galleryLimit']) ) {
			$this->globalData['galleryLimit'] = 12;
		}
		if( !isset($this->globalData['showHolderSection']) ) {
			$this->globalData['showHolderSection'] = 1;
		}

		// Add localHome image and link
		$this->globalData['localLogo']=$this->globalData['root'].'images/local_small.png';
		$this->globalData['localHome']=$this->globalData['root'];

		// For debugging
		if( $this->globalData['debug'] == 1 ) {
			foreach($this->globalData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		return $this->globalData;
	}

	// This returns HTML for writing the globals into the page for the JavaScript
	public function globalHTML() {

		$theStr = '';
		foreach($this->globalData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}
		return $theStr;
	}


	// returns the header
	public function headerInfo($pageTitle, $pageDescription, $_meta='') {
		$theStr = "<head>";
		$theStr.="<!--The MIT License - Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so.";
		$theStr.="THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. -->";

		$theStr.="<meta charset='utf-8'>";
		$theStr.="<meta http-equiv='X-UA-Compatible' content='IE=edge'>";
		$theStr.="<title>".$pageTitle."</title>";
		$theStr.="<meta name='description' content='".$pageDescription."'>";
		$theStr.="<meta name='viewport' content='width=device-width, initial-scale=1'>";
		$theStr.="<link rel='stylesheet' href=''>";
		$theStr.=$_meta;
		//$theStr.="<script src='https://cdn.jsdelivr.net/npm/web3@1.10.2/dist/web3.min.js'></script>";
		//$theStr.="<script src='https://cdn.jsdelivr.net/npm/web3@4.13.0/dist/web3.min.js'></script>"; // Invalid value given "Eip1559NotSupportedError". Error: Network doesn't support eip-1559.
		$theStr.="<script src='https://cdn.jsdelivr.net/npm/web3@1.10.4/dist/web3.min.js'></script>";
		$theStr.="</head>";

		return $theStr;
	}

	// The CSS needs to be written to the page after the header
	public function theCSS() {
	
		$theStr = "
<style>
  div.wallet {
    border: 2px solid #404040;
    border-radius: 10px;
    padding: 2px 15px 2px 15px;
    margin: 5px;
    float: right;
    text-align: center;
    width: 150px;
    height: 40px;
  }
  div.walletm {
    border: 2px solid #404040;
    border-radius: 10px;
    /*padding: 2px 15px 2px 15px;*/
    /*margin: 5px;*/
    text-align: center;
    /*width: 150px;*/
    height: 40px;

    width: 150px;
	margin: auto;
    padding: 10px;
  }
  div.slogan {
    float: left;
    font-size: 1.5em;
    padding: 2px 15px 2px 15px;
    margin: 15px;
  }
  div.sloganm {
    font-size: 1.25em;
    padding: 2px 15px 2px 15px;
    margin: 15px;
  }
  div.msg {
    font-size: 1.25em;
    padding: 2px 15px 2px 15px;
    margin: 15px;
	/*background-color:#cbf1f7;*/
  }
  div.agent {
	background-color:#f0f0f0;  
  }
  div.admin {
	background-color:#dce6f5;  
  }
  div.title {
    text-align: left;
    font-size: 1.5em;
    padding: 2px 15px 2px 15px;
    margin: 15px;
  }
  div.token {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 0px 2px 0px;
    margin: 15px;
  }
  div.bar {
    width: 95%;
	text-align:center;  
  }
  div.movetop {
    text-align: right;
  }
  div.nft {
    margin: 2px 2px 2px 2px;
    padding: 2px 2px 2px 2px;
	background-color: #ede1d5;
  }
  div.link {
    text-align: left;
    font-size: 1.0em;
    padding: 2px 15px 2px 15px;
    margin: 5px;
  }
  div.standard {
    text-align: left;
    font-size: 1.0em;
    padding: 2px 2px 5px 2px;
  }
  div.standardc {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 2px 5px 2px;
  }
  div.fdback {
	background-color:#cbf1f7;
    padding: 10px 20px 15px 2px;
    /*margin: 10px 2px 15px 2px;*/
  }
  .vcontainer {
	  margin: auto;
	  margin-bottom: 15px;
	  /*width: 964px;*/
	  /*height: 544px;*/
  	  /*width: 100%;*/
	  /*height: 100%;*/
	  background-color: #6cf091;
	  text-align: center;
  }
  .vcontainer img {
  	  width: 100%;
	  height: 100%;
	  /*margin: auto;*/
	  /*display: block;*/
  }
  img {
    max-height: 250px;
    max-width: 250px;
  }
  img.ban {
    max-height: 100%;
    max-width: 100%;
  }
  img.token {
    max-height: 125px;
    max-width: 110px;
  }
  img:hover {
  	  cursor: pointer;
  }
  img.full {
  	  max-height: 100%;
	  max-width: 100%;
  }
  div.footer {
    text-align: center;
    font-size: 0.75em;
  }

  span.footer {
    font-size: 0.75em;
  }
  span {
    font-size: 1.5em;
  }
  span.natural {
    font-size: 1.0em;
  }
  span.link {
    font-size: 0.75em;
    margin: 0px 0px 0px 10px;
	/*background-color:#cbf1f7;*/
  }

  input {
    font-size: 1.0em;
    padding: 10px;
    border-radius: 10px;
  }

  button {
    font-size: 1.5em;
    padding: 10px;
    border-radius: 10px;
    cursor: pointer;
	margin-top: 3px;
  }
  button.natural {
    font-size: 1.0em;
    padding: 5px;
    border-radius: 10px;
	border: 2px solid black;
    cursor: pointer;
  }
  button.core {
    font-size: 1.0em;
    padding: 5px;
    border-radius: 10px;
	border: none;
    cursor: pointer;
  }
  button.land {
    font-size: 1.2em;
    /*padding: 5px;*/
    border-radius: 5px;
	border: none;
    cursor: pointer;
  }
  .column {
    float: left;
  }
  .left {
    width: 33%;
	text-align:center;
  }
  .leftEighty {
    width: 80%;
	text-align:center;
  }
  .c {
	text-align:center;
  }
  .right {
    width: 64%;
  }
  .rightTwenty {
    width: 20%;
  }
  .row:after {
    clear: both;
  }
  div.blackout {
  	  opacity: 1.0;
  }
  hr.bar {
	color:black;
	width:95%;
	height:2px;
	background-color:black;
  }
  button.centerIt {
  	display: block;
	margin-left: auto;
	margin-right: auto;
  }
  button.inlineIt {
	margin-left: auto;
	margin-right: 7px;
  }
  input.centerIt {
  	display: block;
	margin-left: auto;
	margin-right: auto;
  }
  input.inlineIt {
	margin-left: auto;
	margin-right: 7px;
  }
  /* used for wallet nft display*/
  div.tokenrel {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
	position: relative;
    float: left;
  }
  img.tokenrel {
	position: absolute;
  }
  div.nfttitle {
    text-align: center;
    font-size: 0.9em;
    margin: 0px 0px 0px 0px;  /*top right bottom left*/
	position: absolute;
  }
  /* for reel functionality */
  div.sectitle {
    text-align: center;
    font-size: 1.25em;
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
  }
  div.secdesc {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
  }
  div.agent {
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
	background-color: #f0f0f0; // light grey
  }
  div.owner {
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
	background-color: #ddeaf0; // light blue
  }
  /* Main video container */
  div.reel {
    /*margin: auto;*/
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
	background-color: #ddeaf0;
    /*max-width: 260px;*/
	float: left;
  }
  div.reelm {
    /*margin: auto;*/
    padding: 2px 0px 2px 0px;
    margin: 7px 2px 2px 2px;  /*top right bottom left*/
	background-color: #ddeaf0;
    /*max-width: 260px;*/
	/*float: left;*/
  }
  div.reeltitle {
    text-align: center;
    font-size: 1.25em;
  }
  div.reeldesc {
    text-align: center;
    font-size: 1.0em;
  }
  img.reelm {
    margin: 5px 5px 2px 5px;  /*top right bottom left*/
	max-width: 390px;
  }
  img.reel {
    margin: 5px 5px 2px 5px;  /*top right bottom left*/
	max-width: 260px;
  }


</style>";
		return $theStr;
	}

	private function titleRow() {

		$titleId = 'titleId';
		$theThetaImg = "<img height='20' src='https://www.thetascan.io/theta_small.jpg'>";
		$theHeaderTitle = "Selene Network Product"; // "The Gallery";

		//TODO: Gallery ribbon should get link to tools.
		$verifyId = "verifyId";
		$verifyLinkId = "verifyLinkId";
		$verifySize = 24;
		$verifyImg = "<img id='".$verifyId."' height='".$verifySize."' src='".$GLOBALS['theRootURL'] ."/dsn/images/unverified_small.png' >";
		// the link is set in javascript
		$verifyLink = '<a id="'.$verifyLinkId.'" href="" target="_self">'.$verifyImg.'</a>';

		$theStr = '<center><div style="max-width: 90%">';
		if( $this->globalData['mobile'] == 0) {
			$theStr .= '<div style="width: 100%;text-align: center;font-size: 1.25em;">';
		} else {
			$theStr .= '<div style="width: 100%;text-align: center">';
		}
		$theStr .= '<span id="thetaId" style="margin-right: 10px">'.$theThetaImg.'</span>';
		$theStr .= '<span id="galleryVerifyId" style="margin-right: 10px" hidden>'.$verifyLink.'</span>';
		$theStr .= '<span id="'.$titleId.'" style="padding:2px 2px 5px 12px">'.$theHeaderTitle.'</span>';

		$theStr .= "</div>";
		$theStr .= "</div></center>";

		return $theStr;
	}

	// $globalMobile
	// build the HTML for the connect row
	public function connectRow($_arrEnableCoins,$_bMainBtn=true) {
		$rowId = "connectRow";

		$iconHeight = 32;
		$theHomeId = 'homeId';
		$theHomeImg ='<img id="'.$theHomeId.'" height="'.$iconHeight.'" src="'.$this->globalData['siteLogo'].'">';
		$theHomeRef = '<a href="'.$this->globalData['homelink'].'" target=_self>'.$theHomeImg.'</a>';
		$theLocalImg ='<img height="'.$iconHeight.'" src="'.$this->globalData['localLogo'].'">';
		$theLocalRef = '<a href="'.$this->globalData['localHome'].'" target=_self>'.$theLocalImg.'</a>';

		$theParams='';
		if( $this->globalData['mobile'] ) 
		{
			$theParams.='?display=mobile';
		}

		// the tools image and action
		$theToolsImg = '<img height="'.$iconHeight.'" src="'.$this->globalData['root'].'images/tools_small.png">';
		$theToolshref = $this->globalData['root']."tools";
		$theToolsRef = '<a href="'.$theToolshref.'" target=_self>'.$theToolsImg.'</a>';

		$theReelRoot = $this->globalData['root']."reelimages";
		$theCapImg = '<img height="'.$iconHeight.'" src="'.$this->globalData['root'].'images/cap.png">';
		$thehref = $this->globalData['root']."reel/?reel=".$theReelRoot."/cap_reel.json";
		//echo $thehref."<br>";
		//href="'.$theReelRoot.'/?reel='.$theReelRoot.'/cap_reel.json"
		$theCapRef = '<a href="'.$thehref.'" target=_self>'.$theCapImg.'</a>';

		$theWalletImg = '<img height="'.$iconHeight.'" src="'.$this->globalData['root'].'images/wallet_small.png">';
		$theWalletRef = '<a href="'.$this->globalData['root']."wallet/".$theParams.'" target=_self>'.$theWalletImg.'</a>';

		$theSides = 10; // in pixels
		$strMargins = 'margin-right: '.$theSides.'px;margin-left: '.$theSides.'px'; 

		// HTML starts here.
		$theStr = '';

		$theStr .= "<div id=".$rowId.">";
		//
		// right left and center elements
		// -----
		$theStr .= '<div id="walletIconId" style="float: right;'.$strMargins.'">';
		$theStr .= $theWalletRef;
		$theStr .= '</div>';
		$theStr .= '<div id="capIconId" style="float: right;'.$strMargins.'">';
		$theStr .= $theCapRef;
		$theStr .= '</div>';
		// -----
		$theStr .= '<div style="float: left;'.$strMargins.'">';
		$theStr .= $theHomeRef;
		$theStr .= '</div>';
		$theStr .= '<div style="float: left;'.$strMargins.'">';
		$theStr .= $theLocalRef;
		$theStr .= '</div>';
		//
		// Main button center
		//
		if( $_bMainBtn ) {
			$theStr .= '<div id="mainButtonId">';
			$theStr .= "<div id='walletAddress' class='walletm' onClick='connect()' style='cursor:pointer' ></div>";
			$theStr .= '</div>';
		}
		//
		// Second row right for tools
		//
		$theStr .= '<div id="toolsIconId" style="float: right;'.$strMargins.'">';
		$theStr .= $theToolsRef;
		$theStr .= '</div>';

		$theStr .= "<div style='clear: both'></div>";

		$theStr .= self::titleRow();
		$theStr .= self::balancesRow($_arrEnableCoins);

		$theStr .= "<div style='clear: both'></div>";

		$theStr .= '</div>';
		echo $theStr;

//		self::balancesRow($_arrEnableCoins);

		// close both sections
		//$theStr = "<div><center><hr></center></div>";
		$theStr = "</div>";
		echo $theStr;
	}

	// the custom NFT tells us what they support.
	private function balancesRow($_arrEnableCoins)
	{
		$maticBalanaceId = 'maticbalanceId';
		$ethBalanaceId = 'ethbalanceId';
		$bnbBalanaceId = 'bnbbalanceId';
		$tfuelBalanaceId = 'tfuelbalanceId';
		$paypalBalanaceId = 'paypalbalanceId';

		$arrEnableCoins = array();
		if( isset($_arrEnableCoins) && null != $_arrEnableCoins) {
			$arrEnableCoins = $_arrEnableCoins;
		} else {
			// only support tfuel
			$arrEnableCoins = array('tfuel' => true);
		}

		echo "<style>
  div.network {
    padding: 2px 15px 2px 15px;
    margin: 5px;
    float: right;
    text-align: center;
    width: 100%;
  }</style>";

		$theStr = "<div class='network'>";
		//$theStr .= "<a href='https://www.crazy4cryptos.com/'>";
		$theStr .= "SimpleSwap: <a href='https://simpleswap.io/?ref=018bde30e21b'>";

		if( isset($arrEnableCoins['matic']) && $arrEnableCoins['matic'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/polygon_small.png'>";
			$theStr .= "<span class='column natural' id='".$maticBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['eth']) && $arrEnableCoins['eth'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/ethereum_small.png'>";
			$theStr .= "<span class='natural' id='".$maticBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['bnb']) && $arrEnableCoins['bnb'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/binance_small.png'>";
			$theStr .= "<span class='natural' id='".$maticBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['tfuel']) && $arrEnableCoins['tfuel'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/tfuel_small.png'>";
			$theStr .= "<span class='natural' id='".$tfuelBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['paypal']) && $arrEnableCoins['paypal'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/paypal_small.png'>";
			$theStr .= "<span class='natural' id='".$paypalBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['btc']) && $arrEnableCoins['btc'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/bitcoin_small.png'>";
			$theStr .= "<span class='natural' id='".$btcBalanaceId."'>";
			$theStr .= "</span>";
		}
		if( isset($arrEnableCoins['ltc']) && $arrEnableCoins['ltc'] == true) {
			$theStr .= "<img height='25' src='".$this->globalData['root']."images/litecoin_small.png'>";
			$theStr .= "<span class='natural' id='".$ltcBalanaceId."'>";
			$theStr .= "</span>";
		}
		$theStr .= "</a>";
		$theStr .= "</div>";
		return $theStr;
	}

	public function errorRow() {
		$errorRowId = "InfoRowId";
		$errorInfoId = "InfoRowErrorId";
		$errorSolutionId = "InfoRowSolutionId";
	
		$theStr = '';

		if( $this->globalData['mobile'] != 0)
		{
			$theStr .= "<div id='".$errorRowId."' hidden>";
			$theStr .= "<div class='fdback'  >";
			$theStr .= "<div id='".$errorInfoId."' class='standardc'>Statement</div>";
			$theStr .= "<div id='".$errorSolutionId."' class='standard'>Solution</div>";
			$theStr .= "<div style='clear:both'></div>";
			$theStr .= "</div>";
			//$theStr .= "<div><center><hr class='bar'></center></div>";
			$theStr .= "</div>";
		}
		else
		{
			$theStr .= "<div id='".$errorRowId."' hidden>";
			$theStr .= "<div class='fdback'  >";
			$theStr .= "<div class='row'>";
			$theStr .= "<div class='column left'>
						<div id='".$errorInfoId."' class='standardc'>Statement</div>
						</div>";
			$theStr .= "<div class='column right'>
						<div id='".$errorSolutionId."' class='standard'>Solution</div>
						</div>";
			$theStr .= "</div>";
			$theStr .= "<div style='clear:both'></div>";
			$theStr .= "</div>";
			//$theStr .= "<div><center><hr class='bar'></center></div>";
			$theStr .= "</div>";
		}

		// handle the landing situations

		// Always have a section about installing MetaMask.
		$theStr .= "<div id='noMetamaskId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>Metamask provides the communication functionality for interacting with blockchains. Without it installed, this code will be unable to fetch NFT information.</div>";
		$theStr .= "<div class='msg'>If you are visiting from within a PC based browser, please click the 'MetaMask' button above and install the appropriate browser extension.</div>";
		$theStr .= "<div class='msg'>If you are visiting from a mobile device, please install the MetaMask app and browse this website from within that app.</div>";
		$theStr .= "</div>";

		// If Metamask is instlled, but not connected to the website.
		$theStr .= "<div id='noConnectionId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>Metamask provides the communication functionality for interacting with blockchains.</div>";
		$theStr .= "<div class='msg'>It appears that Metamask is active in your browser, but this website has not been approved, by you, to interact with it. </div>";
		$theStr .= "<div class='msg'>Please press the 'connect' button above to launch Metamask and approve this website for seeing wallet addresses and account balances.</div>";
		$theStr .= "<div class='msg'>Also note that if you approve multiple accounts, this website wallet functionality will be able to see the NFTs in the active and inactive connected accounts.</div>";
		$theStr .= "</div>";

		$theStr .= "<div id='noParticipantId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>To use this software, the visiting account must hold a Selene Network Participant NFT.</div>";
		$theStr .= "<div class='msg'>If you already own a Participant NFT, please confirm that the account that holds the NFT is active in Metamask and the corresponding account is connected to the website. The visiting (connected) account is displayed above.</div>";
		$theStr .= "<div class='msg'>If you are having trouble finding your Participant NFT, the wallet browsing functionality, found in the upper right corner of this page, may be of service.</div>";
		$theStr .= "<div class='msg'>Please note that the Participant NFT is soulbound, thus if you want to use this particular account, please mint another Participant NFT.</div>";
		$theStr .= "</div>";

		$theStr .= "<div id='wrongNetworkId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>The NFTs that the Selene Network interfaces with is currently implemented on the Theta blockchain. Please select the Theta Mainnet in the Metamask wallet that is connected to this site.</div>";
		$theStr .= "</div>";

		$theStr .= "<div><center><hr class='bar'></center></div>";

		echo $theStr;
	}

	public function theFooter() {
		$visitingStatus = "visitingStatus";

		$footerMsg = "This project builds upon a permissionless, decentralized sales network protocol that is built on the <a href='https://www.thetatoken.org/' target=_self>Theta blockchain</a> where participation is encouraged and incentivized.";
		$credits = "Brought to you by <a href='https://AmorStyle.com' target=_blank >Amor</a>";
		$penny   = ", <a href='https://explorer.thetatoken.org/account/".$this->globalData['PennyOracleAddr']."' target=_self >Penny Oracle</a>";

		$mintingIds = "mintingIds"; // Ids that are used for minting.
		$minting = "<a href='https://AmorStyle.com/download' target='_self'>Distributed Sales Network ".$this->globalData['SelNetVersion']."</a> Minting Ids - <i>Agent Id: ".$this->globalData['agent'].", Website Id: ".$this->globalData['website']."</i>.";

		$parturl = $this->globalData['root'] . '?contract='.$this->globalData['participantAddr'];
		$partLink = '<a href="'.$parturl.'" target=_self>Participant NFT Project</a>';
		$agenturl = $this->globalData['siteURL'] . 'nfts/agentv1/';
		$agentLink = '<a href="'.$agenturl.'" target=_self>Agent NFT Project</a>';
		$websiteurl = $this->globalData['root'] . '?contract='.$this->globalData['websiteAddr'];
		$websiteLink = '<a href="'.$websiteurl.'" target=_self>Website NFT Project</a>';

		// Foot HTML
		$theStr = "<div class='footer'>";
		$theStr.= "<div>";
		$theStr.= "<div class='column left' id='oneLineParticipant'>".$partLink."</div>";   //<div id='participantAddr' hidden>".$PartData->contract()."</div>
		$theStr.= "<div class='column left' id='oneLineAgent'>".$agentLink."</div>";       //<div id='agentAddr' hidden>".$AgentData->contract()."</div>
		$theStr.= "<div class='column left' id='oneLineWebsite'>".$websiteLink."</div>"; //<div id='websiteAddr' hidden>".$WebsiteData->contract()."</div>
		$theStr.= "</div>";
		$theStr.= "<div style='clear: both'></div>";
		$theStr.= $footerMsg;
		$theStr.= "</div>";
		$theStr.= "<div class='footer'>";
		$theStr.= "<span class='footer' id='".$mintingIds."'>".$minting."</span>";
		$theStr.= "<div>";
		$theStr.= "<span class='footer' id='".$visitingStatus."'>Visitor: <i>Consider becoming an Agent for the network</i>.</span>";

		$theStr.= '<span class="footer" style="padding:2px 2px 5px 12px">Using gallery Index: ';
		$theStr.= '<span id="GalleryIndex2Id" class="natural"></span>';
		$theStr.= '.</span>';

		$theStr.= "</div>";
		$theStr.= "</div>";
		$theStr.= "<div class='footer'><span class='footer'>".$credits."</span><span class='footer'>".$penny."</span></div>";
		$theStr.= "<div class='footer'><span class='footer'>&copy; 2024-2025, AmorStyle</span></div>";
		$theStr.= "<div style='clear: both'></div>";
		return $theStr;
	}
}