<?php
/*
This file is used to define a few variables that are used for the entire project.
One of the key assumptions that this code makes is that there will be a directory
structure relative to the root that is the same on all systems. That structure mimics:

http(s)://xyz.server.ext/ - which is the siteURL.

Off of the site, we have some path to the root directory which we call path. 
In our case path='dsn/'.

Off the siteURL.path, the project is expecting:

siteURL.path - location where project is unzipped
siteURL.nfts/agentv1 - location for agent project
siteURL.src - location for gallery files.
siteURL.src/galleryv2 - for the gallery smart contract.

All other information is gathered from the NFTs themselves.

*/
class CDSNReadme {

	private $data = array();

	function __construct() {

		$this->data['REQUEST_SCHEME']=$_SERVER['REQUEST_SCHEME'];

		// Anyone that installs the Selene Network software and they own a Website NFT
		// (see footer of Selene Network install), they will qualify for the website 
		// commmissions as stated by individual products as stated through their smart
		// contract. 
		// This value should equate to a website NFT token id. (founder owns #1)
		$this->data['website']=(int)1;

		// The agent id is acquired by registering a theta wallet address through the 
		// agent NFT (see footer of Selene Network install). In order to get registered,
		// someone that owns an Agent NFT will need to register you. The reason for this 
		// is that the agents are sales agents and it's more effective to be on a team
		// than to act as an individual. 
		// Note that the id that is used when purchasing products will see it's wallet
		// credited with the agent cuts as stated by each individual product that sells.
		// It's also important to understand that other agents can use this install and
		// get credited for sales by placing their agent Id on the URL.
		//
		// The value presented here is that of the project founder. Please get your own
		// number and use it. 
		$this->data['agent']=(int)1001;

		// These next three variables define the main paths used throughout this project.
		// siteURL is the main location which gets a slash added to the end. The path is
		// the main dsn directory. root is a combination of the two. 
		//
		$this->data['siteURL']=$GLOBALS['theRootURL'].'/';
		$this->data['path']='dsn/';
		//echo "Install Location is root: ".$this->data['siteURL'].$this->data['path']."<br>";
		$this->data['root']=$this->data['siteURL'].$this->data['path'];

		// The image in the upper left hand corner of the page is the location that returns the 
		// visitor to the website or the root of the project. The default home icon leads the 
		// person back to the parent website. The globe leads them back to the default website's 
		// product gallery.
		// It is expected that the siteURL above is the default website location. If you have
		// a customized location that the visitor should be returned to, place it here.
		$this->data['homelink']=$this->data['siteURL'];
		//
		// This image that goes along with the homelink is provided below. It's a 49x48.png file
		// that is transparent. Even if you replace this, any gallery file can overwrite the
		// image. The idea is that when viewing galleries, the visitor may want to be directed 
		// to the creator's website by clicking this icon/image. 
		//
		$this->data['siteLogo']=$this->data['siteURL'].$this->data['path'].'images/home_small.png';

		//
		// When the visitor hovers over the tab in the explorer, they get this name.
		// The default is 'AmorStyle Selene Network'.
		//
		//$this->data['tabTitle'] = 'My Tab Info';

		//
		// Because RPC calls are time intensive, this variable instructs the install
		// to show no more than this number of projects when viewing galleries. The
		// galleries may specify more, but they will be limited to this here. The
		// default is 12 - if it's not set.
		//
		//$this->data['galleryLimit'] = 12;

		// The default is to show the NFT holder section for each visitor. This field
		// can be hidden using this variable.
		//$this->data['showHolderSection'] = 1;

		// Unless you're writing your own smart contracts the follow few items should
		// be left unaltered.
		$this->data['PennyOracleAddr']="0x945c5b985a0d4ba6c42a88c1330bded9cd442389";
		$this->data['participantAddr']="0xd1ccd1983e010aa4319631b8e2b2a25bd62d4bae";
		$this->data['agentAddr']="0xf2c3eae1e4c38d4308e238a36d6f104fbec4e42e";
		$this->data['websiteAddr']="0x743e3f6de0996637eb31b4202f5d9b6a607775d7";

		// This is the default gallery that will be used for this install. If the contract has
		// more than one file regsitered, the GalleryIndex is used to set which one is used
		// by default. Note that the URL supports both 'gallery' & 'index'. If the user
		// places '?index=5' on the URL, that number will override the GalleryIndex listed here.
		// Likewise, if the user provides '?gallery=0x123...xfz' that gallery will be used.
		$this->data['GalleryAddr']=""; // default Gallery
		//$this->data['GalleryIndex']=6; // Index in gallery contract to use for default

		// for footer reference.
		$this->data['networkInfo'] = 'https://amorstyle.com/selnet/';

		// This value is used to size the clickable NFT that is shown both
		// after minting and in the wallet. It should be a value between
		// 100 and 260. 128 is the default.
		$this->data['nftWidth']=128;
		$this->data['nftWidthMobile']=180;

		// For wallet functionality the default is to limit the number of NFTs
		// that the page fetches for each wallet to 20. This can be overwritten
		// by the visitor using the URL.
		$this->data['limit']=(int)20;

		// set the following value to 1 for lite level debug spew, default 0.
		// This will show you common globals that can be used for custom projects.
		$this->data['debug']=0;   // echos glboal variables on screen (ether: 0,1 or 2)
		$this->data['debugjs']=0; // console logs global variables (either 0 or 1)
	}
	public function data() {
		return $this->data;
	}
}