<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}

//include "theta.php";
require_once($theRootDir.'/dsn/theta.php');

header('Access-Control-Allow-Origin: *');
//header("Content-Type: application/json");

require_once($theRootDir.'/dsn/ecrecover_helper.php');
require_once($theRootDir.'/dsn/keccak.php');
use kornrunner\Keccak;

/*
This is the main class that handles parsing out the signature. Upon either success or
failure, the class returns a payload for the query.
*/
class AuthSignature_nft {

	private $cCustomNFTSign; // custom class for signature reward
	private $customData; // data array

	function __construct() {
	}

	public function Init($_cCustomNFTSign) {
		$this->cCustomNFTSign = $_cCustomNFTSign;
	}

	public function Main() {

		//echo "Perform Check Here!<br>";
		$bSuccess = true;

		// This file is servicing a GET command and it's expecting four parameters.
		// if any of the parameters are missing, the code will exit with an error.
		if( !isset($_GET['signature']) || 
			!isset($_GET['timestamp']) || 
			!isset($_GET['address']) || 
			!isset($_GET['drmcontract'])|| 
			!isset($_GET['rtype'])) {

			exit("Invalid URL Parameters.");
		}

		$signed = $_GET['signature'];
		$timestamp = $_GET['timestamp'];
		$address = $_GET['address'];
		$drmContract = $_GET['drmcontract'];
		$rtype = $_GET['rtype'];

		$theMsg = "timestamp:".$timestamp.",drmcontract:".$drmContract;

		$timeNow = time();

		// This is the main datastructure that we're returning to the caller
		$theResult = array('signature' => false,
						'drmcontract' => $drmContract,
						'wallet' => $address,
						'balance' => 0,
						'rtype' => $rtype);

		// Because the signing process is fairly quick, we're going to require that the 
		// signature and the decode happens within a ten minute window. 
		// -- 60 seconds times 10 minutes added to the timestamp for the check.
		if( $timeNow > ($timestamp + (60 * 10))) {
			// user waited to long to use this signature.
			$theResult['signatureTimeout'] = $timeNow;
			$bSuccess=false;
			echo 'timeout path';
		}

		if( $bSuccess ) {
			// We're going to double check the drm contract address that is passed In
			// against what the project says is the contract.
			if( method_exists($this->cCustomNFTSign,'data') ) {

				$srcData = $this->cCustomNFTSign->data();

				// now perform our check
				if( $srcData['DRMContract'] != $drmContract ) {
					// we're being asked for a different contract. This doesn't cut the mustard
					$theResult['mismatchcontract'] = $drmContract;
					$bSuccess=false;
					echo 'contract does not match';
				}
			}
		}

		if( $bSuccess ) {
			//echo 'On success path';

			$didItWork = personal_ecRecover($theMsg, $signed);
			if( $didItWork == strtolower($address)) {

				// Signature matches, now check for NFT ownership
				//echo 'here';
				$function = "balanceOf(address)";
				$nftNumber = callFunction($drmContract,$function,$address);
				if( $nftNumber > 0 ) {

					$theResult['signature'] = true;
					$theResult['balance'] = $nftNumber;

					return $theResult;
				}
			}
		}
		else 
		{
			echo "something doesn't add up";
		}
	}
}

?>