<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_project_api {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}

	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		if( isset($_arrParams['project'])) {
			$this->gData['project']=$_arrParams['project'];
		}

		$this->gData['common'] = new Theta_common_api();

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		return $this->gData;
	}

	private function getProject() {

		// TODO: Do we need to check to see if the contract supports the interface?

		$contract = $this->gData['project'];
		$functionABI = 'projectDataCurrent()';
		$params = null;

		$metadataStr = callFunction($contract,$functionABI,$params);
		if( null != $metadataStr ) {
			//echo $metadataStr.'<br>';

			$data = $this->gData['common']->decodeMetadataObj($metadataStr);

			// build the URL to the file.
			$theURL = $data['url'].$data['name'].'.json';
			//echo "fetch ".$theURL." and include it<br>";

			ob_start();
			$theData = file_get_contents($theURL);
			$content = ob_get_clean();
			if( false != $theData ) {

				if( $this->gData['common']->validateHash($theData,$data['hash']) ) {
					$data['validatedHash'] = true;

					$theDecode = json_decode($theData);
					$data['data'] = $theDecode;

				} else {
					$data['validatedHash'] = false;
				}

				$theDecode = json_decode($theData);
				$data['data'] = $theDecode;
			}
			return $data;
		}
	}

	public function theJSON($_arrParams) {
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		self::globalVars($dsncommon,$_arrParams);

		$theResult = array();

		if( isset($this->gData['project'])) {
			$data = self::getProject();

			echo json_encode($data,JSON_UNESCAPED_SLASHES);
		}
	}
}


