<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_gallery_api {

	private $gData; // data array of all global variables

	function __construct() {
		$this->gData = array();
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}

	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		$this->gData['common'] = new Theta_common_api();

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		return $this->gData;
	}

	private function getGalleryList($_gallery) {
		$results = array();

		//$contract = $this->gData['GalleryAddr'];
		$contract = $_gallery;
		$functionABI = 'projectIndex()';
		$params = null;

		$outputStr = callFunction($contract,$functionABI,$params);
		$iLastIndex = parseAsNumber($outputStr);
		$this->gData['iLastIndex']=$iLastIndex;
		//echo 'iLastIndex: '.$iLastIndex.'<br>';

		if( $iLastIndex >= 0 ) {
		
			$functionABI = 'projectData(uint256)';
			
			$iPlacement = 0;
			// loop over the items capturing each one
			for($i=$iLastIndex;$i>=0;$i--) {
				
				$params = strval($i);
				$outputStr = callFunction($contract,$functionABI,$params);
				$data = $this->gData['common']->decodeMetadataObj($outputStr);
				$data['galleryIndex'] = intval($i);
				//echo 'galleryIndex: '.$data['galleryIndex'].'<br>';

				// Before we add it to the output, we validate that it's not already
				// there. Walk the existing data looking for an identical name
				$bFound = false;
				for($k=0;$k<sizeof($results);$k++) {
					if( $results[$k]['name'] == $data['name'] ) {
						$bFound = true;
						break;
					}
				}
				if( !$bFound ) {
					// build the URL to the file.
					$theURL = $data['url'].$data['name'].'.json';
					//echo "fetch ".$theURL." and include it<br>";

					ob_start();
					$theData = file_get_contents($theURL);
					$content = ob_get_clean();
					if( false != $theData ) {
						if( $this->gData['common']->validateHash($theData,$data['hash']) ) {
							$data['validatedHash'] = true;

							$theDecode = json_decode($theData);
							$data['data'] = $theDecode;

						} else {
							$data['validatedHash'] = false;
						}

						$theDecode = json_decode($theData);
						$data['data'] = $theDecode;

						$results[$iPlacement++] = $data;
					}
				}
			}
		}
		//$results['lastIndex'] = $iLastIndex;
		return $results;
	}

	public function theJSON($_arrParams) {
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		$theResult = array();

		$theResult['contract']='';
		$theResult['lastIndex']=null;
		$theResult['success']=true;
		$theResult['galleries']=array();

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		// let the URL override the local
		if( isset($this->gData['gallery'])) {
			$theResult['contract'] = $this->gData['gallery'];
			$theResult['galleries'] = self::getGalleryList($this->gData['gallery']);
			$theResult['lastIndex'] = $this->gData['iLastIndex'];
			//echo 'parsing gallery: '.$theResult['contract'].'<br>';
		} else if( isset($this->gData['GalleryAddr']) && $this->gData['GalleryAddr'] != null) {
			$theResult['contract'] = $this->gData['GalleryAddr'];
			$theResult['galleries'] = self::getGalleryList($this->gData['GalleryAddr']);
			$theResult['lastIndex'] = $this->gData['iLastIndex'];
			//echo 'parsing default gallery: '.$theResult['contract'].'<br>';
		} else {
			$theResult['success']=false;
			$theResult['msg']='No contract address specified.';
		}

		echo json_encode($theResult,JSON_UNESCAPED_SLASHES);
	}
}


