<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
} 

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}

require_once($theRootDir.'/dsn/theta.php');



/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://AmorStyle
 * @since      1.0.0
 *
 * @package    selnet
 * @subpackage selnet/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    selnet
 * @subpackage selnet/public
 * @author     AmorStyle <AmorStyleYoga@Hotmail.com>
 */
class selnet_shortcode 
{
	// Holds the shortcode options
	private $Localatts = array();

	// holds the last response from the server as a json data string
	private $response_json;
	// holds the last time the server was queried
	private $lasttime; 

	// holds the last response from the server as an array
	private $response_api = array();

	// boolean - ether true of false. false by default.
	private $debug_spew;

	// The URL for getting the price
	private $apiUrl = array();

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct(  )  // $plugin_name, $version
	{
		$this->debug_spew = false;
		$this->response_json = NULL;
		$this->lasttime = 0;

		// two locations provide the content that we want. we'll put both in an array
		// so if one goes down, we can get a response from the other.
		$this->apiUrl[1] = 'http://www.thetascan.io/api/price/';
		$this->apiUrl[2] = 'http://sg.thetascan.io/api/price/';
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in selnet_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The selnet_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/selnet-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in selnet_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The selnet_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/selnet-public.js', array( 'jquery' ), $this->version, false );

	}


	// This routine reads the shortcode and sets member variables 
	private function parse_options($atts)
	{
		$theStr = '';
		$defaultcore = 'https://amorstyle.com/dsn/';
		$Location = site_url();
		if( stristr($Location,"localhost") != false )
		{
			// localhost
			$defaultcore = 'http://localhost/amorstyle/dsn/';
		}

		// Setup the default here
		$this->Localatts = array(
			'index' => (int)0, // assume that only one shortcode on page
			'disable' => 0,   // not disabled by default
			'dsnurl' => $defaultcore,
			'addr' => '',
			'agentid' => '9999',
			'width' => (int)320,
			'float' => 'default',
			'widthmobile' => (int)380, // default center of screen
			'floatmobile' => 'default',
			'home' => '',  // default is no custom code
			'wp' => 'whitepaper'     // default is to not show the whitepaper link.
						);
		if( isset($atts['index'])) {
			$this->Localatts['index']=$atts['index'];
			$theStr .= 'index: '.$this->Localatts['index']."<br>";
		}
		if( isset($atts['disable'])) {
			$this->Localatts['disable']=$atts['disable'];
			$theStr .= 'disabled: '.$this->Localatts['disable']."<br>";
		}
		if( isset($atts['dsnurl'])) {
			$this->Localatts['dsnurl']=$atts['dsnurl'];
		}
		$theStr .= 'dsnurl: '.$this->Localatts['dsnurl']."<br>";
		if( isset($atts['addr'])) {
			$this->Localatts['addr']=$atts['addr'];
			$theStr .= 'addr: '.$this->Localatts['addr']."<br>";
		}
		if( isset($atts['agentid'])) {
			$this->Localatts['agentid']=$atts['agentid'];
			$theStr .= 'agentid: '.$this->Localatts['agentid']."<br>";
		}
		if( isset($atts['width'])) {
			$this->Localatts['width']=$atts['width'];
			$theStr .= 'width: '.$this->Localatts['width']."<br>";
		}
		if( isset($atts['float'])) {
			$this->Localatts['float']=$atts['float'];
			$theStr .= 'float: '.$this->Localatts['float']."<br>";
		}
		if( isset($atts['widthmobile'])) {
			$this->Localatts['widthmobile']=$atts['widthmobile'];
			$theStr .= 'widthmobile: '.$this->Localatts['widthmobile']."<br>";
		}
		if( isset($atts['floatmobile'])) {
			$this->Localatts['floatmobile']=$atts['floatmobile'];
			$theStr .= 'floatmobile: '.$this->Localatts['floatmobile']."<br>";
		}
		if( isset($atts['home'])) {
			$this->Localatts['home']=$atts['home'];
			$theStr .= 'home: '.$this->Localatts['home']."<br>";
		}
		if( isset($atts['wp'])) {
			$this->Localatts['wp']=$atts['wp'];
			$theStr .= 'wp: '.$this->Localatts['wp']."<br>";
		}
				
		return $theStr;
	}
	private function DEBUG()
	{
		// output what's true or set
		//echo "id: ".$this->Localatts['id']."<br/>";
	}

	public function main($atts)
	{
		// All information needs to be returned in a string.
		$output = ""; //"START SHORTCODE<br>";

		//$output .= self::parse_options($atts);
		self::parse_options($atts);
		//self::DEBUG();

		//var_dump($this->Localatts);
		$bMobile = false;
		if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
			$bMobile = true;
		} 
		// for testing.
		//$bMobile = true;

		$linkBlock = new CSeleneNetworkLinkBlock($this->Localatts,$bMobile);
		$output .= $linkBlock->main();

		return $output; //."<br>END SHORTCODE<br>";	}
	}
}

//
// Main shortcode entrypoint. 
//
function selnet_shortcode( $atts )
{
	// ob_start() and ob_get_clean() are used so echo can be used in development
	ob_start();
	$Shortcode=new selnet_shortcode();
	$Text=$Shortcode->main($atts);

	// Need to determine what platform we're on
	$Location = site_url();
	if( stristr($Location,"localhost") != false )
	{
		// Debug spew here..
		return ob_get_clean().$Text;
	}
	else
	{
		// No Debug Spew.
		ob_get_clean();
		return $Text;
	}
}


/*
This class is designed to display a linkBlock to a project that is part of
the Selene Network. 

[
selnet 
widthmobile=340 
floatmobile='default' 
width=280 
float='center' 
agentid='1002' 
addr="0x8c417957727696f439ef09f5b2f2f6b5f22c4efc" 
]

optional values:

disable=1
index=1
dsnurl="path to dsn root like https://myserver.io/dsn/"
home='no'
wp="link to whitepaper"


The variables in the contructor should be 
modified to point to the project that will be linked. 

This code will fetch the image from the location supplied and the links
built for the icons will point to the supplied project.

index - optional. If there are more than one selnet shortcode blocks on the
  page, each one will need a unique index number.

disabled - 1 if the shortcode links should be disabled. 

dsnurl - should point to the root location where the dsn is installed

agentid - id of the refering agent in the network.
contractAddr - project smart contract address

theTotalWidth - desired width of linkBlock. min 260.
theFloat - either left, center, default or right.

home - '' or 'no'. Overrides the home metadata value.

*/
class CSeleneNetworkLinkBlock
{
	private $data = array();
	private $bMobile;

	function __construct($_data,$_bMobile) 
	{
		$this->bMobile = $_bMobile;
		$this->data['index'] = $_data['index'];
		$this->data['disable'] = $_data['disable'];
		// NOTE: always place slash on end of paths
		// dsn root Location
		$this->data['dsnurl'] = $_data['dsnurl'];

		$this->data['agentid'] = $_data['agentid'];
		$this->data['contractAddr'] = $_data['addr'];

		$this->data['theTotalWidth'] = $_data['width'];
		$this->data['theFloat'] = $_data['float'];
		if( $this->bMobile )
		{
			$this->data['theTotalWidth'] = $_data['widthmobile'];
			$this->data['theFloat'] = $_data['floatmobile'];
		}
		$this->data['home'] = $_data['home'];
		if( $_data['wp'] == 'no') {
			$this->data['wp']='';
		} else {
			$this->data['wp'] = $_data['wp'];
		}

		self::defaults();
	}

	private function defaults()
	{
		$this->data['copyIcon'] = $this->data['dsnurl'].'images/copy_small.png';
		$this->data['copyIconCopied'] = $this->data['dsnurl'].'images/copy_small_copied.png';
		$this->data['homeIcon'] = $this->data['dsnurl'].'images/home_small.png';
		$this->data['infoIcon'] = $this->data['dsnurl'].'images/info_small.png';
		$this->data['wpIcon'] = $this->data['dsnurl'].'images/wp_small.png';
		$this->data['networkInfo'] = 'https://amorstyle.com/selnet/';
	}

	// This location is the place where the user can interact with the custom code - if
	// there is any. 
	private function theLocation($_justRoot)
	{
		$agent = "agent=".$this->data['agentid'];
		$contract = "contract=".$this->data['contractAddr'];

		$loc='';

		if( isset($this->data['metadata']['home']) ) 
		{
			// there is custom code
			if( 'index' == $this->data['metadata']['home'] ) {
				// the homepage is an index page.  ret: httpX://Server.ext/path/?agent=N
				if( $_justRoot ) {
					$loc = $this->data['project']['path'];				
				} else {
					$loc = $this->data['project']['path']."?".$agent;
				}
			} else {
				// the homepage is named, ret httpX://Server.ext/path/home.php?agent=N
				if( $_justRoot ) {
					$loc = $this->data['project']['path'].$this->data['metadata']['home'].'.php';
				} else {
					$loc = $this->data['project']['path'].$this->data['metadata']['home'].'.php'."?".$agent;
				}
			}		

		} else {

			// the homepage is named, ret httpX://Server.ext/dsn/
			if( $_justRoot ) {
				$loc = $this->data['dsnurl'];
			} else {
				$loc = $this->data['dsnurl']."?".$agent."&".$contract;
			}
		}

		return $loc;
	}
	private function theWPLocation()
	{
		$loc = '';
		if( isset($this->data['metadata']['whitepaper']) ) {
			$loc = $this->data['metadata']['whitepaper'];
		}
		return $loc;
	}

	private function bytesToStr($_theBytes,$_len) 
	{
		$arrBytes = str_split($_theBytes,2);
		$str = '';
		for($i=0;$i<$_len;$i++) {
			$str .= chr(hexdec($arrBytes[$i]));
		}
		return $str;
	}
	

	private function fetchProject()
	{
		//echo "contract: ".$this->data['contractAddr']."<br>";

		// read the metadata for this project
		$function = "projectDataCurrent()";
		$nftProject = callFunction($this->data['contractAddr'],$function,'');

		// There should be 3 return parameters. Each one will be at a specific
		// offset into the string.

		$lenny=64;


		// home
		// first parameter is a string found 3 deep.
		$remainingStr = substr($nftProject,2+($lenny*3));
		$len = hexdec(substr($remainingStr,0,64));
		$remainingStr = substr($remainingStr,64);
		$this->data['project']['path'] = self::bytesToStr($remainingStr,$len);
		//echo "PATH: ".$this->data['project']['path']."<br>";

		if( $len <= 32 ) {
			$adder = 1;
		} else if( $len <= (2*32) ) {
			$adder = 2;
		} else if( $len <= (3*32) ) {
			$adder = 3;
		} else if( $len <= (4*32) ) {
			$adder = 4;
		}

		// next length starts here.
		$remainingStr = substr($remainingStr,($adder * 64));
		$len = hexdec(substr($remainingStr,0,64));
		$remainingStr = substr($remainingStr,64);
		$this->data['project']['name'] = self::bytesToStr($remainingStr,$len);
		//echo "NAME: ".$this->data['project']['name']."<br>";

		if( $len <= 32 ) {
			$adder = 1;
		} else if( $len <= (2*32) ) {
			$adder = 2;
		} else if( $len <= (3*32) ) {
			$adder = 3;
		} else if( $len <= (4*32) ) {
			$adder = 4;
		}

		// next length starts here.
		$remainingStr = substr($remainingStr,($adder * 64));
		$len = hexdec(substr($remainingStr,0,64));
		$remainingStr = substr($remainingStr,64);
		$this->data['project']['hash'] = self::bytesToStr($remainingStr,$len);
		//echo "HASH: ".$this->data['project']['hash']."<br>";

		$theFile = $this->data['project']['path'].$this->data['project']['name'].'.json';
		//echo "FILE: ".$theFile."<br>";

		// Now fetch the JSON file for this project.
		$content = file_get_contents($theFile);
		$this->data['metadata'] = json_decode($content,true);
		//var_dump( $this->data['metadata']);
		//echo "<br>";

		//echo $this->data['metadata']['name']."<br>";
		//echo $this->data['metadata']['whitepaper']."<br>";
		//if( isset($this->data['metadata']['home'])) {
		//	echo $this->data['metadata']['home']."<br>";
		//}

		//echo "testing true: ".self::theLocation(true)."<br>";
		//echo "testing false: ".self::theLocation(false)."<br>";
		//echo "whitepaper loc: ".self::theWPLocation()."<br>";
		//echo "Done<br>";

	}

	private function css()
	{
$theStr = '<style>
div.total {
	background-color: #f2d9d9;
    text-align: center;
    float: default;
    padding: 5px 2px 0px 2px;
    margin: 0px 10px 2px 10px;
    /*border: 1px solid #00ff00;*/
}
div.title {
    text-align: center;
    font-size: 1.25em;
    padding: 2px 2px 2px 2px;
    margin: 2px 0px 7px 0px;
	background-color: #e6e6e6;
}
div.footer {
    text-align: center;
    font-size: 0.65em;
    padding: 0px 0px 2px 0px;
    margin: 0px 0px 2px 0px;
	/*background-color: #e6e6e6;*/
}
div.titlem {
    text-align: center;
    font-size: 1.0em;
    padding: 2px 2px 2px 2px;
    margin: 2px 0px 7px 0px;
	background-color: #e6e6e6;
}
div.lcolumn {
    /*text-align: center;*/
    /*float: left;*/
	background-color: #e6e6e6;
    margin: 5px 0px 5px 0px;
    border-radius: 3px;
}
div.rcolumn {
    /*text-align: center;*/
    /*float: right;*/
	/*background-color: #99ff99;*/
    margin: 5px 0px 5px 0px;
}

div.relative {
  position: relative;
  /*border: 3px solid #aaAD21;*/
} 

div.absolute {
  position: absolute;
  top: 0px;
  left: 0px;
  width: 200px;
  height: 100px;
  /*border: 3px solid #73ff21;*/
}
div.absolutetools {
  position: absolute;
  top: 0px;
  left: 200px;
  width: 100px;
  height: 200px;
  /*border: 3px solid #73AD21;*/
}

img.me {
	position: fixed;
	top: 25px;
	left: 25px;
}
img.absolute {
  position: absolute;
  top: 0px;
  left: 0px;
  /*width: 200px;*/
  /*height: 42px;*/
}
img.active {
	cursor: pointer;
}
img.inactive {
	opacity: 0.35;
}
img.main {
    border-radius: 10px;
}
.imgA1 {
	z-index: 1;
}
.imgB1 {
	z-index: 3;
}
</style>';	
		return $theStr;
	}


	// The script touches a few different variables on the page.
	private function script()
	{
		$theLocation = self::theLocation(true); // just root

		$theShareURLId = 'theShareURLId'.$this->data['index'];
		$theShareAgentId = 'theShareAgentId'.$this->data['index'];
		$theShareContractId = 'theShareContractId'.$this->data['index'];
		$theShareCopiedId = 'theShareCopiedId'.$this->data['index'];

		$theStr = '<div id="scriptVars">';
		$theStr.= "<div id='".$theShareURLId."' hidden>".$theLocation."</div>";
		$theStr.= "<div id='".$theShareAgentId."' hidden>".$this->data['agentid']."</div>";
		$theStr.= "<div id='".$theShareContractId."' hidden>".$this->data['contractAddr']."</div>";
		$theStr.= "<div id='".$theShareCopiedId."' hidden>".$this->data['copyIconCopied']."</div>";
		$theStr.= '</div>';

		return $theStr;
	}
	private function absoluteimagehtml()
	{
		$theStr = '';

		$layout = $this->data['layout'];

		$theImage = $this->data['metadata']['image'];

		$theStr .= "<div class='absolute' style='top:5px;left:5px;width:".$layout['mainDivWidth']."px;height:".$layout['mainDivHeight']."px'>";
		$theStr .= "<img class='me absolute imgA1 main' src='".$theImage."' style='width:".$layout['imageWidthSize']."px'>";
		$theStr .= "</div>"; // absolute

		return $theStr;
	}

	private function absolutetoolshtml()
	{
		$theStr = '';

		$layout = $this->data['layout'];

		$theLocation = self::theLocation(false); // include agent and contract
		$theWPLocation = self::theWPLocation();
		$theHomeIcon = $this->data['homeIcon'];
		$theCopyIcon = $this->data['copyIcon'];
		$theWPIcon = $this->data['wpIcon'];
		$theCopyImageId = 'copyImageId'.$this->data['index'];

		$bEnabled = true;
		if( $this->data['disable'] != 0 ) {
			$bEnabled = false;
		}

		$theStr .= "<div class='absolutetools' style='top:5px;left:".$layout['toolsDivLeft']."px;width:".$layout['toolsDivWidth']."px;height:".$layout['toolsDivHeight']."px'>";

		// home
		if( $bEnabled ) {
			$theStr .= "<a href='".$theLocation."' target=_self>";
			$theStr .= "<img class='me absolute active' width='".$layout['iconWidth']."' style='left:0px;' src='".$theHomeIcon."' >";
			$theStr .= "</a>";
		} else {
			// disabled
			$theStr .= "<img class='me absolute inactive' width='".$layout['iconWidth']."' style='left:0px;' src='".$theHomeIcon."' >";
		}
		// copy
		$theStr .= "<img id='".$theCopyImageId."' ";
		if( $bEnabled ) {
			$theStr .= "class='me absolute active' ";
		} else {
			$theStr .= "class='me absolute inactive' ";
		}
		$theStr .= "width='".$layout['iconWidth']."' style='left:0px;top:".($layout['iconHeight']*1)."px' src='".$theCopyIcon."' ";
		if( $bEnabled ) {
			$theStr .= "onclick='copyURI(".$this->data['index'].")'";
		}
		$theStr .= ">";

		// whitepaper
		if('' != $this->data['wp']) {
			$theStr .= "<a href='".$theWPLocation."' target=_self>";
			$theStr .= "<img id='copyWPId' class='me absolute active' width='".$layout['iconWidth']."' style='left:0px;top:".($layout['iconHeight']*2)."px' src='".$theWPIcon."' >";
			$theStr .= "</a>";
		}

		$theStr .= "</div>"; // absolutetools

		return $theStr;
	}

	// the calculations will be stored in $this->data['layout']
	private function calculations()
	{
		$layout = array('margSize'=>(int)10,
						'margTB'=>(int)5
					);

		// calculate sizes
		$layout['theTotalWidth'] = max($this->data['theTotalWidth'],180);
		$layout['imageWidthSize'] = ($layout['theTotalWidth'] * 0.80)-($layout['margSize']*2);
		$layout['lColumnHeight'] = $layout['imageWidthSize']+($layout['margTB']*2);
		$layout['sideBarWideSize'] = ($layout['theTotalWidth'] * 0.20);
		$layout['iconWidth'] = min((int)($layout['theTotalWidth']*0.14),42);

		$layout['mainDivWidth'] = $layout['imageWidthSize'];
		$layout['mainDivHeight'] = $layout['lColumnHeight']-($layout['margTB']*2);

		$layout['toolsDivWidth'] = $layout['sideBarWideSize']-($layout['margSize']*2);
		$layout['toolsDivHeight'] = $layout['mainDivHeight'];
		$layout['toolsDivLeft'] = $layout['mainDivWidth']+($layout['margSize']*3);

		// There will be four slots for icons
		$layout['iconHeight'] = ($layout['iconWidth']+2);

		$this->data['layout']= $layout;
	}
	private function footer()
	{
		$theStr ='';

		$theNetworkInfo = $this->data['networkInfo'];
		$cssFooter = 'footer';

		// network link
		$theStr .= "<a href='".$theNetworkInfo."' target=_self>";
		$theStr .= "<div class='".$cssFooter."' id='footerId' >Selene Network</div>";
		$theStr .= "</a>";

		return $theStr;
	}

	private function html()
	{
		self::calculations();

		$layout = $this->data['layout'];


		$theFloat = $this->data['theFloat'];

		$theTitle = $this->data['metadata']['name'];
		$theLocation = self::theLocation(false); // include agent and contract
		$theWPLocation = self::theWPLocation();
		$theHomeIcon = $this->data['homeIcon'];
		$theCopyIcon = $this->data['copyIcon'];
		$theNetworkInfo = $this->data['networkInfo'];
		$theInfoIcon = $this->data['infoIcon'];
		$theWPIcon = $this->data['wpIcon'];
		$theIndex = $this->data['index'];

		$cssTitle = 'title';
		if( $this->bMobile )
		{
			$cssTitle = 'titlem';
		}
		$cssFooter = 'footer';

		$bEnabled = true;
		if( $this->data['disable'] != 0 ) {
			$bEnabled = false;
		}


		// layout
		$theStr = '';
		if( $this->bMobile && 'default' == $theFloat) {
			$theStr .= "<center>";
		}
		if('center' == $this->data['theFloat']) {
			$theStr .= "<center>";
			$theFloat = 'default';
		}
		$theStr .= "<div class='total' style='width:".$layout['theTotalWidth']."px;float:".$theFloat."'>";
		$theStr .= "<div class='".$cssTitle."' id='titleId' >".$theTitle."</div>";

		$theStr .= "<div class='lcolumn'  >";
		$theStr .= "<div class='relative' style='width:".$layout['theTotalWidth']."px;height:".$layout['lColumnHeight']."px'>";
		$theStr .= self::absoluteimagehtml();
		$theStr .= self::absolutetoolshtml();
		$theStr .= "</div>"; // relative
		$theStr .= "</div>"; // lcolumn

		$theStr .= self::footer();

		$theStr .= "</div>"; // total

		if( $this->bMobile && 'default' == $theFloat) {
			$theStr .= "</center>";
		}
		if('center' == $this->data['theFloat']) {
			$theStr .= "</center>";
		}

		return $theStr;
	}

	// main function
	public function main()
	{
		$theStr = '';
		self::fetchProject();

		$theStr.= self::css();
		$theStr.= self::script();
		$theStr.= self::html();

		return $theStr;
	}
}




