let arrGlobals = [];

function readItem(_item, _asNumber) {
    let g_object;
    g_object = document.getElementById(_item + "Id");
    if (null != g_object) {
        if (_asNumber) {
            arrGlobals[_item] = Number(g_object.innerHTML);
        } else {
            arrGlobals[_item] = g_object.innerHTML;
        }
        if (arrGlobals['debugjs'] > 1) { console.log(_item + ': ' + arrGlobals[_item]); }
    }
}

function readGlobals() {

    // now 
    readItem('debugjs', true);
    readItem('siteURL', false);
    readItem('path', false);
    readItem('root', false);
    readItem('participantAddr', false);
    readItem('agentAddr', false);
    readItem('websiteAddr', false);
    //readItem('GalleryAddr', false);

    // These two values are used for minting.
    readItem('agent', true);
    //readItem('website', true);

    readItem('theWallet', false);
    //readItem('customTitle', false);
    //readItem('customGallery', false);

    readItem('nftWidth', true);
    readItem('nftWidthMobile', true);
    // URL values
    readItem('contract', false);
    readItem('mobile', true);
    readItem('limit', true);
    readItem('account', false);

    arrGlobals['visitor'] = null;
}

let g_arrTrxns = [];
let g_iCount = 0;

//let g_lastBlock = 24686000;
let g_lastBlock = 14686000;
//let g_iLimit = 20;


arrGlobals['ABI'] = [];
arrGlobals['ABI'].push({ "inputs": [{ "internalType": "bytes4", "name": "interfaceId", "type": "bytes4" }], "name": "supportsInterface", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['ABI'].push({ "inputs": [], "name": "projectDataCurrent", "outputs": [{ "internalType": "string", "name": "URI", "type": "string" }, { "internalType": "string", "name": "Project", "type": "string" }, { "internalType": "string", "name": "hash", "type": "string" }], "stateMutability": "view", "type": "function" });
arrGlobals['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "tokenURI", "outputs": [{ "internalType": "string", "name": "", "type": "string" }], "stateMutability": "view", "type": "function" });

// Supported interfaces
arrGlobals['IMetadataV1'] = "0x2839ac8d";

let g_accounts = [];
//let g_visitor; // This is just [0] in g_accounts

/*
This routine is going to fetch all the transactions for each of the
accounts that are in the metamask wallet. They will be stored in the
root. Each account will be an index into the array.
*/
let root = [];

let g_contracts = [];


// colors
let g_bkg = [];
g_bkg['active'] = '#b0f5c6';   // a green
g_bkg['inactive'] = '#f3f5ab'; // a yellow
g_bkg['standard'] = '#f0edeb'; // a grey


document.getElementById('walletAddress').innerHTML = '<span id="connectId" style="line-height:40px">Connect</span>';
arrGlobals['BalanceTfuel'] = null; // amount of Tfuel in account

document.addEventListener("DOMContentLoaded", async function () {
    console.log("In JavaScript wallet routine");

    readGlobals();

    let titleObj = document.getElementById("titleId");
    if (null != titleObj) {
        titleObj.innerHTML = arrGlobals['theWallet'];
    }
    let theIconObj = document.getElementById('walletIconId');
    if (null != theIconObj) {
        theIconObj.style.display = 'none';
    }

    if (window.ethereum) {
        await window.ethereum.request({ method: 'eth_accounts' });
        window.web3 = new Web3(window.ethereum);

        // first thing it to check chain id.
        var id = await web3.eth.getChainId();
        if (id != 361) {
            console.log("not Theta network");
            wrongNetwork();
        } else {
            console.log('correct network');

            // Either we're given an account or we go find them.
            if (arrGlobals['account']) {
                arrGlobals['visitor'] = arrGlobals['account'];

                // hide the main button
                document.getElementById('mainButtonId').style.display = 'none';

                g_accounts[0] = arrGlobals['visitor'];
                root[g_accounts[0]] = [];

            } else {
                g_accounts = await web3.eth.getAccounts();
                console.log('number of accounts: ' + g_accounts.length);
                console.log(g_accounts);

                for (let acts = 0; acts < g_accounts.length; acts++) {
                    root[g_accounts[acts]] = [];
                }
                //console.log(root);
                arrGlobals['visitor'] = g_accounts[0];

                try {
                    //console.log('getting balance');
                    await web3.eth.getBalance(arrGlobals['visitor']).then(g_accountBalanceWei => {
                        // When we get our response, we'll calculate our balance and display what we can.
                        console.log("Balance: " + g_accountBalanceWei);
                        balance = Number(BigInt(g_accountBalanceWei) / BigInt(10000000000000000)) / 100;
                        arrGlobals['BalanceTfuelWei'] = g_accountBalanceWei;
                        arrGlobals['BalanceTfuel'] = balance;
                        button = '<span style="font-size:1em;"><center><b>';
                        accountShort = arrGlobals['visitor'].substring(0, 5).concat('...', arrGlobals['visitor'].substring(38, 42));
                        button = button.concat(accountShort, ' </b><br> <img src=\'https://www.thetascan.io/tfuel_dapp.png\'><span style="font-size:0.90em;"> ', arrGlobals['BalanceTfuel'], ' </span></center></span>');
                        document.getElementById('walletAddress').innerHTML = button
                    });
                } catch (error) { }

            }
            console.log("The Account: " + arrGlobals['visitor']);
            // if getAccounts is unsuccessful, we need to prompt user to connect MetaMask to
            // the website so that it can be used.

            if (arrGlobals['visitor'] === 'undefined') {
                console.log("Need to connect MetaMask");
                noConnection();
            } else {

                console.log(arrGlobals);

                if (arrGlobals['account']) {
                    root[g_accounts[0]]['trxns'] = await getTrxnsEx(arrGlobals['visitor']);
                } else {
                    for (let acts = 0; acts < g_accounts.length; acts++) {
                        if (null != g_accounts[acts]) {
                            root[g_accounts[acts]]['trxns'] = await getTrxnsEx(g_accounts[acts]);
                        }
                        //if (acts >= 1) {
                        //    break;
                        //}
                    }
                }
                console.log(root);

                // now build the framework so it can be filled in.
                buildFramework();

                // now for the async lookup functionality
                ResolveTokens(window.web3);
            }
        }

    } else {

        // hide item
        let theObj = document.getElementById('walletAddress');
        if (null != theObj) {
            theObj.style.display = 'none';
        }

        noMetamask();
    }
});

function makeClickableFilm(_thehref, _index) {
    let Obj = document.getElementById('nftImageLinkFilmId' + _index);
    if (null != Obj) {
        Obj.href = _thehref;
        //console.log('makeClickable: ' + Obj.href);

/*
        let curObj = document.getElementById('nftImageId' + _index);
        if (null != curObj) {
            curObj.style.cursor = "pointer";
        }
*/
    }
    else {
        console.log('nftImageLinkFilmId' + _index + ' missing');
    }

}

function makeClickable(_thehref, _index, _bkg) {
    let Obj = document.getElementById('nftImageLinkId' + _index);
    if (null != Obj) {
        Obj.href = _thehref;
        //console.log('makeClickable: ' + Obj.href);

        // Only if we setup the link to we make this one green
        // tell user this one is special
        let bgObj = document.getElementById('nft' + _index);
        if (null != bgObj) {
            bgObj.style.background = g_bkg[_bkg];
        }

        let curObj = document.getElementById('nftImageId' + _index);
        if (null != curObj) {
            curObj.style.cursor = "pointer";
        }
    }
    else {
        console.log('nftImageLinkId' + _index + ' missing');
    }
}
function showItem(_index) {
    let Obj = document.getElementById('nft' + _index);
    if (null != Obj) {
        Obj.style.display = 'block';
    }
}

async function standardMetadata(_index, _theTokenURI) {

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + _theTokenURI;
    //console.log($url);
    await fetch($url).then(response => {
        if (null != response) {
            response.json().then(theObj => {
                if (null != theObj) {
                    //console.log('image: '+theObj.image);

                    // set the source for the NFT
                    let Obj = document.getElementById('nftImageId'+_index);
                    if (null != Obj) {
                        Obj.src = theObj.image;
                    } else {
                        console.log('nftImageId'+_index+' not found');
                    }

                    makeClickable(theObj.image, _index, 'standard');
                    showItem(_index);
                }
            });
        }
    });

}

//    requestPermissions();
async function requestPermissions() {

    if (window.ethereum) {

        console.log('in requestPermissions()');
        await window.ethereum.request({ method: 'eth_requestAccounts' });


//        await window.ethereum.enable().then(function (acc) { console.log(acc[0]);});
/*
        await window.ethereum.request({
            "method": 'eth_requestAccounts',
            "params": []
        });
*/
/*
        await window.ethereum.request({
            "method": 'wallet_getPermissions',
            "params": []
        });
*/
/*
        await window.ethereum.request({
            method: 'wallet_requestPermissions',
            params: [{ eth_accounts: {} }]
        });
*/
    }
    // refresh the page afterwards
    //window.location.reload();
}

/*
Need to call the blockchain to get the projectDataCurrent(). Then, parse that
to get the home location for this NFT. we only do this for active items.
*/
async function projectRoot(_theMeta, _index, _contractIndex, _acts) {
    try {
        await g_contracts[_contractIndex]['obj'].methods.projectDataCurrent().call().then(projectObj => {
            if (null != projectObj) {
                //console.log('projectObj: ');
                //console.log(projectObj);
                //console.log(_theMeta);

                // the home location for the project is URI+project+'.php' or is home
                // exists in the metadata, URI+home+'.php'
                let homeLink = '';
                if (typeof _theMeta.home !== 'undefined') {
                    //console.log(_theMeta);
                    //console.log('home is not undefined');
                    // This path says that the NFT lives in the real world and
                    // has a path to some server somewhere. Because we have a 
                    // image, it's probably live, point to it.

                    homeLink += projectObj.URI + _theMeta.home + '.php';
                    if (arrGlobals['agent'] > 0) {
                        homeLink += '/'+'?agent=' + arrGlobals['agent'];
                    }
                } else {
                    //console.log('home is undefined');

                    // This says that the metadata says there is no home page for this
                    // nft. Thus, we're going to use the core code to reference it.

                    homeLink += arrGlobals['root'] + '?contract=' + g_contracts[_contractIndex]['addr'];
                    if (arrGlobals['agent'] > 0) {
                        homeLink += '&agent=' + arrGlobals['agent'];
                    }
                }
                if (arrGlobals['debugjs']) {
                    console.log(homeLink);
                }

                // now impliment the reel and video_id functionality.
                if (typeof _theMeta.video_reel !== 'undefined') {
                    //console.log(_theMeta.video_reel);

                    // if the token metadata reports a video_reel in the token json file
                    // (where the image is found), then the reel image will be made clickable.

                    let filmObj = document.getElementById('nftTokenVideoReelId' + _index);
                    if (null != filmObj) {
                        filmObj.style.display = 'block';

                        // Build the link to the video API
                        let videoLink = arrGlobals['root'] + 'reel/?reel=' + _theMeta.video_reel;
                        //console.log(videoLink);
                        makeClickableFilm(videoLink, _index);
                    }
                } else if (typeof _theMeta.video_id !== 'undefined') {
                    //console.log(_theMeta.video_id);
                    // If the token metadata reports a video_id in the token json file (where
                    // the image is found), then the film image will be made clickable.

                    let filmObj = document.getElementById('nftTokenVideoId' + _index);
                    if (null != filmObj) {
                        filmObj.style.display = 'block';

                        // Build the link to the video API
                        let videoLink = arrGlobals['root'] + 'video/?id=' + _theMeta.video_id;
                        //console.log(videoLink);
                        makeClickableFilm(videoLink, _index);
                    }
                }
                // Image always takes the user to the project home page.
                makeClickable(homeLink, _index, 'active');

                showItem(_index);
            }
        });
    } catch (err) {
        console.log(err);
    }
}

async function enhancedMetadata(_index, _theTokenURI, _contractIndex, _acts) {

    //console.log('enhancedMetadata:');
    //console.log(_theTokenURI);
    // Need to fetch through php.
    $url = arrGlobals['siteURL'] + 'dsn/?data=' + _theTokenURI;
    //console.log($url);
    await fetch($url).then(response => {
        if (null != response) {
            response.json().then(theMeta => {
                if (null != theMeta) {
                    //console.log(theMeta);
                    //if (theMeta.name == 'Max PW Demo V1') {
                    //    console.log(theMeta);
                    //    console.log('video_id: ' + theMeta.video_id);
                    //}
                    //if (typeof theMeta.video_id !== 'undefined') {
                    //    console.log(theMeta.video_id);
                    //}

                    // set the source for the NFT
                    let imageObj = document.getElementById('nftImageId' + _index);
                    if (null != imageObj) {
                        imageObj.src = theMeta.image;
                    }

                    if (0 == _acts) {
                        // now build the link
                        projectRoot(theMeta, _index, _contractIndex, _acts);

                    } else {

                        let linkObj = document.getElementById('nftImageLinkId' + _index);
                        if (null != linkObj) {
                            linkObj.removeAttribute("href");
                            //console.log('href: '+linkObj.href);
                            //linkObj.href = '';
                        }

                        // want yellow background and on click launch metamask to switch accounts.
                        // tell user this one is special

                        // TODO: Figure out how to modify onClick to request account change.

                        makeClickable(theMeta.image, _index, 'inactive');

                        ////TODO: come up with another solution for getting the user
                        //// to switch accounts to make this NFT clickable.

                        //let curObj = document.getElementById('nftImageId' + _index);
                        //if (null != curObj) {
                        //    curObj.style.cursor = "pointer";
                        //    curObj.addEventListener('click', requestPermissions);
                        //}

                        showItem(_index);
                    }
                }
            });
        }
    });

}

// fetch the image
async function standardToken(_contractIndex, _acts, _index) {

    let theTrxnObj = root[g_accounts[_acts]]['trxns'][_index];
    let tokenId = theTrxnObj.token;
    try {
        await g_contracts[_contractIndex]['obj'].methods.tokenURI(tokenId).call().then(theTokenURI => {
            if (null != theTokenURI) {
                // Now fetch the json data so it can be used building the image
                //console.log(_index + ' ' + theTokenURI);
                standardMetadata((_index + root[g_accounts[_acts]]['offset']), theTokenURI);
            }
        });
    } catch (err) {
        console.log(err);
    }
}
async function enhancedToken(_contractIndex, _acts,_index) {

    let theTrxnObj = root[g_accounts[_acts]]['trxns'][_index];
    let tokenId = theTrxnObj.token;
    try {
        //
        // NOTE: If the token has been burnt, the contract might error out on the
        // URI call. 
        //
        await g_contracts[_contractIndex]['obj'].methods.tokenURI(tokenId).call().then(theTokenURI => {
            if (null != theTokenURI) {
                // Now fetch the json data so it can be used building the image
                //console.log('here: ' + (_index + root[g_accounts[_acts]]['offset']) + ' ' + theTokenURI);
                enhancedMetadata((_index + root[g_accounts[_acts]]['offset']), theTokenURI, _contractIndex, _acts);
            }
        });
    } catch (err) {
        //console.log("hit error");
    }
}


// returns an index into the array of contract objects
function getContractObjIndex(_web3,_contract) {
    let it = 0;
    for (it = 0; it < g_contracts.length; it++) {
        if (_contract == g_contracts[it]['addr']) {
            //console.log('found obj for: ' + _contract);
            return it;
        }
    }
    // else, we allocate it
    g_contracts[it] = [];
    g_contracts[it]['obj'] = new _web3.eth.Contract(arrGlobals['ABI'], _contract);
    g_contracts[it]['addr'] = _contract;
    //console.log('created obj for: ' + it);
    return it;
}

async function resolveToken(_web3, _acts, _ioffset, _index) {

    // look at g_arrTrxns[_index]
    let theTrxnObj = root[g_accounts[_acts]]['trxns'][_index];

    //console.log();
    //console.log('look this up: ' + theTrxnObj.contract);

    let theContractIndex = getContractObjIndex(_web3,theTrxnObj.contract);
    //console.log('contract Index: ' + theContractIndex);

    // test to see if the failure is coming from participant contract.
    if (g_contracts[theContractIndex]['addr'] == arrGlobals['participantAddr']) {
        //console.log('Skip Participant');
        enhancedToken(theContractIndex, _acts, _index);
    } else {
        //g_contracts[_index] = new _web3.eth.Contract(arrGlobals['ABI'], g_arrTrxns[_index].contract);
        try {
            await g_contracts[theContractIndex]['obj'].methods.supportsInterface(arrGlobals['IMetadataV1']).call().then(theResult => {
                if (theResult) {
                    // supports our interface
                    //console.log(theTrxnObj.contract + ' Supports request');
                    enhancedToken(theContractIndex, _acts, _index);
                } else {
                    // doesn't support our interface.
                    //console.log(theTrxnObj.contract + ' No Support');
                    standardToken(theContractIndex, _acts, _index);
                }
            });
        } catch (err) {
            console.log(err);
        }
    }
}

// This function gets the token information filled in.
async function ResolveTokens(_web3) {

    let arrAct = [];
    let ioffset = 0;
    let iacts = 0;
    //console.log('resolveTokens: acconts:' + g_accounts.length);
    for (let acts = 0; acts < g_accounts.length; acts++) {
        if (null != g_accounts[acts]) {

            iacts = g_accounts[acts];
            ioffset = root[iacts]['offset'];
            //console.log('iacts: ' + iacts + ', len: ' + root[iacts]['trxns'].length);

            arrAct = root[iacts];
            //console.log(arrAct);

            if (null != root[iacts]['trxns']) {
                for (let index = 0; index < root[iacts]['trxns'].length; index++) {
                    // Now resolve each NFT
                    //console.log('resolve: ' + ioffset + ' ' + index);

                    resolveToken(_web3, acts, ioffset, index);

                    // set the limit here for pagination functionality
                    if (index >= arrGlobals['limit']) {
                        break;
                    }

                    await delay(100); // don't overwork the sources.
                }
            }
        }
    }
}
/*
// _acts - index into accounts
// _offset - add to _index to get nftId
// _index - index into account for nft object.
function buildToken(_acts, _offset, _index) {
    let id = (_offset + _index);
    let theSection = '<div class="token column nft" id="nft' + id + '" hidden>';

    let imageId = 'nftImageId' + id;
    let imageLocId = 'nftImageLocId' + id;
    let tokenId = 'nftTokenId' + id;
    let imageLinkId = 'nftImageLinkId' + id;
    let videoId = 'nftTokenVideoId' + id;

    // build left side for image
    theSection += '<div id="' + imageLocId + '" style="padding: 10px 2px 15px 2px">';
    theSection += '<div style="height:125px;width:125px">';
    theSection += '<a id="' + imageLinkId + '" href="" target=_self>';
    theSection += '<img class="token" id="' + imageId+'" src="">';
    theSection += '</a>';

    theSection += '<div><img class="token" id="' + videoId + '" src=""></div>';

    theSection += '</div>';
    theSection += '</div>';

    theSection += '<div id="' + tokenId + '">';
    let theTrxnObj = root[g_accounts[_acts]]['trxns'][_index];
    theSection += 'Token ' + theTrxnObj.token;
    theSection += '</div>';

    theSection += '</div>';
    return theSection;
}
*/
// _acts - index into accounts
// _offset - add to _index to get nftId
// _index - index into account for nft object.
function buildTokenEx(_acts, _offset, _index) {
    let id = (_offset + _index);

    // Calculations for NFT item
    let leftRightTop = 5; //px
    let width = arrGlobals['nftWidth'];
    let height = ((width * 5) / 4); //px
    let imgMaxWidth = width - (leftRightTop * 2); //px
    let imgMaxHeight = width;
    //console.log('width: '+ width + ", height: " + height);

    let imageId = 'nftImageId' + id;
    let imageLocId = 'nftImageLocId' + id;
    let tokenId = 'nftTokenId' + id;
    let imageLinkId = 'nftImageLinkId' + id;
    let imageLinkFilmId = 'nftImageLinkFilmId' + id;
    let videoId = 'nftTokenVideoId' + id;
    let videoReelId = 'nftTokenVideoReelId' + id;

    // Image spacing for both images
    let imgSpace = 'left: ' + leftRightTop + 'px;max-width:' + imgMaxWidth + 'px;max-height:' + imgMaxHeight+'px;';
    //$nftImage = $GLOBALS['theRootURL'].'/nfts/paywithv1/images/pwv1.jpg';
    let filmImage = arrGlobals['siteURL'] + 'dsn/images/film.png';
    let reelImage = arrGlobals['siteURL'] + 'dsn/images/reel.png';
    let bkclr = g_bkg['standard'];

    //console.log('nft id ' + id);
    let theSection = '<div class="tokenrel" id="nft' + id + '" style="background-color:' + bkclr + ';width:' + width + 'px;height:' + height +'px">';

    // Main image
    theSection += '<div>';
    theSection += '<a id="' + imageLinkId + '" href="" target=_self>';
    theSection += '<img class="tokenrel" style="top: ' + leftRightTop + 'px;' + imgSpace + '" id="' + imageId + '" src="">';
    theSection += '</a>';
    theSection += '</div>';

    // secondary image
    theSection += '<div>';
    theSection += '<a id="' + imageLinkFilmId + '" href="" target=_self>';
    theSection += '<img class="tokenrel" style="bottom: 1.75em;' + imgSpace + '" id="' + videoId+'" src="' + filmImage + '" hidden>';
    theSection += '<img class="tokenrel" style="bottom: 1.25em;' + imgSpace + '" id="' + videoReelId + '" src="' + reelImage + '" hidden>';
    theSection += '</a>';
    theSection += '</div>';

    // build in the token id
    theSection += '<div class="nfttitle" style="bottom: 0;width:'+width+'px" id="' + tokenId + '">';
    let theTrxnObj = root[g_accounts[_acts]]['trxns'][_index];
    theSection += 'Token '+theTrxnObj.token;
    theSection += '</div>';

    theSection += '</div>';
    //console.log(theSection);

    return theSection;
}


/*
This routine builds the html for both sections. Because the nfts float, every
section needs to correct for that. if we're on mobile, we break the line after every
second NFT. 
*/
function buildFramework() {
    let theActiveHTML = '';
    let theWaitingHTML = '';

    if (arrGlobals['mobile']) {
        arrGlobals['nftWidth'] = arrGlobals['nftWidthMobile'];
    }

    let ioffset = 0; // total of what has come before
    for (let acts = 0; acts < g_accounts.length; acts++) {
        if (null != g_accounts[acts]) {
            root[g_accounts[acts]]['offset'] = ioffset;

            if (acts != 0) {
                theWaitingHTML += '<div >'; // style="font-size: 1.25em;"
                let theActNum = g_accounts[acts].substring(0, 7) + '...' + g_accounts[acts].substring(37);
                let thehyperLink = 'https://explorer.thetatoken.org/account/' + g_accounts[acts];
                let theLink = '<a href="' + thehyperLink+'" target=_self>' + theActNum+'</a>';

                theWaitingHTML += '<div style="text-align: center">' + theLink +'</div>';
            }
            if (null != root[g_accounts[acts]]['trxns']) {
                for (let index = 0; index < root[g_accounts[acts]]['trxns'].length; index++) {
                    //console.log('offset: ' + ioffset + ' index: ' + index + ' nftIndex: ' + (ioffset + index));

                    if (acts == 0) {
                        // build active
                        theActiveHTML = theActiveHTML + buildTokenEx(acts, ioffset, index);
                        if (arrGlobals['mobile']) {
                            if ((index % 2) == 1) {
                                theActiveHTML += '<div style="clear: both"></div>';
                            }
                        }
                    } else {
                        // build inactive
                        // todo, add the account address as header
                        theWaitingHTML = theWaitingHTML + buildTokenEx(acts, ioffset, index);
                        if (arrGlobals['mobile']) {
                            if ((index % 2) == 1) {
                                theWaitingHTML += '<div style="clear: both"></div>';
                            }
                        }
                    }
                    //console.log(root[g_accounts[acts]]);
                }
                ioffset += root[g_accounts[acts]]['trxns'].length;
            }
            if (acts != 0) {
                theWaitingHTML += '<div style="clear: both"></div>';
                theWaitingHTML += '</div>';
            }
        }
    }

    let htmlObj = document.getElementById("holdingNFTRowId");
    if (null != htmlObj) {
        // here.
        let theSec = '<div>';
        theSec += theActiveHTML;
        theSec += '<div style="clear: both"></div>';
        theSec += '</div>';

        htmlObj.innerHTML = theSec;
    }

    htmlObj = document.getElementById("waitingNFTRowId");
    if (null != htmlObj) {
        htmlObj.innerHTML = theWaitingHTML;
    }
}


/*
//
// This routine gets a list of the last transactions for this account. 
// It then places a hard stop at block g_lastBlock.
//
// https://www.thetascan.io/api/721/?address=0x158D916596E7D76C029Cf35D027acf849869bB26&type=transactions
async function getTrxns(_act) {

    let laServer = 'https://www.thetascan.io/api/721/';
    let laAddr = '?address=' + _act;
    let laTail = '&type=transactions';

    theURL = laServer+laAddr+laTail;
    //console.log(theURL);

    let rHolds = []; // all transactions that represent an asset

    let response = await fetch(theURL);
    if (null != response) {
        let theTrxns = await response.json();
        if (null != theTrxns) {
            // we got back a non-zero array.
            //console.log('results: ' + theTrxns.length);
            //console.log(theTrxns[0]);

            let nftIndex = 0;
            //g_iCount = 0;
            let index = 0;
            while (theTrxns[index]) {

                // If it's in the time frame we're looking at
                if (theTrxns[index].block > g_lastBlock) {
                    // And if we're recieving
                    //console.log('Trxn: '+theTrxns[index].recieving_address);
                    //console.log('visitor: '+_act);
                    
                    if (theTrxns[index].recieving_address.toLowerCase() == _act.toLowerCase()) {
                        console.log(theTrxns[index].token + ' ' + theTrxns[index].contract);

                        // in order to add this transaction to the record, there must not 
                        // be another recieve of this same token id already in the list. Note
                        // that the first one in the list is the latest one.
                        let bFound = false;
                        for (let inList = 0; inList < rHolds.length; inList++) {
                            if ((rHolds[inList].token == theTrxns[index].token) &&
                                (rHolds[inList].contract == theTrxns[index].contract)) {
                                //console.log(theTrxns[index]);
                                bFound = true;
                                break;
                            }
                        }
                        if (!bFound) {
                            //console.log(theTrxns[index]);
                            rHolds[nftIndex] = theTrxns[index];
                            nftIndex++;
                        }
                    }
                } else {
                    // we're done
                    break;
                }

                //TODO: Figure out pagination later
                if (nftIndex >= arrGlobals['limit']) {
                    break;
                }

                index++;
            }
            g_iCount += nftIndex;
            console.log('nftIndex: ' + nftIndex + ' g_iCount: ' + g_iCount);
            console.log(rHolds);
        }
    }
    return rHolds;
}
*/
// new routine asks ThetaScan for a sorted list of NFTs
// https://www.thetascan.io/api/721/?address=0x158D916596E7D76C029Cf35D027acf849869bB26&type=list&sort=date
async function getTrxnsEx(_act) {

    let laServer = 'https://www.thetascan.io/api/721/';
    let laAddr = '?address=' + _act;
    let laTail = '&type=list&sort=date';

    theURL = laServer + laAddr + laTail;
    //console.log(theURL);

    let rHolds = []; // all transactions that represent an asset

    let response = await fetch(theURL);
    if (null != response) {
        let theTrxns = await response.json();
        if (null != theTrxns) {
            // we got back a non-zero array.
            //console.log('results: ' + theTrxns.length);
            //console.log(theTrxns[0]);

            let nftIndex = 0;
            //g_iCount = 0;
            let index = 0;
            while (theTrxns[index]) {

                //console.log(theTrxns[index]);
                rHolds[nftIndex] = theTrxns[index];
                nftIndex++;

                //TODO: Figure out pagination later
                if (nftIndex >= arrGlobals['limit']) {
                    break;
                }

                index++;
            }
            g_iCount += nftIndex;
            //console.log('nftIndex: ' + nftIndex + ' g_iCount: ' + g_iCount);
            //console.log(rHolds);
        }
    }
    return rHolds;
}

