let arrGlobals = [];

function readItem(_item, _asNumber) {
    let g_object;
    //console.log('reading: ' + _item + "Id");
    g_object = document.getElementById(_item + "Id");
    if (null != g_object) {
        if (_asNumber) {
            arrGlobals[_item] = Number(g_object.innerHTML);
        } else {
            arrGlobals[_item] = g_object.innerHTML;
        }
        if (arrGlobals['debugjs'] >= 1) { console.log(_item + ': ' + arrGlobals[_item]); }
    } else {
        console.log('g_object=null');
    }
}

function readGlobals() {

    // now 
    readItem('debugjs', true);
    readItem('siteURL', false);
    readItem('path', false);
    readItem('root', false);
    readItem('participantAddr', false);
    readItem('agentAddr', false);
    readItem('websiteAddr', false);
    //readItem('GalleryAddr', false);

    // These two values are used for minting.
    readItem('agent', true);

    readItem('theTitle', false);
}


let g_accounts = [];

document.getElementById('walletAddress').innerHTML = '<span id="connectId" style="line-height:40px">Connect</span>';
arrGlobals['BalanceTfuel'] = null; // amount of Tfuel in account

document.addEventListener("DOMContentLoaded", async function () {
    console.log("In JavaScript video routine");

    readGlobals();

    document.getElementById("titleId").innerHTML = arrGlobals['theTitle'];

    if (window.ethereum) {
        // button reads connect
    } else {
        // hide item
        let theObj = document.getElementById('walletAddress');
        if (null != theObj) {
            theObj.style.display = 'none';
        }
        //noMetamask();
    }

    let theIconObj = document.getElementById('toolsIconId');
    if (null != theIconObj) {
        theIconObj.style.display = 'none';
    }
});


async function displayABI() {
    //console.log('flash the image here');
    let theSrc = document.getElementById("toolsABIImageId").src;
    let theCopiedSrc = theSrc.replace('.png', '_copied.png');
    document.getElementById("toolsABIImageId").src = theCopiedSrc;
    await delay(1000);
    document.getElementById("toolsABIImageId").src = theSrc;
}

async function toolsABI() {

    let srcURL = '';
    let theObj = document.getElementById("toolsABIId");
    if (null != theObj) {
        srcURL = theObj.innerHTML;
    }
    //console.log(srcURL);

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + srcURL;
    //console.log($url);
    fetch($url).then(response => {
        response.json().then(projectObj => {
            //console.log(JSON.stringify(projectObj));
            navigator.clipboard.writeText(JSON.stringify(projectObj)).then(() => {
                //console.log('clipboard successfully set');
                displayABI();

            }, () => {
                //console.log('clipboard write failed');
            });
        });
    });
}

async function displayBC() {
    //console.log('flash the image here');
    let theSrc = document.getElementById("toolsBCImageId").src;
    let theCopiedSrc = theSrc.replace('.png', '_copied.png');
    document.getElementById("toolsBCImageId").src = theCopiedSrc;
    await delay(1000);
    document.getElementById("toolsBCImageId").src = theSrc;
}

async function toolsBC() {

    let srcURL = '';
    let theObj = document.getElementById("toolsBCId");
    if (null != theObj) {
        srcURL = theObj.innerHTML;
    }
    //console.log(srcURL);

    $url = arrGlobals['siteURL'] + 'dsn/?data=' + srcURL;
    //console.log($url);
    fetch($url).then(response => {
        response.json().then(projectObj => {
            //console.log(JSON.stringify(projectObj));
            navigator.clipboard.writeText(JSON.stringify(projectObj)).then(() => {
                //console.log('clipboard successfully set');
                displayBC();

            }, () => {
                //console.log('clipboard write failed');
            });
        });
    });
}
