<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_reel {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		// If the page provides limit, we'll set that here.
		if(isset($_arrParams['video_id']) )
		{
			$this->gData['video_id'] = $_arrParams['video_id'];
		} 
		// If the page provides maxWidth, we'll set that here.
		if(isset($_arrParams['maxWidth']) )
		{
			$this->gData['maxWidth'] = $_arrParams['maxWidth'];
		} 

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		// if the user provides an account on the URL, we name the page
		// 'The NFT Browser'. If there is no account, we're going to look
		// all all the metamask addresses. 'NFT Browsing Metamask Accounts'
		$pageTitle = 'Exploring Video Reel';
		$this->gData['theTitle']=$pageTitle;

		return $this->gData;
/*
		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		$theStr.= $_dsncommon->globalHTML();

		// local page info 
		$theStr.= "<div id='theWalletId'>".$pageTitle."</div>";

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
*/
	}

	public function globalHTML() {

		$rowId = "globalVars";

		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		foreach($this->gData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
	}

	private function errorRow() {
		$theStr ='';

		$theStr .= "<div id='noVideoId' class='fdback' hidden>";
		$theStr .= "<div class='msg'>This Selene Network compatible contract does not report to have any video ids that unlock a tokengated video.</div>";
		$theStr .= "</div>";

		return $theStr;
	}

	//
	// Make this section float left.
	//
	private function singleVideo($_item,$_sec,$_index)
	{
		// The values here should be 10px larger than the max-width in the css.
		$maxWidth = $this->gData['maxWidth']; //270;
		$theClass = 'reel';
		if( $this->gData['mobile'] ) 
		{
			$maxWidth = 400;
			$theClass = 'reelm';
		}
		$maxImageWidth = $maxWidth-10;

		if( isset($_item['video_id']) ) {
			$videoLink = $this->gData['root'].'video/?id='.$_item['video_id'];
		} else if( isset($_item['youtube']) ) {
			$videoLink = $this->gData['root'].'video/?yt='.$_item['youtube'];
		}
		//$videoLink="javascript:void(0);";

		//echo "section: ".$_sec.", index: ".$_index."<br>";
		$id = "sec".strval($_sec)."index".strval($_index);
		$divId = "div".$id;
		$hrefId = "href".$id;
		$imgId = "img".$id;
		$itemId = "item".$id;
		$linkId = "link".$id;

		$theStr = '';
		if( $this->gData['mobile'] ) {
			$theStr .= '<center>';
		}
		$theStr .= '<div id="'.$divId.'" class="'.$theClass.'" style="max-width: '.strval($maxWidth).'px;width: '.strval($maxWidth).'px">';

		$theStr .= '<div id="'.$imgId.'" hidden>'.$_item['image'].'</div>';
		$theStr .= '<div id="'.$linkId.'" hidden>'.$videoLink.'</div>';

		$theStr .= '<div id="'.$itemId.'" hidden>';
		// Javascript displays the image
		$theStr .= '</div>';

		if( isset($_item['name'])) {
			$theStr .= '<div class="reeltitle">'.$_item['name'].'</div>';
		}
		if( isset($_item['description'])) {
			$theStr .= '<div class="reeldesc">'.$_item['description'].'</div>';
		}
		$theStr .= '</div>';
		if( $this->gData['mobile'] ) {
			$theStr .= '</center>';
		}
		return $theStr;
	}

	public function thePage($_arrParams,$_arrTheData)
	{
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		// if the user provides a title in the file, we'll use it here
		if( isset($_arrTheData['title'])) 
		{
			$this->gData['theTitle'] = $_arrTheData['title'];
		} else {
			// default title is
			$this->gData['theTitle'] = "Video Reel";
		}

		echo "<!DOCTYPE html>";

		$theTitle = "Selene Network Reel";
		$theDesc = "Distributed Sales Network with Custom NFTs.";

		echo $dsncommon->headerInfo($theTitle,$theDesc);

		// load project common functionality
		$theCommonJSFile = $this->gData['root'].'dsncommon.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theCommonJSFile."' defer></script>";

		// When we add script for the client machine to fetch, it has to be built off
		// the URL (theRootUR). 

		$theVJSFile = $this->gData['root'].'reel/rcore.js';
		//var_dump($theVJSFile);
		echo "<script type='text/javascript' src='".$theVJSFile."' defer></script>";

		//
		// Start of the body here...
		//
		echo "<body>";
		echo $dsncommon->theCSS();
		echo '<div class="blackout" id="blackoutId" >';
		echo self::globalHTML();

		// Here is were the page gets built. 
		echo $dsncommon->connectRow(null);
		echo $dsncommon->errorRow();

		//echo "reel: ".$_arrParams['reel']."<br>";

		// Loop over the reel and build the entries
		if( isset($_arrTheData['reel'])) 
		{
			// how many in the reel?
			$iCount = count($_arrTheData['reel']);
			//echo "iCount: ".$iCount."<br>";

			echo '<div class="page">';
			foreach($_arrTheData['reel'] as $index => $key)
			{
				echo "<div style='clear: both'></div>";
				echo '<div class="section">';

				if( isset($key['section']) ) {
					echo '<div class="sectitle">'.$key['section'].'</div>';
				}
				if( isset($key['description']) ) {
					echo '<div class="secdesc">'.$key['description'].'</div>';
				}

				// now gating for section
				$gatingContract = '';
				if( isset($key['gated']) ) {
					$gatingContract=$key['gated'];
				}
				$gatingId = 'gatesec'.strval($index);
				echo '<div id="'.$gatingId.'" hidden>'.$gatingContract.'</div>';

				// Need to log the count of videos for each section
				$countOfSections = count($_arrTheData['reel']);
				echo "<div id='countOfSections' hidden>".$countOfSections."</div>";

				$sectionId = $index;
				$sectionCount = "videoCount".$sectionId;
				echo "<div id='".$sectionCount."' hidden>".count($key['videos'])."</div>";

				foreach($key['videos'] as $reelIndex => $reelKey)
				{
					echo self::singleVideo($reelKey,$index,$reelIndex);
					// now put in a clear that is hidden
					$theId = 'reelSec'.$sectionId.'Row'.$reelIndex;
					//echo "TheId: ".$theId."<br>";
					echo "<div id='".$theId."' style='clear: both' hidden></div>";
				}
				echo "</div>";
				// clear out the formating.
				echo "<div style='clear: both'></div>";
			}

			echo "</div>";
			// clear out the formating.
			echo "<div style='clear: both'></div>";
		}

		echo $dsncommon->theFooter();
		echo "</div>";
		echo "</body>";
		echo "</html>";
	}
}


