<?php
/*
This file is used to define a few variables that are used for the entire project.
One of the key assumptions that this code makes is that there will be a directory
structure relative to the root that is the same on all systems. That structure mimics:

http(s)://xyz.server.ext/ - which is the siteURL.

Off of the site, we have some path to the root directory which we call path. 
In our case path='dsn/'.

Off the siteURL.path, the project is expecting:

siteURL.path - location where project is unzipped
siteURL/nfts/agentv1 - location for agent project

All other information is gathered from the NFTs themselves.

---- Edit variables ----

In order to recieve commissions, you have to report both an agent and website
id to the minting routines. The default for both these values is provided here.

AgentId - update this value to your agent id

WebsiteId - update this value to your website id

siteLogo - This is the little image that is displayed in the upper left. The default
  is a home icon. Feel free to provide your own website icon here.

GalleryAddr - This is for the default view. If you launch a smart contract that
  supports the IGallery Interface and register contracts on it, this code will 
  enumerate that contract and display the projects that you've selected.

PennyOracleAddr - This is the default Penny Oracle that is used by the project.
  The penny oracle supports the IPennyOracleV1 interface for getting the prices of
  the projects in dollars.

Notes

The project allows a few variables to be overridden by the URL. For instance, when
someone links to this code and the URL has "agent=N" on it, that agent number will
override what is provided below. There are no overrides on the website id. 

*/
class CDSNReadme {

	private $data = array();

	function __construct() {

		$this->data['REQUEST_SCHEME']=$_SERVER['REQUEST_SCHEME'];

		// These two values should resolve to wallets that you own. The default values
		// are the project creators. If you want to get credited, change these.
		$this->data['agent']=(int)1001;
		$this->data['website']=(int)1;

		// NOTE: This should be the only place where $GLOBALS[] is referenced outside
		//   of the index files.
		$this->data['siteURL']=$GLOBALS['theRootURL'].'/';
		$this->data['path']='dsn/';
		//echo "Install Location is root: ".$this->data['siteURL'].$this->data['path']."<br>";
		$this->data['root']=$this->data['siteURL'].$this->data['path'];

		// The 'homelink' will be the link used for the 'home' icon in the upper left of
		// the Selene Network rendered page. 
		$this->data['homelink']=$this->data['siteURL'];
		// This is the home icon that can be replaced by a small website specific image 49x48.png.
		$this->data['siteLogo']=$this->data['siteURL'].$this->data['path'].'images/home_small.png';

		$this->data['PennyOracleAddr']="0x945c5b985a0d4ba6c42a88c1330bded9cd442389";
		$this->data['GalleryAddr']="0xda2f740fee918626f0b6194487869020adc9bc33"; // default Gallery

		$this->data['participantAddr']="0xd1ccd1983e010aa4319631b8e2b2a25bd62d4bae";
		$this->data['agentAddr']="0xf2c3eae1e4c38d4308e238a36d6f104fbec4e42e";
		$this->data['websiteAddr']="0x743e3f6de0996637eb31b4202f5d9b6a607775d7";

		// 'customGallery' is used as the title for the top of the Gallery unroll.
		$this->data['customGallery'] = 'AmorStyle NFT Gallery';
		// 'tabTitle' is used on the tab when visitor is served the /dsn page.
		$this->data['tabTitle'] = 'AmorStyle Selene Network';

		// 'galleryLimit' number of contracts to display in the Gallery
		$this->data['galleryLimit'] = 12;

		$this->data['showHolderSection'] = 1;

		// for footer reference.
		$this->data['networkInfo'] = 'https://amorstyle.com/selnet/';

		// This value is used to size the clickable NFT that is shown both
		// after minting and in the wallet. It should be a value between
		// 100 and 260. 128 is the default.
		$this->data['nftWidth']=128;
		$this->data['nftWidthMobile']=180;

		// for wallet functionality
		$this->data['limit']=(int)20;

		// set the following value to 1 for lite level debug spew, default 0.
		$this->data['debug']=0;   // echos glboal variables on screen (ether: 0,1 or 2)
		$this->data['debugjs']=0; // console logs global variables (either 0 or 1)

}
	public function data() {
		return $this->data;
	}

}