<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://amorstyle.com
 * @since             1.0.0
 * @package           Selnet
 *
 * @wordpress-plugin
 * Plugin Name:       selenenetwork
 * Plugin URI:        https://amorstyle.com
 * Description:       This plugin is used by Wordpress sites to interact with Selene Network NFT projects.
 * Version:           1.0.0
 * Author:            Amor
 * Author URI:        https://amorstyle.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       selnet
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SELNET_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-selnet-activator.php
 */
function activate_selnet() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-selnet-activator.php';
	Selnet_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-selnet-deactivator.php
 */
function deactivate_selnet() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-selnet-deactivator.php';
	Selnet_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_selnet' );
register_deactivation_hook( __FILE__, 'deactivate_selnet' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-selnet.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_selnet() {

	$plugin = new Selnet();
	$plugin->run();

}
run_selnet();
