(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

})(jQuery);

const delay = ms => new Promise(res => setTimeout(res, ms));

async function displayCopy(_newImage, _index) {
    let obj = document.getElementById('copyImageId' + _index);
    if (null != obj) {
        let oldImage = obj.src;
        obj.src = _newImage;
        await delay(1000);
        obj.src = oldImage;
    } else {
        console.log('null copyImageId' + _index);
    }
}

async function copyURI(_index) {
    let theURL = '';

    let theObj = document.getElementById('theShareURLId' + _index);
    if (null != theObj) {
        theURL = theObj.innerHTML;
        //console.log('theShareURLId' + _index + ": " + theURL);
    } else {
        console.log('null theShareURLId' + _index);
    }

    let theAgent = '';
    theObj = document.getElementById('theShareAgentId' + _index);
    if (null != theObj) {
        theAgent = theObj.innerHTML;
        //console.log('theShareAgentId' + _index + ": " + theAgent);
    } else {
        console.log('null theShareAgentId' + _index);
    }

    let theContract = '';
    theObj = document.getElementById('theShareContractId' + _index);
    if (null != theObj) {
        theContract = theObj.innerHTML;
        //console.log('theShareContractId' + _index + ": " + theContract);
    } else {
        console.log('null theShareContractId' + _index);
    }

    let newImage = '';
    theObj = document.getElementById('theShareCopiedId' + _index);
    if (null != theObj) {
        newImage = theObj.innerHTML;
        //console.log('theShareCopiedId' + _index + ": " + newImage);
    } else {
        console.log('null theShareCopiedId' + _index);
    }

    let copyTxt = theURL + '?agent=' + theAgent + '&contract=' + theContract;
    navigator.clipboard.writeText(copyTxt).then(() => {
        console.log(copyTxt);
        //console.log('clipboard successfully set');
        displayCopy(newImage, _index);

    }, () => {
        //console.log('clipboard write failed');
    });
}



