<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

/*
The base php and js files are designed to provide the basic functionality required
to support the IMetadataHash, ICount and IPay interfaces. These files are intended
to be used on websites that offer SeleneNet compatible projects.

Note that the base class will:
- act like a gallery if a gallery contract is provided.
- act like a single project
- provide URL override

The layout for the page is handled by the base class. If there is custom code that the project
wants to include, it will happen after the mint button and before the agent information.
*/


class Theta_wal {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		// if the user provides an account on the URL, we name the page
		// 'The NFT Browser'. If there is no account, we're going to look
		// all all the metamask addresses. 'NFT Browsing Metamask Accounts'
		$pageTitle = 'NFT Browsing Metamask Accounts';
		if( isset($this->gData['account']) ) {
			$pageTitle = 'The NFT Browser';
		}
		$this->gData['theWallet']=$pageTitle;

		return $this->gData;
/*
		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		$theStr.= $_dsncommon->globalHTML();

		// local page info 
		$theStr.= "<div id='theWalletId'>".$pageTitle."</div>";

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
*/
	}

	public function globalHTML() {

		$rowId = "globalVars";

		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		foreach($this->gData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
	}

	private function errorRow() {
		$theStr ='';
		// Always have a section about installing MetaMask.
		$theStr .= "<div id='noMetamaskId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>Metamask provides the communication functionality for interacting with blockchains. Without it installed, this code will be unable to fetch NFT information.</div>";
		$theStr .= "<div class='msg'>If you are visiting from within a PC based browser, please click the 'MetaMask' button above and install the appropriate browser extension.</div>";
		$theStr .= "<div class='msg'>If you are visiting from a mobile device, please install the MetaMask app and browse this website from within that app.</div>";
		$theStr .= "</div>";

		// If Metamask is instlled, but not connected to the website.
		$theStr .= "<div id='noConnectionId' class='fdback'  hidden>";
		$theStr .= "<div class='msg'>Metamask provides the communication functionality for interacting with blockchains.</div>";
		$theStr .= "<div class='msg'>It appears that Metamask is active in your browser, but this website has not been approved, by you, to interact with it. </div>";
		$theStr .= "<div class='msg'>Please press the 'connect' button above to launch Metamask and approve this website for seeing wallet addresses and account balances.</div>";
		$theStr .= "<div class='msg'>Also note that if you approve multiple accounts, this website wallet functionality will be able to see the NFTs in the active and inactive connected accounts.</div>";
		$theStr .= "</div>";
		return $theStr;
	}

	private function theWallet() {
	
		$holdingRowId = "holdingRowId";
		$holdingNFTRowId = "holdingNFTRowId";
		$waitingNFTRowId = "waitingNFTRowId";

		$theStr = self::errorRow();

		$theStr .= "<div id='".$holdingRowId."' >";
		$theStr .= "<center>Active account NFTs</center>";
		$theStr .= "<div id='".$holdingNFTRowId."' style='margin-top:5px'></div>";

		$theStr .= "<center>Inactive accounts NFTs</center>";
		$theStr .= "<div id='".$waitingNFTRowId."' style='margin-top:5px'></div>";

		$theStr .= "<center><hr style='color:lightgray;width:75%'></center>";
		$theStr .= "<div style='clear: both'></div>";
		$theStr .= "</div>";
		return $theStr;
	}

	public function thePage($_arrParams)
	{
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		echo "<!DOCTYPE html>";

		$theTitle = "AmorStyle DApp";
		$theDesc = "Distributed Sales Network with Custom NFTs.";

		echo $dsncommon->headerInfo($theTitle,$theDesc);

		// load project common functionality
		$theCommonJSFile = $this->gData['root'].'dsncommon.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theCommonJSFile."' defer></script>";

		// When we add script for the client machine to fetch, it has to be built off
		// the URL (theRootUR). 

		$theWaJSFile = $this->gData['root'].'wallet/wacore.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theWaJSFile."' defer></script>";

		//
		// Start of the body here...
		//
		echo "<body>";
		echo $dsncommon->theCSS();
		echo '<div class="blackout" id="blackoutId" >';
		echo self::globalHTML();

		// Here is were the page gets built. 
		echo $dsncommon->connectRow(null);
		echo $dsncommon->errorRow();

		echo self::theWallet();

		echo $dsncommon->theFooter();
		echo "</div>";
		echo "</body>";
		echo "</html>";
	}
}


