<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_video {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		// If the page provides limit, we'll set that here.
		if(isset($_arrParams['video_id']) )
		{
			$this->gData['video_id'] = $_arrParams['video_id'];
		} 
		if(isset($_arrParams['video_yt']) )
		{
			$this->gData['video_yt'] = $_arrParams['video_yt'];
		} 

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		// if the user provides an account on the URL, we name the page
		// 'The NFT Browser'. If there is no account, we're going to look
		// all all the metamask addresses. 'NFT Browsing Metamask Accounts'
		$pageTitle = 'Browsing Tokengated Videos';
		//if( isset($this->gData['account']) ) {
		//	$pageTitle = 'The NFT Browser';
		//}
		$this->gData['theTitle']=$pageTitle;

		return $this->gData;
/*
		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		$theStr.= $_dsncommon->globalHTML();

		// local page info 
		$theStr.= "<div id='theWalletId'>".$pageTitle."</div>";

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
*/
	}

	public function globalHTML() {

		$rowId = "globalVars";

		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		foreach($this->gData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
	}

	private function errorRow() {
		$theStr ='';

		$theStr .= "<div id='noVideoId' class='fdback' hidden>";
		$theStr .= "<div class='msg'>This Selene Network compatible contract does not report to have any video ids that unlock a tokengated video.</div>";
		$theStr .= "</div>";

		return $theStr;
	}

	// Will have two different settings for videos: one for mobile and one for PC. 
	// In both cases, there will be the allow full screen functionality. Also Note
	// that if the test environment is http, the video player will not connect, thus
	// sub an image. Expected default resolution is 16x9. 
	private function theVideo($_index) 
	{
		$videoRowId = "videoRowId"; //.$_index;

		//$theSrc = $this->gData['siteURL']."nfts/maxtpwv1/images/canoe.jpg";
		//$theStr .= '<img class="full" src="'.$theSrc.'"  >'; // class="full" width="1920"height="1080" 

		// for mobile, we need to set the initial width to something like 400.
		$width = '960';
		$height = '540';
		if( $this->gData['mobile'] != 0 ) {
			// we are on a mobile device.
			$width = 400;
			$height = (($width * 9 )/16);
		} 

		$theStr = '';

		$theStr = self::errorRow();
/*
		$theStr .= '<div id="'.$videoRowId.'" class="vcontainer" align="center" style="width: '.$width.'px;height: '.$height.'px" hidden>';
		$theStr .= '<iframe id="iframeId" width="'.$width.'px" height="'.$height.'px" scrolling="no" border="0" allow="fullscreen"></iframe>'; // width="560" height="315" 
		$theStr .= "</div>";
*/
/*
		// setup youtube player...
		$theURL = 'https://www.youtube.com/watch?v=fMGeOITy8e8';
		//<iframe id="ytplayer" type="text/html" width="640" height="390" src="http://www.youtube.com/embed/u1zgFlCw8Aw?autoplay=1&origin=http://example.com" frameborder="0"/>
		$theStr .= '<div id="'.$videoRowId.'" class="vcontainer" align="center" style="width: '.$width.'px;height: '.$height.'px" >';
		$theStr .= '<iframe id="ytplayer" type="text/html" width="'.$width.'px" height="'.$height.'px" src="'.$theURL.'&origin=https://amorstyle.com" frameborder="0"/>'; //?autoplay=1&origin=http://example.com
		$theStr .= "</div>";
*/
		$theStr .= '<div id="'.$videoRowId.'" class="vcontainer" align="center" style="width: '.$width.'px;height: '.$height.'px" hidden>';
		//$theStr .= '<div id="theIframeId" hidden>';
		//$theStr .= '<iframe id="iframeId" width="'.$width.'px" height="'.$height.'px" scrolling="no" border="0" allow="fullscreen"></iframe>'; // width="560" height="315" 
		//$theStr .= '</div>';
		//$theStr .= '<iframe id="iframeId" width="'.$width.'px" height="'.$height.'px" scrolling="no" border="0" allow="fullscreen"></iframe>'; // width="560" height="315" 
		$theStr .= '<div id="ytplayer" hidden></div>';
		$theStr .= "</div>";

		$theStr .= "<div style='clear: both'></div>";
		return $theStr;
	}

	public function thePage($_arrParams)
	{
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		echo "<!DOCTYPE html>";

		$theTitle = "AmorStyle DApp";
		$theDesc = "Distributed Sales Network with Custom NFTs.";

		echo $dsncommon->headerInfo($theTitle,$theDesc);

		// load project common functionality
		$theCommonJSFile = $this->gData['root'].'dsncommon.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theCommonJSFile."' defer></script>";

		// When we add script for the client machine to fetch, it has to be built off
		// the URL (theRootUR). 

		$theVJSFile = $this->gData['root'].'video/vcore.js';
		//var_dump($theVJSFile);
		echo "<script type='text/javascript' src='".$theVJSFile."' defer></script>";

		//
		// Start of the body here...
		//
		echo "<body>";
		echo $dsncommon->theCSS();
		echo '<div class="blackout" id="blackoutId" >';
		echo self::globalHTML();

		// Here is were the page gets built. 
		echo $dsncommon->connectRow(null);
		echo $dsncommon->errorRow();
/*
		// when setting up the page, this code builds the framework For
		// up to icount number of videos. The JS code enables the code.
		$icount = 5;
		for($i=0;$i<$icount;$i++) {
			//echo "Item<br>";
			echo self::theVideo($i);
		}
*/
		echo self::theVideo(intval(0));

		echo $dsncommon->theFooter();
		echo "</div>";
		echo "</body>";
		echo "</html>";
	}
}


