<?php

if( !isset($globalsSet)) {
// Enforcing strict complience with file inclusion
exit('User should not call this file directly.');
}
// This file should not be called directly. Call index.php!
if( !isset($globalMobile)) {
exit('need layout set.');
}

class Theta_tools {

	private $gData; // data array of all global variables

	function __construct() {
	}

	public function Init($_cCustomNFT) {
		$this->cCustomNFT = $_cCustomNFT;
	}


	// This function builds a hidden section that contains global variables.
	//
	// When a project is developed, it should point out the sepcific pennyOracle and gallery contracts
	// that should be used. 
	//
	private function globalVars($_dsncommon,$_arrParams) {

		$rowId = "globalVars";

		$this->gData = $_dsncommon->globalVars($_arrParams);

		// capture the URL variables
		if(isset($_arrParams['file']) )
		{
			$this->gData['file'] = $_arrParams['file'];
		} 
		if(isset($_arrParams['type']) )
		{
			$this->gData['type'] = $_arrParams['type'];
		} 

		// For debugging
		if( $this->gData['debug'] == 2 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
		}

		// if the user provides an account on the URL, we name the page
		// 'The NFT Browser'. If there is no account, we're going to look
		// all all the metamask addresses. 'NFT Browsing Metamask Accounts'
		$pageTitle = 'Selene Network Tools';
		//if( isset($this->gData['account']) ) {
		//	$pageTitle = 'The NFT Browser';
		//}
		$this->gData['theTitle']=$pageTitle;

		return $this->gData;
/*
		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		$theStr.= $_dsncommon->globalHTML();

		// local page info 
		$theStr.= "<div id='theWalletId'>".$pageTitle."</div>";

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
*/
	}

	public function globalHTML() {

		$rowId = "globalVars";

		$theStr = '';
		$theStr.= "<div id=".$rowId.">";
		$theStr.= "<div class='row' id='globalVarsCoreId' hidden>";

		foreach($this->gData as $key => $item) {
			$theStr .= '<div id="'.$key.'Id">'.$item.'</div>';
		}

		$theStr.= "</div>";
		$theStr.= "</div>";
		return $theStr;
	}

	//
	// hash the file and carve up the elements for the visitor.
	//
	private function processPU($_bShow) {

		$this->gData['data'] = file_get_contents($this->gData['file']);
		$this->gData['dataObj'] = json_decode($this->gData['data'],true);
		//echo $theData;
		$param3 = hash('sha1',$this->gData['data'],false);

		$basename = basename($this->gData['file']);
		$_URL = $this->gData['file'];
		$param1 = str_replace($basename,"",$_URL,);

		$param2 = pathinfo($this->gData['file'],PATHINFO_FILENAME);

		$theStr = '';
		if( $_bShow ) {
			// going to build 1 section for the page and center the three elements.
			$theStr .= '<div>';
			$theStr .= 'Smart Contract projectUpdate() initialization data:';
			$theStr .= '</div>';
			$theStr .= '<div style="text-align: center">';
			$theStr .= $param1.', '.$param2.', '.$param3;
			$theStr .= '</div>';
		}
		return $theStr;
	}

	//
	// $_nameStr is required (if $_bMustHave is true), optional otherwise.
	// Details: 
	//   The $_nameStr used as text and has an expected length.
	//   All the projects will warn of the $_nameStr is over $_warnLen characters.
	//   Fail over $_errLen characters.
	//
	// self:: checkStr($this->gData['dataObj'],'name',96,256)
	private function checkStr($_bMustHave,$_jsonObj, $_nameStr, $_warnLen, $_errLen) {
		$bRet = true;
		$theStr = '<div>';

		if( isset($_jsonObj[$_nameStr]) ) {
			$clen = strlen($_jsonObj[$_nameStr]);
			if( $clen > 0 && $clen < $_warnLen ) {
				$theStr .= $_nameStr.' : "'.$_jsonObj[$_nameStr].'"';
			} else if ( $clen >= $_warnLen && $clen < $_errLen ) {
				$theStr .= 'Warning: to long: '.$_nameStr.' : "'.$_jsonObj[$_nameStr].'"';
			} else if ( $clen >= $_errLen  ) {
				$theStr .= 'Error: to long: '.$_nameStr.' : "'.$_jsonObj[$_nameStr].'"';
				$bRet = false;
			} else {
				$theStr .= 'Error: no length: '.$_nameStr.' : "'.$_jsonObj[$_nameStr].'"';
				$bRet = false;
			}

		} else {
			if( $_bMustHave ) {
				// error string
				$theStr .= 'JSON file must contain "'.$_nameStr.'" StringProperty and be under about '.$_warnLen.' characters';			
			}
		}
		$theStr .= '</div>';
		echo $theStr;

		return $bRet;
	}

	// returns true if the start of the two strings are identical servers.
	// This routine will simply walk both strings comparing them until it hits
	// the first '/' after a '.'. If they match that far, they will be considered
	// the same.
	private function sameServer($_root,$_data) {
/*
		echo 'root: '.$_root.'<br>';
		echo 'data: '.$_data.'<br>';

		echo 'scheme: '.parse_url($_root,PHP_URL_SCHEME).'<br>';
		echo 'host: '.pathinfo($_root,PHP_URL_HOST).'<br>';
		echo 'path: '.pathinfo($_root,PHP_URL_PATH).'<br>';
*/
		$bHitPeriod = false;
		$bHitTrailingSlash = false;
		$iCount = mb_strlen($_root, 'UTF-8');
		for($i=0; $i < $iCount; $i++) {
			$rootchar = mb_substr($_root, $i, 1, 'UTF-8');
			$datachar = mb_substr($_data, $i, 1, 'UTF-8');

			//echo $rootchar.' '.$datachar.'<br>';

			if( $rootchar == '.' ) {
				$bHitPeriod = true;
			}
			if( $bHitPeriod && $rootchar == '/' ) {
				$bHitTrailingSlash = true;
				break;
			}

			if( $rootchar != $datachar) {
				break;
			}
		}
		if( $bHitPeriod && $bHitTrailingSlash) {
			return true;
		}
		return false;
	}

	//
	// external_url: This is expected to be a URL with a trailing slash. It points
	//   to a location where more information can be found about the project. The information
	//   found at that location can be dynamic. It is expected to contain updates and
	//   other current information.
	// Code expects:
	// 1) the location where the updates are displayed should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	// 2) expect trailing slash. (Not checked for now, not critical)
	//
	private function checkExternalUrl() {
		$bRet = false;
		$theStr = '<div>';

		if( isset($this->gData['dataObj']['external_url'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['external_url'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {
					//echo $dataStr.'<br>';
					// Looks like a URL on the same server
					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					$theStr .= 'external_url : "'.$hyperLink.'"';
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file should contain an "external_url" StringProperty that is a URL to a location on the project server that allows for sharing more information about the project.';			
		}
		$theStr .= '</div>';
		echo $theStr;

		return $bRet;
	}
/*
	// 
	private function hashFile($_URL) {
		$data = file_get_contents($_URL);
		$param3 = hash('sha1',$data,false);
		return $param3;	
	}
*/
	//
	// whitepaper: This is expected to be a URL to a PDF file called whitepaper.pdf. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the whitepaper resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkWhitepaperUrl() {
		$bRet = false;
		$theStr = '<div>';

		if( isset($this->gData['dataObj']['whitepaper'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['whitepaper'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					// Now validate that the filename and extension match "whitepaper.pdf"
					$basename = basename($dataStr);
					if( $basename == "whitepaper.pdf") {
						$data = file_get_contents($dataStr);
						$theHash = hash('sha1',$data,false);

						// Looks like a URL on the same server
						$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
						$theStr .= 'whitepaper : "'.$hyperLink.'", '.$theHash;
						$bRet = true;
					}
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file should contain a "whitepaper" StringProperty that is a URL to a location on the project server that shares a whitepaper.pdf file.';			
		}
		$theStr .= '</div>';
		echo $theStr;

		return $bRet;
	}
	//
	// image: This is expected to be a URL to a JPG, PNG or GIF file. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the image resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkImageUrl($_arrItem, $_bHash) {
		$bRet = false;
		$theStr = '<div>';

		if( isset($_arrItem['image'])) {
			// found in file.
			$dataStr = $_arrItem['image'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					if( $_bHash ) {
						// read the data and hash it.
						// Now validate that the filename and extension match "image.jpg, png or gif"
						$data = file_get_contents($dataStr);
						$theHash = hash('sha1',$data,false);

						// Looks like a URL on the same server
						$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
						$theStr .= 'image : "'.$hyperLink.'", '.$theHash;
					} else {
						// Looks like a URL on the same server
						$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
						$theStr .= 'image : "'.$hyperLink.'"';
					}
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			$theStr .= 'JSON file should contain a "image" StringProperty that is a URL to a location on the project server that shares a image JPG, PNG or GIF file.';			
		}
		$theStr .= '</div>';
		echo $theStr;

		return $bRet;
	}

	//
	// whitepaper: This is expected to be a URL to a PDF file called whitepaper.pdf. 
	// This code will fetch the contents of that file and hash it for the caller.
	// Code expects:
	// 1) the location where the whitepaper resides should be the same domain as
	//    the domain that hosts this JSON file. project file & link point to same server.
	//
	private function checkVideo_ReelUrl($_bMustHave) {
		$bRet = false;
		$theStr = '<div>';

		if( isset($this->gData['dataObj']['video_reel'])) {
			// found in file.
			$dataStr = $this->gData['dataObj']['video_reel'];

			// it should look like a URL
			if( filter_var($dataStr,FILTER_VALIDATE_URL) ) {

				// server check - what's inside the file matches the file we're processing
				if( self::sameServer($this->gData['file'],$dataStr) ) {

					// Looks like a URL on the same server
					$hyperLink = '<a href="'.$dataStr.'" target=_self>'.$dataStr.'</a>';
					$theStr .= 'video_reel : "'.$hyperLink.'"';
					$bRet = true;
				}
			}
		}
		if( $bRet == false ) {
			if( $_bMustHave ) {
				$theStr .= 'If there is a "video_reel" StringProperty that is a URL to a location on the project server that shares a reel file.';
			}
		}
		$theStr .= '</div>';
		echo $theStr;

		return $bRet;
	}


	// This routine will evaluate the project file to make sure that it has all the elements
	// that are expected of it.
	private function processAsProject() {
		echo '<div style="text-align: center">Processing Project File</div>';

		// start with "name"
		self::checkStr(true, $this->gData['dataObj'],'name',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);

		// URL items
		self::checkExternalUrl();
		self::checkWhitepaperUrl();
		self::checkImageUrl($this->gData['dataObj'],true);

		// optional items
		self::checkStr(false, $this->gData['dataObj'],'artist',96,256);
		self::checkStr(false, $this->gData['dataObj'],'creator',96,256);
		self::checkStr(false, $this->gData['dataObj'],'collection',96,256);
		self::checkStr(false, $this->gData['dataObj'],'home',96,256);
		self::checkVideo_ReelUrl(false);
	}

	// This routine will evaluate the token metadata file to make sure that it has all the elements
	// that are expected of it.
	private function processAsToken() {
		echo '<div style="text-align: center">Processing Token File</div>';

		// start with "name"
		self::checkStr(true, $this->gData['dataObj'],'name',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);

		// URL items
		self::checkExternalUrl();
		//self::checkWhitepaperUrl();
		self::checkImageUrl($this->gData['dataObj'],false);

		// optional items
		self::checkStr(false, $this->gData['dataObj'],'artist',96,256);
		self::checkStr(false, $this->gData['dataObj'],'creator',96,256);
		self::checkStr(false, $this->gData['dataObj'],'collection',96,256);
		self::checkStr(false, $this->gData['dataObj'],'home',96,256);
	}

	// This routine will evaluate the reel metadata file to make sure that it has all the elements
	// that are expected of it.
	// The structure of a reel file is two tear. There is a array of sections and each section
	// describes an array of videos. 
	// Note that reel files are meant to be edited over time. 
	private function processAsReel() {
		echo '<div style="text-align: center">Processing Reel File</div>';

		self::checkStr(true, $this->gData['dataObj'],'title',96,256);
		self::checkStr(true, $this->gData['dataObj'],'description',1024,4096);
		echo '<br>';

		// the reel element is an array, let's get it's count and loop.
		if( isset($this->gData['dataObj']['reel']) ) {
			$arrReel = $this->gData['dataObj']['reel'];
			//echo 'reel count: '.count($arrReel).'<br>';

			for( $i = 0; $i < count($arrReel); $i++ ) {
				//echo $i.' ';
				self::checkStr(true, $arrReel[$i],'section',96,256);
				self::checkStr(true, $arrReel[$i],'description',1024,4096);
			
				if( isset($arrReel[$i]['videos']) ) {
					// now walk each entry and validate that it has what we expect.
					$arrVideos = $arrReel[$i]['videos'];
					for($v = 0; $v < count($arrVideos); $v++ ) {
						//echo $v.' ';
						self::checkStr(true, $arrVideos[$v],'name',96,256);
						self::checkImageUrl($arrVideos[$v],false);
						self::checkStr(true, $arrVideos[$v],'description',96,256);

						// Now, we check for the video link. it can be either 
						// youtube or video_id. If we have one, we'll build a hyperlink
						// to that resource.
						if( isset($arrVideos[$v]['youtube']) ) {
							// https://www.youtube.com/watch?v=XDRNlxaViKg
							$url = 'https://www.youtube.com/watch?v='.$arrVideos[$v]['youtube'];
							$hyperLink = '<a href="'.$url.'" target=_self>'.$url.'</a>';
							echo 'youtube : "'.$hyperLink.'"<br>';
						
						} else if( isset($arrVideos[$v]['video_id']) ) {
							// https://amorstyle.com/dsn/video/?id=video_638a3bpi64btq4f90hpneej28t
							$url = 'https://amorstyle.com/dsn/video/?id='.$arrVideos[$v]['video_id'];
							$hyperLink = '<a href="'.$url.'" target=_self>'.$url.'</a>';
							echo 'video_id : "'.$hyperLink.'"<br>';

						} else {
							// error.
						}
						echo '<br>';
					}

				} 
				//echo '<br>';
			}
		
		} else {
			echo 'reel Array Property missing from reel file.<br>';
		}
	}

	private function processAsGallery() {
		echo '<div style="text-align: center">Processing Gallery File</div>';

		self::checkStr(true, $this->gData['dataObj'],'title',96,256);

		if( isset($this->gData['dataObj']['projects']) ) {
			$arrGallery = $this->gData['dataObj']['projects'];

			for( $i = 0; $i < count($arrGallery); $i++ ) {
				echo $i.' '.$arrGallery[$i].'<br>';
			}
		}
	}


	public function thePage($_arrParams)
	{
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		// get global variables
		self::globalVars($dsncommon,$_arrParams);

		echo "<!DOCTYPE html>";

		$theTitle = "AmorStyle DApp";
		$theDesc = "Distributed Sales Network with Custom NFTs.";

		echo $dsncommon->headerInfo($theTitle,$theDesc);

		// load project common functionality
		$theCommonJSFile = $this->gData['root'].'dsncommon.js';
		//var_dump($theWaJSFile);
		echo "<script type='text/javascript' src='".$theCommonJSFile."' defer></script>";

		// When we add script for the client machine to fetch, it has to be built off
		// the URL (theRootUR). 

		$theVJSFile = $this->gData['root'].'tools/tools.js';
		//var_dump($theVJSFile);
		echo "<script type='text/javascript' src='".$theVJSFile."' defer></script>";

		//
		// Start of the body here...
		//
		echo "<body>";
		echo $dsncommon->theCSS();
		echo '<div class="blackout" id="blackoutId" >';
		echo self::globalHTML();

		// Here is were the page gets built. 
		echo $dsncommon->connectRow(null);
		echo $dsncommon->errorRow();

		// Every JSON file used in this project will get hashed so that the projectUpdate() 
		// variables can be displayed.

		// here is where each of the different types of JSON files are parsed out.
		//echo $this->gData['siteURL']."<br>";
		//var_dump($this->gData);
		//echo "<br>";

		if( $this->gData['type'] == 'project') {
			echo self::processPU(true);
			echo self::processAsProject();
		} else if( $this->gData['type'] == 'token') {
			echo self::processPU(false);
			echo self::processAsToken();
		} else if( $this->gData['type'] == 'reel') {
			echo self::processPU(false);
			echo self::processAsReel();
		} else if( $this->gData['type'] == 'gallery') {
			echo self::processPU(true);
			echo self::processAsGallery();
 		}else {
			echo "Invalid type specified.<br>";
		}

		echo "<br>";

		echo $dsncommon->theFooter();
		echo "</div>";
		echo "</body>";
		echo "</html>";
	}
}


