let arrGlobals = [];

// Supported interfaces
//
// This structure is used to hold the information needed to talk to the 
// smart contract.
//
arrGlobals['I'] = [];
// standard functionality
arrGlobals['I']['IERC165'] = [];
arrGlobals['I']['IERC165']['id'] = "0x01ffc9a7";
arrGlobals['I']['IERC721'] = [];
arrGlobals['I']['IERC721']['id'] = "0x80ac58cd";
arrGlobals['I']['IERC721Metadata'] = [];
arrGlobals['I']['IERC721Metadata']['id'] = "0x5b5e139f";
// owner and titled haven't made it to interfaces yet.
// Every contract is expected to export the ISelNetV1 interface which exports the 
// owner and titled functions. 
arrGlobals['I']['ISelNetV1'] = [];
arrGlobals['I']['ISelNetV1']['id'] = "0x01464b5a";
// Every contract is also expected to export the IPennyOracleV1 functions. This
// is what helps determine the contract prices.
arrGlobals['I']['IPennyOracleV1'] = [];
arrGlobals['I']['IPennyOracleV1']['id'] = "0x3c25e541";

arrGlobals['I']['IMetadataV1'] = [];
arrGlobals['I']['IMetadataV1']['id'] = "0x2839ac8d";
arrGlobals['I']['ICountV1'] = [];
arrGlobals['I']['ICountV1']['id'] = "0x18160ddd";
arrGlobals['I']['IPayV1'] = [];
arrGlobals['I']['IPayV1']['id'] = "0x0c6b9d1c";
arrGlobals['I']['IMintV1'] = [];
arrGlobals['I']['IMintV1']['id'] = "0x48165a5b";
arrGlobals['I']['IBurnV1'] = [];
arrGlobals['I']['IBurnV1']['id'] = "0x42966c68";
arrGlobals['I']['IMemV1'] = [];
arrGlobals['I']['IMemV1']['id'] = "0x4748f28f";
arrGlobals['I']['IPayV2'] = [];
arrGlobals['I']['IPayV2']['id'] = "0x17d67609";
arrGlobals['I']['IERC721ExV1'] = [];
arrGlobals['I']['IERC721ExV1']['id'] = "0x0416a63b";
arrGlobals['I']['IERC721ExV1M'] = [];
arrGlobals['I']['IERC721ExV1M']['id'] = "0xb9fcec28";
// These are the legacy participant and website contracts
arrGlobals['I']['ICore'] = [];
arrGlobals['I']['ICore']['id'] = "0";
arrGlobals['I']['IPartV1'] = [];
arrGlobals['I']['IPartV1']['id'] = "0";
arrGlobals['I']['IWebV1'] = [];
arrGlobals['I']['IWebV1']['id'] = "0";
arrGlobals['I']['IAgentV1'] = [];
arrGlobals['I']['IAgentV1']['id'] = "0";
/*
interface IERC165 {
    function supportsInterface(bytes4 interfaceId) external view returns (bool);
}
*/
arrGlobals['I']['IERC165']['ABI'] = [];
arrGlobals['I']['IERC165']['supported'] = true;
arrGlobals['I']['IERC165']['ABI'].push({ "inputs": [{ "internalType": "bytes4", "name": "interfaceId", "type": "bytes4" }], "name": "supportsInterface", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "view", "type": "function" });
/*
interface IERC721 is IERC165 {
    //event Transfer(address indexed from, address indexed to, uint256 indexed tokenId);
    //event Approval(address indexed owner, address indexed approved, uint256 indexed tokenId);
    //event ApprovalForAll(address indexed owner, address indexed operator, bool approved);
    function balanceOf(address owner) external view returns (uint256 balance);
    function ownerOf(uint256 tokenId) external view returns (address owner);
    function safeTransferFrom(address from, address to, uint256 tokenId, bytes calldata data) external;
    function safeTransferFrom(address from, address to, uint256 tokenId) external;
    function transferFrom(address from, address to, uint256 tokenId) external;
    function approve(address to, uint256 tokenId) external;
    function setApprovalForAll(address operator, bool approved) external;
    function getApproved(uint256 tokenId) external view returns (address operator);
    function isApprovedForAll(address owner, address operator) external view returns (bool);
}
*/
arrGlobals['I']['IERC721']['ABI'] = [];
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "owner", "type": "address" }], "name": "balanceOf", "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "ownerOf", "outputs": [{ "internalType": "address", "name": "", "type": "address" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "from", "type": "address" }, { "internalType": "address", "name": "to", "type": "address" }, { "internalType": "uint256", "name": "tokenId", "type": "uint256" }, { "internalType": "bytes", "name": "data", "type": "bytes" }], "name": "safeTransferFrom", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "from", "type": "address" }, { "internalType": "address", "name": "to", "type": "address" }, { "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "safeTransferFrom", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "from", "type": "address" }, { "internalType": "address", "name": "to", "type": "address" }, { "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "safeTransferFrom", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "approver", "type": "address" }], "name": "ERC721InvalidApprover", "type": "error" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "operator", "type": "address" }, { "internalType": "bool", "name": "approved", "type": "bool" }], "name": "setApprovalForAll", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "getApproved", "outputs": [{ "internalType": "address", "name": "", "type": "address" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "owner", "type": "address" }, { "internalType": "address", "name": "operator", "type": "address" }], "name": "isApprovedForAll", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "view", "type": "function" });
/*
interface IERC721Metadata is IERC721 {
    function name() external view returns (string memory);
    function symbol() external view returns (string memory);
    function tokenURI(uint256 tokenId) external view returns (string memory);
}
*/
arrGlobals['I']['IERC721Metadata']['ABI'] = [];
arrGlobals['I']['IERC721Metadata']['ABI'].push({ "inputs": [], "name": "name", "outputs": [{ "internalType": "string", "name": "", "type": "string" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721Metadata']['ABI'].push({ "inputs": [], "name": "symbol", "outputs": [{ "internalType": "string", "name": "", "type": "string" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721Metadata']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "tokenURI", "outputs": [{ "internalType": "string", "name": "", "type": "string" }], "stateMutability": "view", "type": "function" });
/*
These two functions are required to be implimented in the Selene Network
smart contracts. 
*/
arrGlobals['I']['ISelNetV1']['ABI'] = [];
arrGlobals['I']['ISelNetV1']['supported'] = true;
arrGlobals['I']['ISelNetV1']['ABI'].push({ "inputs": [], "name": "owner", "outputs": [{ "internalType": "address", "name": "", "type": "address" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['ISelNetV1']['ABI'].push({ "inputs": [], "name": "titled", "outputs": [{ "internalType": "address", "name": "", "type": "address" }], "stateMutability": "view", "type": "function" });
/*
interface IMetadataV1 {
    //function projectUpdate(string calldata _URI, string calldata _Project, string calldata _hash) external;
    function projectIndex() external returns(uint uiIndex);
    function projectData(uint _uiIndex) external returns(string memory URI, string memory Project, string memory hash);
    function projectDataCurrent() external returns(string memory URI, string memory Project, string memory hash);
    function projectBaseURI() external returns(string memory URI);
}
*/
arrGlobals['I']['IMetadataV1']['ABI'] = [];
arrGlobals['I']['IMetadataV1']['ABI'].push({ "inputs": [{ "internalType": "string", "name": "_URI", "type": "string" }, { "internalType": "string", "name": "_Project", "type": "string" }, { "internalType": "string", "name": "_hash", "type": "string" }], "name": "projectUpdate", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IMetadataV1']['ABI'].push({ "inputs": [], "name": "projectIndex", "outputs": [{ "internalType": "uint256", "name": "uiIndex", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMetadataV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_uiIndex", "type": "uint256" }], "name": "projectData", "outputs": [{ "internalType": "string", "name": "URI", "type": "string" }, { "internalType": "string", "name": "Project", "type": "string" }, { "internalType": "string", "name": "hash", "type": "string" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMetadataV1']['ABI'].push({ "inputs": [], "name": "projectDataCurrent", "outputs": [{ "internalType": "string", "name": "URI", "type": "string" }, { "internalType": "string", "name": "Project", "type": "string" }, { "internalType": "string", "name": "hash", "type": "string" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMetadataV1']['ABI'].push({ "inputs": [], "name": "projectBaseURI", "outputs": [{ "internalType": "string", "name": "URI", "type": "string" }], "stateMutability": "view", "type": "function" });
/*
interface ICountV1 {
    function totalSupply() external view returns(uint256 theTotalSupply);
}
*/
arrGlobals['I']['ICountV1']['ABI'] = [];
arrGlobals['I']['ICountV1']['ABI'].push({ "inputs": [], "name": "totalSupply", "outputs": [{ "internalType": "uint256", "name": "theTotalSupply", "type": "uint256" }], "stateMutability": "view", "type": "function" });
/*
interface IPennyOracleV1 {
function pennyOracleStatus() external returns (bool bActive, address theContract, uint256 lastBlock);
function pennyPriceTfuel() external view returns (uint256 pennyPrice, string memory pennyWei);
}
*/
arrGlobals['I']['IPennyOracleV1']['ABI'] = [];
arrGlobals['I']['IPennyOracleV1']['ABI'].push({ "inputs": [], "name": "pennyOracleStatus", "outputs": [{ "internalType": "bool", "name": "bActive", "type": "bool" }, { "internalType": "address", "name": "theContract", "type": "address" }, { "internalType": "uint256", "name": "lastBlock", "type": "uint256" }], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IPennyOracleV1']['ABI'].push({ "inputs": [], "name": "pennyPriceTfuel", "outputs": [{ "internalType": "uint256", "name": "pennyTfuelWei", "type": "uint256" }, { "internalType": "string", "name": "priceOfTfuel", "type": "string" }], "stateMutability": "view", "type": "function" });
/*
interface IPayV1 {
function payMintInfo() external view returns (uint256 payAgent, uint256 payWebsite, uint256 delayBlocks, uint256 minMints);
function payMint(uint256 _AgentId, uint256 _websiteId) external payable returns(uint256 tokenId);
function payWithdraw() external returns(bool);
function payWithdrawTitled() external returns(bool);
*function paySweep(address _anAccount) external returns(bool);
*function payTreasuryBalance() external view returns(uint256 BalanceWei);
function payAgentBalance(address _account) external view returns(uint256 payBalanceWei, uint256 payDeadline, uint256 payCount);
function payMintPrice() external view returns(uint256 mintTfuelWei);
*function payActive() external view returns (bool);
}
*/
arrGlobals['I']['IPayV1']['ABI'] = [];
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payMintInfo", "outputs": [{ "internalType": "uint256", "name": "payAgentPennies", "type": "uint256" }, { "internalType": "uint256", "name": "payWebsitePennies", "type": "uint256" }, { "internalType": "uint256", "name": "inactivityDeadline", "type": "uint256" }, { "internalType": "uint256", "name": "minMintCount", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_AgentId", "type": "uint256" }, { "internalType": "uint256", "name": "_websiteId", "type": "uint256" }], "name": "payMint", "outputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payWithdraw", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payWithdrawTitled", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_anAccount", "type": "address" }], "name": "paySweep", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payTreasuryBalance", "outputs": [{ "internalType": "uint256", "name": "BalanceWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_account", "type": "address" }], "name": "payAgentBalance", "outputs": [{ "internalType": "uint256", "name": "payBalanceWei", "type": "uint256" }, { "internalType": "uint256", "name": "payDeadline", "type": "uint256" }, { "internalType": "uint256", "name": "payCount", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payMintPrice", "outputs": [{ "internalType": "uint256", "name": "mintWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV1']['ABI'].push({ "inputs": [], "name": "payActive", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "view", "type": "function" });
/*
interface IMintV1 {
    function mintable() external view returns(bool bMintable);
    function ownerLockToggle() external;
}
*/
arrGlobals['I']['IMintV1']['ABI'] = [];
arrGlobals['I']['IMintV1']['ABI'].push({ "inputs": [], "name": "mintable", "outputs": [{ "internalType": "bool", "name": "bMintable", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMintV1']['ABI'].push({ "inputs": [], "name": "ownerLockToggle", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
/*
example of this is webwallet reel product.
interface IBurnV1 {
    function burn(uint256 _tokenId) external;
}
*/
arrGlobals['I']['IBurnV1']['ABI'] = [];
arrGlobals['I']['IBurnV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "burn", "outputs": [], "stateMutability": "nonpayable", "type": "function" });


/*
interface IMemV1 {
    function memInfo() external view returns (uint256 renewPennies, uint256 penniesPerDay, uint256 mintHours, uint256 renewHours);
    function memIsTimeLeft(uint256 _tokenId) external view returns(bool bActive, uint256 remainingPrePaidHours, uint256 remainingIntrinsicHours);
    function memBalance(uint256 _tokenId) external view returns(uint256 BalanaceWei, uint256 UnsettledWei);
    function memWithdraw(uint256 _tokenId) external returns(bool);
    function memSettleTitled(uint256 _tokenId) external;
    function memGrantHours(uint256 _tokenId, uint256 _addHours) external;
    function memRenew(uint256 _tokenId) external payable;
    function memLockStatus(uint256 _tokenId) external view returns(bool bLockedState);
    function memLockToggle(uint256 _tokenId, bool _bState) external;
    function memTreasuryBalance() external view returns(uint256 BalanceWei);
}
*/
arrGlobals['I']['IMemV1']['ABI'] = [];
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [], "name": "memInfo", "outputs": [{ "internalType": "uint256", "name": "renewPennies", "type": "uint256" }, { "internalType": "uint256", "name": "penniesPerDay", "type": "uint256" }, { "internalType": "uint256", "name": "mintHours", "type": "uint256" }, { "internalType": "uint256", "name": "renewHours", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memIsTimeLeft", "outputs": [{ "internalType": "bool", "name": "bActive", "type": "bool" }, { "internalType": "uint256", "name": "remainingPrePaidHours", "type": "uint256" }, { "internalType": "uint256", "name": "remainingIntrinsicHours", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memBalance", "outputs": [{ "internalType": "uint256", "name": "BalanaceWei", "type": "uint256" }, { "internalType": "uint256", "name": "UnsettledWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memWithdraw", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memSettleTitled", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }, { "internalType": "uint256", "name": "_addHours", "type": "uint256" }], "name": "memGrantHours", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memRenew", "outputs": [], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "memLockStatus", "outputs": [{ "internalType": "bool", "name": "bLockedState", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }, { "internalType": "bool", "name": "_bState", "type": "bool" }], "name": "memLockToggle", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IMemV1']['ABI'].push({ "inputs": [], "name": "memTreasuryBalance", "outputs": [{ "internalType": "uint256", "name": "BalanceWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });

/*
interface IPayV2 {
    function payBurn(uint256 _tokenId) external payable ;
    function payPrice(uint8 _index) external view returns(uint256 tfuelWei);
    function penniesSet(uint8 _index, uint256 _mintPennies) external;
    function penniesRead(uint8 _index) external view returns(uint256 pennies);
}
*/
arrGlobals['I']['IPayV2']['ABI'] = [];
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [], "name": "BURN_INDEX", "outputs": [{ "internalType": "uint8", "name": "", "type": "uint8" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [], "name": "MINT_INDEX", "outputs": [{ "internalType": "uint8", "name": "", "type": "uint8" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [], "name": "RENEW_INDEX", "outputs": [{ "internalType": "uint8", "name": "", "type": "uint8" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [], "name": "SENDLOCK_INDEX", "outputs": [{ "internalType": "uint8", "name": "", "type": "uint8" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "payBurn", "outputs": [], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }], "name": "payPrice", "outputs": [{ "internalType": "uint256", "name": "tfuelWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }, { "internalType": "uint256", "name": "_mintPennies", "type": "uint256" }], "name": "penniesSet", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IPayV2']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }], "name": "penniesRead", "outputs": [{ "internalType": "uint256", "name": "mint", "type": "uint256" }], "stateMutability": "view", "type": "function" });

/*
sc_sampv2 has all these...
interface IERC721ExV1 {
    function IsSendLock() external returns (bool bSendLock);
    function paySendLockPrice() external view returns(uint256 sendLockWei);
    function sendLockRegister(address to, uint256 tokenId) external payable;
    function IsSoulBound() external returns (bool bSoulBound);
    function payBurnPrice() external view returns(uint256 burnWei);
    function payBurn(uint256 _tokenId) external payable ;
}
*/
arrGlobals['I']['IERC721ExV1']['ABI'] = [];
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [], "name": "IsSendLock", "outputs": [{ "internalType": "bool", "name": "bSendLock", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [], "name": "paySendLockPrice", "outputs": [{ "internalType": "uint256", "name": "sendLockWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "to", "type": "address" }, { "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "sendLockRegister", "outputs": [], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [], "name": "IsSoulBound", "outputs": [{ "internalType": "bool", "name": "bSoulBound", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [], "name": "payBurnPrice", "outputs": [{ "internalType": "uint256", "name": "burnWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721ExV1']['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_tokenId", "type": "uint256" }], "name": "payBurn", "outputs": [], "stateMutability": "payable", "type": "function" });

/*
interface IERC721ExV1M {
    function tokenOf(address _theOwner) external view returns (uint256 tokenId);
    function IsSoulBound() external returns (bool bSoulBound);
}
*/
arrGlobals['I']['IERC721ExV1M']['ABI'] = [];
arrGlobals['I']['IERC721ExV1M']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_ownerAddr", "type": "address" }], "name": "tokenOf", "outputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IERC721ExV1M']['ABI'].push({ "inputs": [], "name": "IsSoulBound", "outputs": [{ "internalType": "bool", "name": "bSoulBound", "type": "bool" }], "stateMutability": "view", "type": "function" });

// The Participant and Website contracts support ICore
arrGlobals['I']['ICore']['ABI'] = [];
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [], "name": "IsSoulBound", "outputs": [{ "internalType": "bool", "name": "bSoulBound", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }], "name": "penniesRead", "outputs": [{ "internalType": "uint256", "name": "mint", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }, { "internalType": "uint256", "name": "_mintPennies", "type": "uint256" }], "name": "penniesSet", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [], "name": "soulboundBurn", "outputs": [], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [], "name": "soulboundMint", "outputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_to", "type": "address" }], "name": "soulboundMintTo", "outputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "stateMutability": "payable", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_theOwner", "type": "address" }], "name": "theTokenId", "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['ICore']['ABI'].push({ "inputs": [], "name": "withdrawAll", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "nonpayable", "type": "function" });

// participant
arrGlobals['I']['IPartV1']['ABI'] = [];
arrGlobals['I']['IPartV1']['ABI'].push({ "inputs": [], "name": "pricesRead", "outputs": [{ "internalType": "uint256", "name": "mintToWei", "type": "uint256" }, { "internalType": "uint256", "name": "mintWei", "type": "uint256" }, { "internalType": "uint256", "name": "burnWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });

// website
arrGlobals['I']['IWebV1']['ABI'] = [];
arrGlobals['I']['IWebV1']['ABI'].push({ "inputs": [], "name": "pricesRead", "outputs": [{ "internalType": "uint256", "name": "mintWei", "type": "uint256" }, { "internalType": "uint256", "name": "burnWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });

// agent
arrGlobals['I']['IAgentV1']['ABI'] = [];
arrGlobals['I']['IAgentV1']['ABI'].push({ "inputs": [], "name": "IsSoulBound", "outputs": [{ "internalType": "bool", "name": "bSoulBound", "type": "bool" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IAgentV1']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }], "name": "penniesRead", "outputs": [{ "internalType": "uint256", "name": "mint", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IAgentV1']['ABI'].push({ "inputs": [{ "internalType": "uint8", "name": "_index", "type": "uint8" }, { "internalType": "uint256", "name": "_mintPennies", "type": "uint256" }], "name": "penniesSet", "outputs": [], "stateMutability": "nonpayable", "type": "function" });
arrGlobals['I']['IAgentV1']['ABI'].push({ "inputs": [], "name": "pricesRead", "outputs": [{ "internalType": "uint256", "name": "mintWei", "type": "uint256" }, { "internalType": "uint256", "name": "registrationWei", "type": "uint256" }, { "internalType": "uint256", "name": "sendlockWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrGlobals['I']['IAgentV1']['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_theOwner", "type": "address" }], "name": "theTokenId", "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }], "stateMutability": "view", "type": "function" });


