/*
Contains common functionality.
*/

function noConnection() {
    console.log("Need to connect MetaMask");

    let msgObj = document.getElementById('noConnectionId');
    if (null != msgObj) {
        msgObj.style.display = 'block';
    }
}

function wrongNetwork() {
    console.log("Need to switch networks");

    // Change the main button to read switch and set a new onclick handler
    let mainObj = document.getElementById('mainButtonId');
    if (null != mainObj) {
        let mainText = 'Switch';
        let mainHTML = '<span id="connectId" style="line-height:40px">' + mainText + '</span>';
        mainObj.innerHTML = "<div class='walletm' id='walletAddress' onClick='switchNetwork()' style='cursor:pointer'>" + mainHTML + "</div>";
    }

    let msgObj = document.getElementById('wrongNetworkId');
    if (null != msgObj) {
        msgObj.style.display = 'block';
    }
}

function noMetamask() {
    console.log('no Metamask');
    // Change the main button to read MetaMask and set a new onclick handler
    let mainObj = document.getElementById('mainButtonId');
    if (null != mainObj) {
        let mainText = 'MetaMask';
        let mainHTML = '<span id="connectId" style="line-height:40px">' + mainText + '</span>';
        mainObj.innerHTML = "<div class='walletm' id='walletAddress' onClick='installMetaMask()' style='cursor:pointer'>" + mainHTML + "</div>";
    }

    // After that, display the 'noMetamask' section.
    let msgObj = document.getElementById('noMetamaskId');
    if (null != msgObj) {
        msgObj.style.display = 'block';
    }
}

async function installMetaMask() {
    window.location.href = 'https://metamask.io/download/';
}

var ThetaNetworkId = '0x169'; // 361

async function switchNetwork() {
    console.log("request network change");

    var theNetwork = await window.ethereum.request({
        "method": "wallet_switchEthereumChain",
        "params": [{ "chainId": ThetaNetworkId }]
    });
    id = await web3.eth.getChainId();
    if (id != ThetaNetworkId) {
        console.log('user said no to Theta switch');
        return false;
    }
    window.location.reload();
}


async function connect() {
    console.log("In connect handler");

    if (window.ethereum) {
        await window.ethereum.request({ method: 'eth_requestAccounts' });
        window.web3 = new Web3(window.ethereum);
        let accounts = await web3.eth.getAccounts();
        account = accounts[0];
        try {
            balance = Number(BigInt(await web3.eth.getBalance(account)) / BigInt(10000000000000000)) / 100;
            button = '<span style="font-size:1em;"><center><b>';
            accountShort = account.substring(0, 5).concat('...', account.substring(38, 42));
            button = button.concat(accountShort, ' </b><br> <img src=\'https://www.thetascan.io/tfuel_dapp.png\'><span style="font-size:0.90em;"> ', balance, ' </span></center></span>');
            document.getElementById('walletAddress').innerHTML = button
        } catch (error) { }

        window.location.reload();
    }
}


//if (typeof delay == 'undefined') {
const delay = ms => new Promise(res => setTimeout(res, ms));
//}





