<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}
// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}


require_once($theRootDir.'/dsn/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir. '/dsn/dsn.php');

/*
The Custom_nft class is designed to handle functionality that the project provides that is
above and beyond the standard IMetadataHash, ICount and IPay interfaces. 

The base code will use 'theData' to override defaults, load javascript code and callback
in order to build the custom HTML for this page.

*/

class Custom_nft {

	private $gData = array();

	function __construct($_arrParams) {
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		$this->gData = $dsncommon->globalVars($_arrParams);
		//$this->gData['customTitleId']="Custom NFT Project";
	}

	public function theData() {

		// get the project globals

		// This array is designed to show a single project.
		$theData = array(
			'customContract' => "0xF2C3eaE1e4C38D4308e238a36D6f104FBEc4E42e", //Agent NFT
			'javaScriptName' => $GLOBALS['theRootURL'].'/nfts/agentv1/agentv1.js', // fully qualified url
			'customCode' => true,
			'isSingleView' => true,
			'customTitle' => 'Agent Smart Contract NFT'
			//'theAgentId' => "1001",
			//'theWebsiteId' => "1"
			);

		return $theData;
	}



	private function dashedSeperator() {
		return '<center><hr style="color:lightgray;width:60%;border-style: dashed"></center>';
	}
	private function clearAll() {
		return '<div style="clear: both"></div>';
	}
	private function sectionTitle($_secId, $_theTitle ) {
		return '<div class="title" id="'.$_secId.'titleId'.'" text-align="center"><center>'.$_theTitle.'</center></div>';
	}

	private function cssCustom() {
		$theStr = '<style>
  input.custom {
    font-size: 0.85em;
    padding: 10px;
    border-radius: 10px;
	/*background-color: #ed00d5;*/
	width: 80%;
  }
		</style>';

		return $theStr;
	}

	private function inputType($_secId,$_inputType,$_inputPlaceHolder) {

		$theStr = '<span >';
		$theStr.= '<input class="custom centerIt" id="'.$_secId.'inputId'.'" type="'.$_inputType.'" placeholder="'.$_inputPlaceHolder.'"></input>';
		$theStr.= '</span>';
		return $theStr;
	}
	private function buttonType($_secId,$_onClick,$_text,$_disabled) {
		if( true == $this->gData['mobile']) 
		{
			if( $_disabled ) {
				$theStr = '<button class="natural centerIt" id="'.$_secId.'buttonId'.'" onClick="'.$_onClick.'"  disabled>'.$_text.'</button>';
			} else {
				$theStr = '<button class="natural centerIt" id="'.$_secId.'buttonId'.'" onClick="'.$_onClick.'" >'.$_text.'</button>';
			}
		}
		else
		{
			if( $_disabled ) {
				$theStr = '<button class="natural" id="'.$_secId.'buttonId'.'" onClick="'.$_onClick.'" disabled>'.$_text.'</button>';
			} else {
				$theStr = '<button class="natural" id="'.$_secId.'buttonId'.'" onClick="'.$_onClick.'">'.$_text.'</button>';
			}
		}
		return $theStr;
	}
	private function resultTrxn($_secId) {
		return '<div id="'.$_secId.'trxnId'.'" hidden></div>';
	}

	private function sectionHead($_secId,$_hidden) {
		$theStr = "";
		if( $_hidden ) {
			$theStr .= '<div id='.$_secId.'RowId'.' hidden >';
		} else {
			$theStr .= '<div id='.$_secId.'RowId'.' >';
		}
		return $theStr;
	}
	private function sectionTail() {
		return '</div>';
	}

	private function tokenSelection()
	{
		$secId = 'selection';
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
			//echo "theData customCode is true: mobile<br>";
				$theStr .= '<div style="background-color:#aafabe;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Token Selection Section');
				$theStr .= '<div class="row">';
				$theStr .= self::inputType($secId,"number","Founder Id");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"resolveFounderId()","Validate to Proceed",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard">Anyone that holds at least one Agent NFT is considered a Founder Agent. The Founder Agent Id is based off the Token Id. Simply multiple your Agent NFT Token Id by one thousand and enter that as your Founder Id.</div>';
				$theStr .= '<div class="standard">When you press "Validate to Proceed" the website will check that you own the given Agent Token Id that is based off the Founder Id and then all the functionality that is enabled will act upon that Token Id.</div>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}
			else
			{
			//echo "theData customCode is true: sandard<br>";
				$theStr .= '<div style="background-color:#aafabe;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Token Selection Section');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= self::inputType($secId,"number","Founder Id");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"resolveFounderId()","Validate to Proceed",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard">Anyone that holds at least one Agent NFT is considered a Founder Agent. The Founder Agent Id is based off the Token Id. Simply multiple your Agent NFT Token Id by one thousand and enter that as your Founder Id.</div>';
				$theStr .= '<div class="standard">When you press "Validate to Proceed" the website will check that you own the given Agent Token Id that is based off the Founder Id and then all the functionality that is enabled will act upon that Token Id.</div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}

		} else {
			$theStr .= 'customCode is not defined<br>';
		}
		return $theStr;
	
	}


	// This section displays information about the agent network and the individual token.
	private function agentInfoSection()
	{
		$secId = 'agentInfo';
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= '<div style="background-color:#ffead4;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= '<div class="row">';
				$theStr .= '<span><center><div id="'.$secId.'FounderId">FounderId: </div></center></span>';
				$theStr .= '<span><center><div id="'.$secId.'SlotsRemainingId">Slots Remaining: </div></center></span>';
				$theStr .= '<span><center><div id="'.$secId.'TotalAgentsId">Total Agents on network: </div></center></span>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}
			else
			{
				$theStr .= '<div style="background-color:#ffead4;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= '<span><center><div id="'.$secId.'FounderId">FounderId: </div></center></span>';
				$theStr .= '</div>';
				$theStr .= '<div class="column left">';
				$theStr .= '<span><div id="'.$secId.'SlotsRemainingId">Slots Remaining: </div></span>';
				$theStr .= '</div>';
				$theStr .= '<div class="column left">';
				$theStr .= '<span><div id="'.$secId.'TotalAgentsId">Total Agents on network: </div></span>';
				$theStr .= '</div>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}

		} 
		return $theStr;
	}

	// This section is for extending registration table
	private function registerExtend() {
		$secId = 'regExtend'; 
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= '<div style="background-color:#aafabe;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Extend functionality');
				$theStr .= '<div class="row">';
				$theStr .= self::buttonType($secId,"ExtendSlots()","Extend Slots",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">This section is only shown if the window for extending the number of slots on an Agent NFT is open. Just press the "Extend Slots" button to exercise this option.</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}
			else
			{
				$theStr .= '<div style="background-color:#aafabe;">';
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Extend functionality');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= self::buttonType($secId,"ExtendSlots()","Extend Slots",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">This section is only shown if the window for extending the number of slots on an Agent NFT is open. Just press the "Extend Slots" button to exercise this option.</div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
				$theStr .= '</div>';
			}
		}
		return $theStr;
	}



	// register agent section
	private function registerAddr() {
		$secId = 'regAddr'; 
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Registration functionality');
				$theStr .= '<div class="row">';
				$theStr .= self::inputType($secId,"text","wallet to register");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"registerAgent()","Register Agent", true);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">When a Founder Agent wants to register a new Agent, place the new agent\'s wallet address in the "wallet to register" control and press the "Register Agent" button. If the transaction is succesful, perform a "Lookup by Wallet" search to get the agent Id that is now associated with the registered wallet.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'CostId">Registration currently costs $.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'TfuelId">price</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}
			else
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Registration functionality');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= self::inputType($secId,"text","wallet to register");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"registerAgent()","Register Agent", true);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">When a Founder Agent wants to register a new Agent, place the new agent\'s wallet address in the "wallet to register" control and press the "Register Agent" button. If the transaction is succesful, perform a "Lookup by Wallet" search to get the agent Id that is now associated with the registered wallet.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'CostId">Registration currently costs $.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'TfuelId">price</div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}

		}
		return $theStr;
	}

	private function lookUpByWallet() {
		$secId = 'regLU';
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Lookup by Wallet functionality');
				$theStr .= '<div class="row">';
				$theStr .= self::inputType($secId,"text","wallet address");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"LookupByAddress()","Lookup By Address",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard" id="'.$secId.'AddrDescriptionId">To look up and see if a wallet is registered as a Partner Agent in the network, place the wallet address in the "Wallet Address" control and press the "Lookup by Address" button.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'Wallet">Wallet Address: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'AgentId">AgentId: </div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}
			else
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Lookup by Wallet functionality');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= self::inputType($secId,"text","wallet address");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"LookupByAddress()","Lookup By Address",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard" id="'.$secId.'AddrDescriptionId">To look up and see if a wallet is registered as a Partner Agent in the network, place the wallet address in the "Wallet Address" control and press the "Lookup by Address" button.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'Wallet">Wallet Address: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'AgentId">AgentId: </div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}

		}
		return $theStr;
	}

	private function lookUpById() {
		$secId = "regLUById"; // This is the base id string for all elements of this section.
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Lookup by AgentId functionality');
				$theStr .= '<div class="row">';
				$theStr .= self::inputType($secId,"number","Agent Id");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"LookupByAgentId()","Lookup By Agent Id",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">If you want to find the founder and partner wallets for a given AgentId, place the AgentId in this section and press the "Lookup By AgentId" button.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'AgentId">Agent: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'FounderId">Founder Wallet: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'PartnerId">Partner Wallet: </div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}
			else
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'Lookup by AgentId functionality');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= self::inputType($secId,"number","Agent Id");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"LookupByAgentId()","Lookup By Agent Id",false);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">If you want to find the founder and partner wallets for a given AgentId, place the AgentId in this section and press the "Lookup By AgentId" button.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'AgentId">Agent: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'FounderId">Founder Wallet: </div>';
				$theStr .= '<div class="standard" id="'.$secId.'PartnerId">Partner Wallet: </div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
				$theStr .= self::dashedSeperator();
				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}

		}
		return $theStr;
	}

	private function sendLockHTML()
	{
		$secId = 'sl';
		$theStr = "";
		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			if( true == $this->gData['mobile']) 
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'SendLock Section');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="standard" id="'.$secId.'TokenId"></div>';
				//$theStr .= self::inputType($secId."Token","number","Token Id Not Founder Id");
				$theStr .= '<br>';
				$theStr .= self::inputType($secId."Address","text","Backup Address");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"sendLockRegister()","sendLock",true);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">Protect your NFT! Because the sales network uses hot wallet functionality, this NFT offers the ability to pre-register a backup wallet which will serve as the next future destination of this NFT. This functionality allows you to protect this resource from unauthorized movement. If you register a backup wallet address and someone gains access to this account with the intent of sending this resource to a wallet that they control, the send opperation will move the resource to the pre-registered wallet rather than the unauthorized wallet location. In other words, when the theif issues a sendtransaction on this resource, the contract will send it to the cached location instead.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId1">To use this functionality, provide your backup wallet address and then click the sendLock button. Metamask will be launched to record the address you provide as the next location the NFT will be sent too.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId2">There is no undoing this preregistered transfer, thus confirm the backup wallet address is correct.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'CostId">sendLock currently costs $.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'TfuelId">price</div>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}
			else
			{
				$theStr .= self::sectionHead($secId,true);
				$theStr .= self::sectionTitle($secId,'SendLock Section');
				$theStr .= '<div class="row">';
				$theStr .= '<div class="column left">';
				$theStr .= '<div class="standard" id="'.$secId.'TokenId"></div>';
				//$theStr .= self::inputType($secId."Token","number","Token Id Not Founder Id");
				$theStr .= '<br>';
				$theStr .= self::inputType($secId."Address","text","Backup Address");
				$theStr .= '<br>';
				$theStr .= self::buttonType($secId,"sendLockRegister()","sendLock",true);
				$theStr .= '<br>';
				$theStr .= self::resultTrxn($secId);
				$theStr .= '</div>';
				$theStr .= '<div class="column right">';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId">Protect your NFT! Because the sales network uses hot wallet functionality, this NFT offers the ability to pre-register a backup wallet which will serve as the next future destination of this NFT. This functionality allows you to protect this resource from unauthorized movement. If you register a backup wallet address and someone gains access to this account with the intent of sending this resource to a wallet that they control, the send opperation will move the resource to the pre-registered wallet rather than the unauthorized wallet location. In other words, when the theif issues a sendtransaction on this resource, the contract will send it to the cached location instead.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId1">To use this functionality, provide your backup wallet address and then click the sendLock button. Metamask will be launched to record the address you provide as the next location the NFT will be sent too.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'DescriptionId2">There is no undoing this preregistered transfer, thus confirm the backup wallet address is correct.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'CostId">sendLock currently costs $.</div>';
				$theStr .= '<div class="standard" id="'.$secId.'TfuelId">price</div>';
				$theStr .= '</div>';
				$theStr .= '</div>';
  				$theStr .= self::clearAll();
				$theStr .= self::sectionTail();
			}
		} 
		return $theStr;
	}

	// The custom section will return HTML, the standard dsn functionality is handled by core code.
	//
	// There are seven sections that will be displayed to the visitor:
	// - Token Selection Section
	//   * must hold more than 1 token
	// - Agent section
	//   * must hold at least 1 token.
	// - Extend functionality
	//   * must be token holder & the extend window open & a single defined token Id
	// - Registration functionality
	//   * must be token holder & a single defined token Id
	// - Lookup by Wallet functionality
	//   * Anyone visiting site
	// - Lookup by AgentId functionality
	//   * Anyone visiting site
	// - SendLock Section
	//   * must be token holder & a single defined token Id
	//
	public function customHTML() 
	{
		$secId = 'main';
		$theStr = "";

		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			$theStr .= self::cssCustom();

			// all custom code has a very lightgray background
			$theStr .= self::sectionTitle($secId,'Custom Registration Section');
			$theStr .= '<div style="background-color:#f0f0f0;" >';  

			$theStr .= self::tokenSelection();

			$theStr .= self::agentInfoSection();
			$theStr .= self::registerExtend();
			$theStr .= self::registerAddr();
			$theStr .= self::lookUpByWallet();
			$theStr .= self::lookUpById();
			$theStr .= self::sendLockHTML();

			$theStr .= '</div>';

		}
		return $theStr;
	}
}

function run_the_code() {

	$arrParams = [];
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}

	$cCustomNFT = new Custom_nft($arrParams);
/*
		// For debugging
		if( $this->gData['debug'] == 1 ) {
			foreach($this->gData as $key => $item) {
				echo $key.': '.$item."<br>";
			}
			echo "Done with globals<br>";
		}
*/

	$plugin = new Theta_nft();
	$plugin->Init($cCustomNFT);
	$plugin->thePage($arrParams);
}
run_the_code();

