// script goes here.

let arrCustom = [];
arrCustom['ABI'] = [];
//
// The following functionality is exposed by the custom contract.
// for pricesRead()
arrCustom['ABI'].push({ "inputs": [], "name": "pricesRead", "outputs": [{ "internalType": "uint256", "name": "mintWei", "type": "uint256" }, { "internalType": "uint256", "name": "registrationWei", "type": "uint256" }, { "internalType": "uint256", "name": "sendlockWei", "type": "uint256" }], "stateMutability": "view", "type": "function" });

// for SendLock()
arrCustom['ABI'].push({ "inputs": [{ "internalType": "address", "name": "to", "type": "address" }, { "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "sendLockRegister", "outputs": [], "stateMutability": "payable", "type": "function" });

// for regAgent(), regExtend(), regLookupPartner(), regResolve(), regSlotsRemaining(), regTotalAgents()
arrCustom['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_agentId", "type": "uint256" }, { "internalType": "address", "name": "_partnerAddr", "type": "address" }], "name": "regAgent", "outputs": [{ "internalType": "uint256", "name": "partnerId", "type": "uint256" }], "stateMutability": "payable", "type": "function" });
arrCustom['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_agentId", "type": "uint256" }], "name": "regExtend", "outputs": [{ "internalType": "uint256", "name": "count", "type": "uint256" }], "stateMutability": "nonpayable", "type": "function" });
arrCustom['ABI'].push({ "inputs": [{ "internalType": "address", "name": "_lookup", "type": "address" }], "name": "regLookupPartner", "outputs": [{ "internalType": "uint256", "name": "agentId", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrCustom['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_agentId", "type": "uint256" }], "name": "regResolve", "outputs": [{ "internalType": "address", "name": "founderAddr", "type": "address" }, { "internalType": "address", "name": "partnerAddr", "type": "address" }], "stateMutability": "view", "type": "function" });
arrCustom['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "_agentId", "type": "uint256" }], "name": "regSlotsRemaining", "outputs": [{ "internalType": "uint256", "name": "count", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrCustom['ABI'].push({ "inputs": [], "name": "regTotalAgents", "outputs": [{ "internalType": "uint256", "name": "totalAgents", "type": "uint256" }], "stateMutability": "view", "type": "function" });
arrCustom['ABI'].push({ "inputs": [], "name": "IsMintReady", "outputs": [{ "internalType": "bool", "name": "", "type": "bool" }], "stateMutability": "view", "type": "function" });

// basic ownership functionality
arrCustom['ABI'].push({ "inputs": [{ "internalType": "uint256", "name": "tokenId", "type": "uint256" }], "name": "ownerOf", "outputs": [{ "internalType": "address", "name": "", "type": "address" }], "stateMutability": "view", "type": "function" });
// ERC721
arrCustom['ABI'].push({ "inputs": [{ "internalType": "address", "name": "owner", "type": "address" }], "name": "balanceOf", "outputs": [{ "internalType": "uint256", "name": "", "type": "uint256" }], "stateMutability": "view", "type": "function" });
// IMintV1
arrCustom['ABI'].push({ "inputs": [], "name": "totalSupply", "outputs": [{ "internalType": "uint256", "name": "theTotalSupply", "type": "uint256" }], "stateMutability": "view", "type": "function" });
// IPennyOracleV1
arrCustom['ABI'].push({ "inputs": [], "name": "pennyPriceTfuel", "outputs": [{ "internalType": "uint256", "name": "pennyTfuelWei", "type": "uint256" }, { "internalType": "string", "name": "priceOfTfuel", "type": "string" }], "stateMutability": "view", "type": "function" });

//
// Main entry point.
//
// To anyone visiting this page, we'll show the agent lookup functionality. This allows anyone to 
// find their agent Id or validate that an agent id is the correct wallet. 
//
// The rest of the code is reserved for token holders. Because we don't have any memory of the tokens
// held by the visitor, we will prompt them for the Founder Id and then check it for validation. Once 
// it passes the check, then we show the special sections that can act upon that founder id.
//
document.addEventListener("DOMContentLoaded", async function (){
    console.log("In JavaScript custom routine");

    // to start, the user either holds this NFT or doesn't. We display different sets of data
    // and action based on this.

    if (window.ethereum) {
        await window.ethereum.request({ method: 'eth_accounts' });
        window.web3 = new Web3(window.ethereum);

        let accounts = await web3.eth.getAccounts();
        arrCustom["account"] = accounts[0];
        if (typeof arrCustom["account"] === 'undefined' || (arrCustom["account"] === null)) {
            console.log('Not Connected!');
            return;
        }
/*
        if (typeof arrGlobals['customContract'] === 'undefined') {
            console.log('customContract is undefined');
        } else {
            console.log('customContract is defined');
        }
*/
        // This code depends upon the following variables. 
        arrCustom['customContract'] = arrGlobals['customContract'];
        arrCustom['BalanceTfuel'] = arrGlobals['BalanceTfuel'];
        console.log(arrCustom);

        //console.log("customContract: " + arrCustom['customContract']);
        //console.log("customABI: " + arrCustom['ABI']);
        arrCustom['customContractObj'] = new window.web3.eth.Contract(arrCustom['ABI'], arrCustom['customContract']);
        //arrCustom['CustomContract'] = contract;

        // Always turn on the lookup sections.
        document.getElementById('regLURowId').style.display = "block"; // 'none' for hidding
        document.getElementById('regLUByIdRowId').style.display = "block"; // 'none' for hidding

        // here is where we determine the balance of agent NFTs.
        let tmp = await arrCustom['customContractObj'].methods.balanceOf(arrCustom["account"]).call();
        arrCustom['Tokens'] = tmp;

        console.log("visitor holds: " + arrCustom['Tokens']+" Agent NFTs");
        // If the visitor holds an Agent NFT, they are a founder. If they only hold one,
        // we'll resolve their wallet address to get the founderId. If they hold multiple
        // NFTs, we'll prompt the visitor to enter the founderId that they want to use.
        if (arrCustom['Tokens'] >= 1) {
            // prompt the user to specify what founderId they want to use.
            document.getElementById('selectionRowId').style.display = "block"; // 'none' for hidding
            //console.log("holds more than 1 agent NFT");
        }

        // One of the special things that the Agent contract does is allow us to determine if
        // minting is active or not. Thus, we are going to ask the contract if it is allowing 
        // minting. If not, we disable the mint button in the base code.
        arrCustom['customContractObj'].methods.IsMintReady().call().then(bMintReady => {
            if (false == bMintReady) {
                console.log('minting is currently closed');
                document.getElementById('mintButtonId0').disabled = true;
            }
        });

    }

});


// This routine depends upon some global variables being set. 
// arrCustom['FounderId'] > 0
async function displayForFounder() {

    if (arrCustom['FounderId'] > 0) {

        // need to set the founder id
        document.getElementById('agentInfoFounderId').innerHTML = "Founder Id: " + arrCustom['FounderId'];
        // see if we can make a couple async calls here for other data.

        // In order to display the extend section, we need to serialize on three pieces of data:
        // Number of agents on network, slots remaining for this NFT and total number of NFTs

        let theTotalNFTs = await arrCustom['customContractObj'].methods.totalSupply().call();
        //console.log("Total NFTs: " + theTotalNFTs);

        let theSlotsRemaining = await arrCustom['customContractObj'].methods.regSlotsRemaining(arrCustom['FounderId']).call();
        //console.log("Slots Remaining: " + theSlotsRemaining);
        document.getElementById("agentInfoSlotsRemainingId").innerHTML = "Slots Remaining: " + theSlotsRemaining;

        // now get the total number of agents
        let theTotalAgents = await arrCustom['customContractObj'].methods.regTotalAgents().call();
        //console.log("Total Agents: " + theTotalAgents);
        document.getElementById("agentInfoTotalAgentsId").innerHTML = "Total Partner Agents: " + theTotalAgents;

        document.getElementById('selectionRowId').style.display = "none"; // 'none' for hidding
        document.getElementById('agentInfoRowId').style.display = "block"; // 'none' for hidding
/*
        // NOTE: these values are for testing the extend section 
        theTotalNFTs = 42;
        theSlotsRemaining = 2;
*/
        // Now, if the extend functionality is available, display it.
        //
        // The extend slots functionality is conditional. It will only be allowed
        // if the total supply of NFTs is >=42 AND the number of registered 
        // agents is less than (TotalSupply * 8) AND the number of slots remaining
        // is less then 5. 
        if ((theTotalNFTs >= 42) &&
            (theTotalAgents < (theTotalNFTs * 8)) &&
            (theSlotsRemaining < 5)
        ) {
            //console.log('Enable Extend Info');
            document.getElementById('regExtendRowId').style.display = "block"; // 'none' for hidding
        }

        // Now let's get the Registration functionality data.
        prices();

        document.getElementById('regAddrRowId').style.display = "block"; // 'none' for hidding
        document.getElementById('slRowId').style.display = "block"; // 'none' for hidding
    }
}

async function prices() {
    //
    // In order to display the costs for things, we need the penny price of tfuel and the
    // cost of interacting with the contract.
    //
    // let's get the penny price of tfuel
    arrCustom['customContractObj'].methods.pennyPriceTfuel().call().then(pennyPriceObj => {
        //console.log(pennyPriceObj);

        // Need to get the costs for things here.
        arrCustom['customContractObj'].methods.pricesRead().call().then(pricesObj => {

            //console.log(pricesObj);
            let theRegTfuel = Number(BigInt(pricesObj.registrationWei) / BigInt(10000000000000000)) / 100;
            //console.log("theRegTfuel: " + theRegTfuel);
            let theLockTfuel = Number(BigInt(pricesObj.sendlockWei) / BigInt(10000000000000000)) / 100;
            //console.log("theLockTfuel: " + theLockTfuel);

            arrCustom['costRegistrationWei'] = pricesObj.registrationWei;
            console.log('costRegistrationWei: ' + arrCustom['costRegistrationWei']);
            arrCustom['costSendLockWei'] = pricesObj.sendlockWei;
            console.log('costSendLockWei: ' + arrCustom['costSendLockWei']);

            // set the registration info
            let thePrice = Number(BigInt(pennyPriceObj.priceOfTfuel * pricesObj.registrationWei) / BigInt(1000000000000000)) / 1000;
            //console.log("thePrice: " + thePrice);

            document.getElementById("regAddrCostId").innerHTML = "Registration currently costs ~$" + thePrice + ".";
            document.getElementById("regAddrTfuelId").innerHTML = "Registration price:  " + theRegTfuel + " tfuel";
            // The "Register Agent" button can not be pressed until these prices are known.
            // And, if the user is not carrying enough balance, we can't enable
            if (arrCustom['BalanceTfuel'] > theRegTfuel) {
                document.getElementById("regAddrbuttonId").disabled = false;
            }

            // now set the sendLock info
            thePrice = Number(BigInt(pennyPriceObj.priceOfTfuel * pricesObj.sendlockWei) / BigInt(1000000000000000)) / 1000;
            document.getElementById("slCostId").innerHTML = "SendLock currently costs ~$" + thePrice + ".";
            document.getElementById("slTfuelId").innerHTML = "SendLock price:  " + theLockTfuel + " tfuel";
            // The "sendLock" button can not be pressed until these prides are known.
            if (arrCustom['BalanceTfuel'] > theLockTfuel) {
                document.getElementById("slbuttonId").disabled = false;
            }
        });
    });
}

//
// This routine is called when the visitor presses the 'validate to proceed' button in the
// Token Selection Section. The user provides a number in the thousands and we check to see
// if they own a Agent Token of this id. If so, we set 'FounderId' and reset the display.
//
async function resolveFounderId() {
    if (await IsCorrectNetwork()) {

        let selId = 'selection';

        // Read the text control for the data to check.
        let theId = document.getElementById(selId+"inputId").value;
        //console.log("theId: " + theId);
        // 
        // now reduce theId down to a token id
        let theFounderTokenId = (parseInt(parseInt(theId/1000)) );
        console.log("FounderTokenId: " + theFounderTokenId);

        let dataObj = document.getElementById(selId + "trxnId");

        // need to call addr = ownerOf(FounderTokenId) and see if it matches the visitor address.
        // if so, they entered a founder token id that they own.
        if (theFounderTokenId > 0) {

            // Validate that the Founder Id is valid
            document.body.style.cursor = 'wait';
            try {
                let tx = await arrCustom['customContractObj'].methods.ownerOf(theFounderTokenId).call();

                console.log(tx);
                if (tx == arrCustom["account"]) {
                    //console.log('We have a match!');

                    arrCustom['FounderId'] = parseInt(theFounderTokenId * 1000);
                    document.getElementById("slTokenId").innerHTML = '<span><center>Token Id: ' + theFounderTokenId + '</center></span>';

                    // It's at this point that we have the FounderId that we're looking for. 
                    // now, reset the display to show all the sections for this FounderId.
                    console.log('reset display for FounderId: ' + arrCustom['FounderId']);

                    displayForFounder();
                    dataObj.innerHTML = "";
                } else {
                    console.log('value is not a match');
                    dataObj.innerHTML = 'Visitor does not hold Token Id: ' + theFounderTokenId;
                }
            } catch (error) {
                dataObj.innerHTML = error.message;
                console.log(error.message);
            }

            document.body.style.cursor = 'default';
        } else {
            console.log('Invalid user input.');
            dataObj.innerHTML = 'Invalid user input';
        }
        dataObj.style.display = "block";
    }
}


// This functionality is offered to any founder == "agentId". 
async function registerAgent() {
    if (await IsCorrectNetwork()) {
        console.log("In registerAgent");

        let secId = 'regAddr';
        let registrationWei = arrCustom['costRegistrationWei'];

        let theAddr = document.getElementById(secId +"inputId").value;
        //TODO: Might want to confirm that the user put in an address. Contract checks...
        console.log("FounderId: " + arrCustom['FounderId']);
        console.log("new agent Addr: " + theAddr);
        console.log("calling register with: " + registrationWei);

        // First parameter is the founder Id, second is the address to register.
        let currentGasPrice = await web3.eth.getGasPrice();

        let dataObj = document.getElementById(secId + "trxnId");
        dataObj.innerHTML = '';  // clean up old error
        if (theAddr != '') {
            try {
                document.body.style.cursor = 'wait';
                await arrCustom['customContractObj'].methods.regAgent(arrCustom['FounderId'], theAddr).send({
                    from: arrCustom["account"],
                    value: registrationWei,
                    gasPrice: currentGasPrice
                }).then(tx => {
                    //console.log(tx);
                    var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                    console.log(transactionRef);

                    dataObj.innerHTML = '';
                });
            } catch (error) {
                console.log(error.message);
                dataObj.innerHTML = error.message;
            }
            document.body.style.cursor = 'default';
        } else {
            dataObj.innerHTML = 'Invalid address';
        }
        dataObj.style.display = "block";
    }
}

// the onclick handler for sendLock.
async function sendLockRegister() {
    if (await IsCorrectNetwork()) {

        // fetch the data from the controls
        let theTokenId = (arrCustom['FounderId']/1000);
        console.log("theTokenId: " + theTokenId);
        let theAddress = document.getElementById("slAddressinputId").value;
        console.log("theAddress: " + theAddress);
        console.log("costWei: " + arrCustom['costSendLockWei']);

        let currentGasPrice = await web3.eth.getGasPrice();

        let dataObj = document.getElementById("sltrxnId");
        dataObj.innerHTML = "";
        try {
            document.body.style.cursor = 'wait';
            await arrCustom['customContractObj'].methods.sendLockRegister(theAddress, theTokenId).send({
                from: arrCustom["account"],
                value: arrCustom['costSendLockWei'],
                gasPrice: currentGasPrice
            }).then(tx => {
                console.log(tx);
                var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                dataObj.innerHTML = transactionRef;
            });
        } catch (error) {
            dataObj.innerHTML = error.message;
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';
    }
}

// we're dealing with the 'regLU' section (inputId,trxnId)
async function LookupByAddress() {
    let theSection = 'regLU';
    if (await IsCorrectNetwork()) {
        let theAddr = document.getElementById(theSection+"inputId").value;
        //console.log("new agent Addr: " + theAddr);

        document.getElementById(theSection + "Wallet").innerHTML = "Wallet Address: " + theAddr;

        let dataObj = document.getElementById(theSection+"trxnId");
        try {
            document.body.style.cursor = 'wait';
            await arrCustom['customContractObj'].methods.regLookupPartner(theAddr).call().then(tx => {
                //console.log(tx);
                if (0 != tx) {
                    // Success path
                    document.getElementById(theSection + "AgentId").innerHTML = "AgentId: " + tx;
                } else {
                    document.getElementById(theSection + "AgentId").innerHTML = "AgentId: Is not registered";
                }
                // clear out input controls.
                dataObj.innerHTML = "";
                document.getElementById(theSection + "inputId").value = "";
            });
        } catch (error) {
            //console.log(error.message);
            dataObj.innerHTML = error.message;
            document.getElementById(theSection + "AgentId").innerHTML = "AgentId: " + "Did not resolve.";
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';
    }
}

// AgentId,FounderId,FounderId
async function LookupByAgentId() {
    let theSection = 'regLUById';
    if (await IsCorrectNetwork()) {

        // read the value to check.
        let theId = document.getElementById(theSection+"inputId").value;
        //console.log("lookup agentId: " + theId);

        let dataObj = document.getElementById(theSection+"trxnId");
        try {
            document.body.style.cursor = 'wait';
            await arrCustom['customContractObj'].methods.regResolve(theId).call().then(tx => {
                //console.log(tx);
                if (0 != tx.founderAddr && 0 != tx.partnerAddr) {
                    // Success path
                    document.getElementById(theSection + "AgentId").innerHTML = "AgentId: " + theId;
                    document.getElementById(theSection + "FounderId").innerHTML = "Founder Wallet: " + tx.founderAddr;
                    document.getElementById(theSection + "PartnerId").innerHTML = "Partner Wallet: " + tx.partnerAddr;
                } else {
                    // did not resolve
                    document.getElementById(theSection + "AgentId").innerHTML = "AgentId: " + theId;
                    document.getElementById(theSection + "FounderId").innerHTML = "Does not resolve as Founder.";
                    document.getElementById(theSection + "PartnerId").innerHTML = "Does not resolve as Partner.";
                }

                // clear out controls
                document.getElementById(theSection + "inputId").value = "";
                dataObj.innerHTML = "";
            });
        } catch (error) {
            //console.log(error.message);
            document.getElementById(theSection + "AgentId").innerHTML = "AgentId: Encountered an error";
            dataObj.innerHTML = error.message;
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';
    }
}