<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}

require_once($theRootDir.'/dsn/authsig.php');
//echo $theRootDir.'/dsn/authsig.php';

/*
This class is the project specific file that contains the reward code for when
the signature check is passed. The overall goal is to get a specific file to 
download through the clients browser. Thus, if the signature matches, The
payload is downloaded.

In other words, this class handles the hidden payload that is only exposed when
the signature passed inspection.
*/
class Custom_nft_Sign {

	function __construct() {
	}

	// returns a data array with the contract address
	public function data() {
		return array(
				// This is the contract address that we will look for in the signature.
				'DRMContract'=>"0x44a8e5648334a6685c8425676d7c074e19c9a37f"
				// This is a directory path to where the private folder is on the server. that
				// folder should have permissions set to no public viewing. The only access 
				// to that folder should be from this server code. Note that the calling
				// code will give us the subfolder followed by the filename. 
				,'root' => '/kunden/homepages/22/d319923382/htdocs/AmorStyleEx/main/private/'
				);
	}
}


function run_the_code() {

	$cCustomNFTSig = new Custom_nft_Sign();
	$theData = $cCustomNFTSig->data();

	if( !isset($_GET['loc']) || 
		!isset($_GET['file']) ) {

		exit("Invalid URL Parameters.");
	}

	$urlLoc = $_GET['loc'];
	$urlFile = $_GET['file'];

	$plugin = new AuthSignature_nft();
	$plugin->Init($cCustomNFTSig);
	$theResult = $plugin->Main();
	if( $theResult != null )
	{
		// only allow access to the prize if the signature passed and the count is non-zero
		if(true == $theResult['signature'] && $theResult['balance']>0)
		{
			if( 'download' == $theResult['rtype'] )
			{
				// Since we've passed the signature test, we'll build access now.
				$file_path = $theData['root'].$urlLoc.'/'.$urlFile;
				if (file_exists($file_path) && is_readable($file_path)) {

					header('Content-Type: audio/mp3');

					header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
					header('Content-Length: ' . filesize($file_path));
					header('X-Robots-Tag: noindex');

					header('Cache-Control: no-cache'); // Optional: prevents caching
					header('Pragma: no-cache'); // Optional: prevents caching (older browsers)

					readfile($file_path);
					exit;
				} 
			}
		}
	}
}
run_the_code();