<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}
// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}


require_once($theRootDir.'/src/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir. '/dsn/dsn.php');

/*
The Custom_nft class is designed to handle functionality that the project provides that is
above and beyond the standard IMetadataHash, ICount and IPay interfaces. 

The base code will use 'theData' to override defaults, load javascript code and callback
in order to build the custom HTML for this page.
*/
class Custom_nft {

	private $gData = array();
	private $gName;

	function __construct($_arrParams) {
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		$this->gData = $dsncommon->globalVars($_arrParams);
	}

	public function theData() {

		$this->gName = 'drmaudiov1';

		// This array is designed to show a single project.
		$theData = array(
			'customContract' => "0x44a8e5648334a6685c8425676d7c074e19c9a37f", // DRM Audio Smart Contract Address
			'javaScriptName' => $GLOBALS['theRootURL'].'/nfts/'.$this->gName.'/'.$this->gName.'.js', // fully qualified url
			'customCode' => true,
			'isSingleView' => true,
			'customTitle' => "DRM Audio Project V1"
			//'theAgentId' => "1001",
			//'theWebsiteId' => "1"
			);

		return $theData;
	}

	private function readJSON() {
		$url = $this->gData['homelink'].'nfts/'.$this->gName.'/'.$this->gName.'.json';
		//$url = 'https://amorstyle.com/nfts/drmaudiov1/drmaudiov1.json';
		$theData = file_get_contents($url);
		$arrData = json_decode($theData,true);
		//var_dump($arrData).'<br>';
		return $arrData;	
	}

	//
	// This section unrolls what was found in the metadata about this project
	//
	private function customTrack($arrTracks)
	{
		$theImage = $this->gData['homelink'].'nfts/'.$this->gName.'/'.$arrTracks['image'];
		$iSize = strval(76);
		$theTrackId = 'trackId'.$arrTracks['track'];

		$param1 = "'".strval($arrTracks['loc'])."'";
		$param2 = "'".strval($arrTracks['file'])."'";
		$theOnClick = 'onclick="downloadTrack('.$param1.','.$param2.')"';

		$theStr = '';
		$theStr.= '<center>';
		$theStr.= '<div style="width: 85%;margin-bottom: 15px;background-color: blue;">';

		$theStr.= '<div style="float: left;width: 33%;">';
		$theStr.= '<img  height="'.$iSize.'px" src="'.$theImage.'">'; // width="'.$iSize.'px"
		$theStr.= '</div>';

		$theStr.= '<div style="float: right;width: 66%;">';
		$theStr.= '<div style="text-align: left"><b>'.$arrTracks['title'].'</b>';
		$theStr.= '<div style="float: right" >';
		$theStr.= '<button class="natural" id="'.$theTrackId.'" '.$theOnClick.' disabled>Signature Download</button>';
		$theStr.= '</div>';
		$theStr.= '</div>';
		$theStr.= '<div style="text-align: left">'.$arrTracks['artist'].'</div>';
		$theStr.= '<div style="text-align: left">Track: '.$arrTracks['track'].'</div>';
		$theStr.= '</div>';

		$theStr.= '</div>';
		$theStr.= '</center>';
	    $theStr.= '<div style="clear: both"></div>';
		return $theStr;
	}

	//
	// This is going to be a custom sign block. The idea is that we display the "Signature Download"
	// button to the user but only enable it if the connected wallet holds at least one NFT from
	// the collection. 
	// When the user clicks the button, MetaMask is launched to sign a message. The message comes
	// from the server like a nounce. 
	// After the user signs the message, the signature is sent to the server for validation. The
	// server decodes the signature in order to get the signing account address. If it matches what
	// we expect, the server downloads the song through the client browser.
	//
	public function customHTML() 
	{
		// let's see if we can sign something with our new class.
		$theSigningTime = time();

		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			$theStr = "<div class='customHTML'>";

			$this->gData['theSigningTime'] = $theSigningTime;
			$arrData = self::readJSON();

			$theStr .= '<div id="customSigningTime" hidden>'.$theSigningTime.'</div>';
			$theStr .= '<div id="customTrxnId" hidden></div>';
			$theStr .= '<div id="startingTracksId" hidden>'.$arrData['audio']['tracks'][0]['track'].'</div>';

			// center the title and artist
			$theStr.= '<center>';
			$theStr .= '<div class="reeltitle" >'.$arrData['audio']['title'].'</div>';
			$theStr .= '<div class="reeldesc">'.$arrData['audio']['artist'].'</div>';
			$theStr.= '</center>';

			$iCount = count($arrData['audio']['tracks']);
			$theStr .= '<div id="countTracksId" hidden>'.$iCount.'</div>';
			for($i=0;$i<$iCount;$i++) {
				$theStr .= self::customTrack($arrData['audio']['tracks'][$i]);
			}

			$theStr .= "</div>";

			return $theStr;
		} else {
			return "";
		}
	}
}

function run_the_code() {

	$arrParams = [];
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}

	$cCustomNFT = new Custom_nft($arrParams);

	$plugin = new Theta_nft();
	$plugin->Init($cCustomNFT);
	$plugin->thePage($arrParams);
}
run_the_code();

