<?php

//
// The following block of code that sets a few global variables should be included 
// in every client facing file. Files that should not be called directly should abort
// if $globalsSet is false.
//
// This file should be included in every dsn based nft. It sets the root directory
// path for both including php files and javascript files.
//
// The idea is what we want an 'theRootDir' that can be used by require_once when
// building locations to where source files exist.
//
if( !isset($globalsSet)) {
// For php, if $theRootDir doesn't exist, we create it.
if( !isset($theRootDir) ) {
	if( $_SERVER["SERVER_NAME"] == "localhost") {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"].'/'.'amorstyle';
	} else {
		$theRootDir = $_SERVER["DOCUMENT_ROOT"];
	}
	//echo "base: theRootDir: ".$theRootDir."<br>";
}
// For javascript:
if( !isset($theRootURL) ) {
	$theRootURL = $_SERVER["REQUEST_SCHEME"].'://'.$_SERVER["HTTP_HOST"];
	if( $_SERVER["HTTP_HOST"] == 'localhost') {
		$theRootURL = $theRootURL.'/amorstyle';
	}
	//echo "base: theRootURL: ".$theRootURL."<br>";
}
// for project files
if( !isset($theRequestDirURL) ) {
	$theRequestDirURL = $theRootURL.pathinfo($_SERVER["PHP_SELF"],PATHINFO_DIRNAME);
	//echo 'theRequestDirURL: '.$theRequestDirURL.'<br>';
}
$globalsSet = true;
}

if( !isset($globalMobile)) {
// Are we on a mobile system or desktop pc?
$globalMobile = false;
if(strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'android')) {
	$globalMobile = true;
} 
//$globalMobile = true;
}
// for testing
if( isset($_GET['display']) && 'mobile' == $_GET['display'])
{
$globalMobile = true;
}


require_once($theRootDir.'/dsn/theta.php');
require_once($theRootDir.'/src/dsnreadme.php');
require_once($theRootDir.'/dsn/dsncommon.php');
require_once($theRootDir. '/dsn/dsn.php');

class CMintable_nft {

	private $gData = array(); // global data

	private $gMetadataURL; // URL to metadata file
	private $garrData = array(); // the metadata file data
	private $localData = array(); // for local options.

	function __construct($_arrData,$_metadataURL,$_series,$_spot) {

		$this->gData = $_arrData;
		$this->gMetadataURL = $_metadataURL;

		// custom settings. There are three sizes that have been
		// created for displaying the NFTs. small, midium and large.
		// small = 140
		// medium = 220
		// large = 380
		// 
		$this->localData['customSmall']=140; //240
		$this->localData['customMedium']=220; //240
		$this->localData['customLarge']=380; //240
		$this->localData['series']=$_series;
		$this->localData['spot']=$_spot;

		$this->localData['centerIt']=false;

	}

	public function debug() {
		echo $this->gMetadataURL.'<br>';
		echo 'name: '.self::name().'<br>';
		echo 'image url: '.self::imageURL().'<br>';

		echo 'pennies: '.self::pennies().'<br>';
		echo 'limit: '.self::limit().'<br>';
		echo 'series: '.self::series().'<br>';
		echo 'spot: '.self::spot().'<br>';
	}
	private function name() {
		if( isset($this->garrData['name']) ) {
			return $this->garrData['name'];
		}
		return '';
	}
	private function imageURL() {
		if( isset($this->garrData['image']) ) {
			return $this->garrData['image'];
		}
		return null;
	}

	private function pennies() {
		if( isset($this->garrData['cardsv1']) ) {
			if( isset($this->garrData['cardsv1']['pennies']) ) {
				return $this->garrData['cardsv1']['pennies'];
			}
		}
		return -1;
	}
	private function limit() {
		if( isset($this->garrData['cardsv1']) ) {
			if( isset($this->garrData['cardsv1']['limit']) ) {
				return $this->garrData['cardsv1']['limit'];
			}
		}
		return -1;
	}
	private function series() {
		if(isset($this->localData['series'])) {
			return $this->localData['series'];
		}
		return -1;

	}
	private function spot() {
		if(isset($this->localData['spot'])) {
			return $this->localData['spot'];
		}
		return -1;
	}

	private function thePriceLine() {
		$PriceId = 'price'.self::series().'_'.self::spot().'Id';
		$LimitId = 'limit'.self::series().'_'.self::spot().'Id';
		// now for raw data
		$placePenniesId = 'placePennies'.self::series().'_'.self::spot().'Id';
		$placeLimitId = 'placeLimit'.self::series().'_'.self::spot().'Id';

		$theStr = '';
		$theStr.= '<p>';
		$theStr.= '<span class="natural" style="float: left" id="'.$PriceId.'"></span>';
		$theStr.= '<span class="natural" style="float: right" id="'.$LimitId.'"></span>';
		$theStr.= '</p>';
		$theStr.= '<div id="'.$placePenniesId.'" hidden></div>';
		$theStr.= '<div id="'.$placeLimitId.'" hidden></div>';
		return $theStr;
	}

	public function centerIt() {
		// only used for single view
		$this->localData['centerIt']=true;
		$this->gData['size']='large';
	}

	private function cardSize() {
		$header=36;
		$line=24;
		$this->localData['Ytop']=60; // point where the two images are scaled from.
	
		if( 'small'==$this->gData['size']) {
			$this->localData['width'] = $this->localData['customSmall']; // image width and height
		} else if( 'medium'==$this->gData['size']) {
			$this->localData['width'] = $this->localData['customMedium']; // image width and height
		} else if( 'large'==$this->gData['size']) {
			$this->localData['width'] = $this->localData['customLarge']; // image width and height
		}
		$this->localData['height'] = $this->localData['width'] * $this->gData['ratio']; //px

		$this->localData['YPlace']=$this->localData['Ytop']+$this->localData['height']-($line);
		$this->localData['YMintToggle']=$this->localData['Ytop']+$this->localData['height']-($line);

		$buffer = 40; // extra space at bottom for larger images.
		if( $this->localData['width'] > 140 ) {
			$buffer+=$line;
		}

		// if the width is small, there is a high chance the title line will wrap,
		// thus we'll add a line of height in that case.
		if( $this->localData['width'] < 200 ) {
			$this->localData['height'] += $line;
		}
		$this->localData['gwidth'] = $this->localData['width']+2*(2*5); // little bit bigger
		$this->localData['gheight'] = $this->localData['height']+(2*5)+($line+$header+$buffer);

		$this->localData['mintXOffset'] = $this->localData['gwidth']-55; // right point.
		$this->localData['placeXOffset'] = $this->localData['mintXOffset'];
		$this->localData['mintToggleXOffset'] = 5; // left side
	}

	// assuming a line is 24px height.
	public function theCard($_i) {
		
		$cardId = 'card'.self::series().'_'.self::spot().'Id';
		$cardSeriesId = 'cardSeries_'.$_i.'_Id'; // cardSeries_x_Id
		$cardSpotId = 'cardSpot_'.$_i.'_Id'; // cardSpot_x_Id
		$ImageLinkId = 'imageLink'.self::series().'_'.self::spot().'Id';  // imageLink1_3Id
		$ImageSrcId = 'imageSrc'.self::series().'_'.self::spot().'Id';
		$TitleId = 'title'.self::series().'_'.self::spot().'Id';
		$MintId = 'mint'.self::series().'_'.self::spot().'Id';
		$PlaceId = 'place'.self::series().'_'.self::spot().'Id';
		$MintToggleId = 'mintToggle'.self::series().'_'.self::spot().'Id';


		self::cardSize();

		$mainbkclr = '#88edeb';
		$topbkclr = '#f0edeb';

		$mintImage = $this->gData['root'].'images/tfuelmint_ismall.png';
		//$mintImage = $this->gData['root'].'images/mint_tfuel_3.png';
		$placeImage = $this->gData['root'].'images/placelogo.png';
		$nftImage = $this->gData['root'].'images/local_large.png';
		$mintToggleImage = $this->gData['root'].'images/minting_off.png';

		//echo 'gwidth: '.$this->localData['gwidth'].'<br>';
		//echo 'gheight: '.$this->localData['gheight'].'<br>';

		// main section style.
		$theStyle = 'background-color:'.$mainbkclr.';width:'.$this->localData['gwidth'].'px;height:'.$this->localData['gheight'].'px';
		if($this->localData['centerIt']) {
			// need to override the tokenrel style with 'float: none'.
			$theStyle .= ';float: none';
		} 

		// Main NFT image
		$theStr = '';
		$theStr .= '<div class="tokenrel" id="'.$cardId.'" style="'.$theStyle.'" >';

		$theStr .= '<div id="'.$cardSeriesId.'" hidden>'.self::series().'</div>';
		$theStr .= '<div id="'.$cardSpotId.'" hidden>'.self::spot().'</div>';

		// create a div that floats for this card
		$theStyle = 'float: left;margin-left: 5px;padding: 5px;background-color: '.$topbkclr;
		$theStr .= '<div style="'.$theStyle.'" width="'.$this->localData['width'].'" height="'.$this->localData['height'].'">';
		$theStr .= '<center><div style="height: '.$this->localData['Ytop'].'px"><p id="'.$TitleId.'">Title Here</p></div></center>';

		// NFT image
		$theStr .= '<div>';
		$theStr .= '<a id="'.$ImageLinkId.'" href="'.$nftImage.'" target=_self>';
		$theStr .= '<img id="'.$ImageSrcId.'" src="'.$nftImage.'" style="top: 5px;left: 5px;max-width: '.$this->localData['width'].'px;max-height: '.$this->localData['height'].'px;">';
		$theStr .= '</a>';
		$theStr .= '</div>';

		// secondary mint image
		$OnClick = 'mintCard('.self::series().','.self::spot().')';
		$imgSpace = 'left: '.$this->localData['mintXOffset'].'px;top: '.$this->localData['YPlace'].'px;max-width: 65px;max-height: 65px;';
		//$imgSpace = 'left: '.$this->localData['mintXOffset'].'px;top: '.$this->localData['Ytop'].'px;max-width: 65px;max-height: 65px;';
		$theStr .= '<img style="position: absolute;'.$imgSpace.'" id="'.$MintId.'" src="'.$mintImage.'" onclick="'.$OnClick.'" hidden>';

		// secondary place image
		$OnClickPlace = 'placeCard('.self::series().','.self::spot().')';
		$imgSpace = 'left: '.$this->localData['placeXOffset'].'px;top: '.$this->localData['YPlace'].'px;max-width: 65px;max-height: 65px;';
		$theStr .= '<img style="position: absolute;'.$imgSpace.'" id="'.$PlaceId.'" src="'.$placeImage.'" onclick="'.$OnClickPlace.'" hidden>';

		// secondary mintOn and mintOff images, gets same location as place above.
		$OnClickMintToggle = 'mintToggleCard('.self::series().','.self::spot().')';
		$imgSpace = 'left: '.$this->localData['mintToggleXOffset'].'px;top: '.$this->localData['YMintToggle'].'px;max-width: 65px;max-height: 65px;';
		$theStr .= '<img style="position: absolute;'.$imgSpace.'" id="'.$MintToggleId.'" src="'.$mintToggleImage.'" onclick="'.$OnClickMintToggle.'" hidden>'; // 

		// js code writes in price.
		$theStr .= self::thePriceLine();
		$theStr .= '</div>';

		$theStr .= '</div>';

		return $theStr;
	}
}


/*
The Custom_nft class is designed to handle functionality that the project provides that is
above and beyond the standard IMetadataHash, ICount and IPay interfaces. 

The base code will use 'theData' to override defaults, load javascript code and callback
in order to build the custom HTML for this page.
*/
class Custom_nft {

	private $gData = array();
	private $gName;

	function __construct($_arrParams) {
		$dsncommon = new DSNCommon();
		if( null == $dsncommon ) 
		{ 
			exit('ERORR: thePage() sees dsncommon as null');
		}

		$this->gData = $dsncommon->globalVars($_arrParams);


		// set the global series and spot values that direct the display
		$this->gData['series']=0;
		$this->gData['spot']=0;
		if( isset($_arrParams['series']) ) {
			$this->gData['series']=$_arrParams['series'];
		}
		if( isset($_arrParams['spot']) ) {
			$this->gData['spot']=$_arrParams['spot'];
		}
		$this->gData['token']=null;
		if( isset($_arrParams['token']) ) {
			$this->gData['token']=$_arrParams['token'];
		}
		$this->gData['size']='small'; // set the default
		if( isset($_arrParams['size'])) {
			$this->gData['size']=$_arrParams['size'];
		}
		$this->gData['tokenHolder']=null;

		//var_dump($this->gData).'<br>';
	}

	public function theData() {

		$this->gName = 'cardsv1';

		// This array is designed to show a single project.
		$theData = array(
			'customContract' => "0xa50e17ec3085fb8a0aa37b93d3267984fadb1cc7", // Smart Contract Address
			'javaScriptName' => $GLOBALS['theRootURL'].'/nfts/'.$this->gName.'/'.$this->gName.'.js', // fully qualified url
			'customCode' => true,
			'isSingleView' => true,
			'customTitle' => "Cards Project V1"
			);

		return $theData;
	}

	// This reads the main project json file.
	private function readJSON() {
		$url = $this->gData['homelink'].'nfts/'.$this->gName.'/'.$this->gName.'.json';
		//$url = 'https://amorstyle.com/nfts/cardsv1/cardsv1.json';
		$theData = file_get_contents($url);
		//var_dump($theData).'<br>';
		$arrData = json_decode($theData,true);
		//var_dump($arrData['hashTable']['locations']['metadata']).'<br>';
		return $arrData;	
	}


	private function getSeriesSpot($_tokenId) {

		// This is the function we're going to call on the contract to translate the 
		// token id into the series and spot numbers that we need.
		// function cardSeriesSpot(uint256 _tokenId) external view returns(uint256 seriesNum, uint256 spotNum);

		// do we have the parameters that we need to fetch this info?
		$theData = self::theData();
		//echo 'customContract: '.$theData['customContract'].'<br>';

		$contract = $theData['customContract'];
		if( null == $contract || '' == $contract ) {
			return false;
		}

		$functionABI = 'cardSeriesSpot(uint256)';
		$outputStr = callFunction($contract,$functionABI,$_tokenId);
		$arrContractData = parseAsTwoNumbers($outputStr);

		if( isset($arrContractData['0']) && isset($arrContractData['1'])) {
			$this->gData['series'] = $arrContractData['0'];
			$this->gData['spot'] = $arrContractData['1'];

			// check for a winner here.
			if( ( $this->gData['series'] == '1') && ( $this->gData['spot'] == '2') ) {

				// function ownerOf(uint256 tokenId) external view returns (address owner);
				$functionABI = 'ownerOf(uint256)';
				$outputStr = callFunction($contract,$functionABI,$_tokenId);
				$arrTokenOwner = parseAsAddress($outputStr);
				$this->gData['tokenHolder']=$arrTokenOwner;
				//echo 'owner of token: '.$arrTokenOwner.'<br>';
			}

		} //else {
		//	// did not get the data.
		//}
	}

	// This routine gets all the metadata files that are in the project file so they can be 
	// offered up for minting. 
	private function customMint($_arrProjectData) {
		// $_arrProjectData['hashTable']['locations']['metadata']

		$theRoot = $_arrProjectData['hashTable']['root'];
		$location = '/metadata/';

		//var_dump($_arrProjectData).'<br>';
		$iCount = count($_arrProjectData['cards']);
		//echo 'count: '.$iCount.'<br>';

		//echo 'token: '.$this->gData['token'].'<br>';
		if( 0 != $this->gData['token'] ) {
			self::getSeriesSpot($this->gData['token']);
		}

		// write to the page the number of items we're going to build and what
		// the starting index is.
		$this->gData['startingIndex'] = 0;
		$this->gData['countOfCards'] = $iCount;
		$this->gData['ratio']= 1;
		if( isset($_arrProjectData['ratio'])) {
			$this->gData['ratio']= $_arrProjectData['ratio'];
		}

		// Each series is put in it's own div. We'll start the collection here.
		// if we find a transition point in the collection, we'll stop and start
		// a new section. Once done, we'll close the collection.

		echo '<center><div id="outterLoop">';

		//echo 'count: '.$iCount.'<br>';
		for($i=$this->gData['startingIndex'];$i<$iCount;$i++) {
			$fileName = $_arrProjectData['cards'][$i]['name'];
			$series = $_arrProjectData['cards'][$i]['series'];
			$spot = $_arrProjectData['cards'][$i]['spot'];

			// build the URL
			$url = $theRoot.$location.$fileName;
			//echo $url.'<br>';

			// Now let's filter based on the URL series and spot.

			if( ( 0 == $this->gData['series']) && ( 0 == $this->gData['spot']) ) {
				// show everything
				// show boarder if need be
				if( isset($_arrProjectData['cards'][$i]['start']) ) {
					if( $i!=$this->gData['startingIndex']) {
						echo '</div></center><div style="clear: both"></div>';
						echo '<center><hr style="width:25%;border-top:1px dotted lightgray"></center><div>'; 
						echo '<center><div>';
					}
				}
				// create a class that will manage the mint process
				$item = new CMintable_nft($this->gData,$url,$series,$spot);
				if( null != $item ) {
					//$item->debug();
					echo $item->theCard($i);
				}

			} else {
				if(( $this->gData['series'] == $series) && ( 0 == $this->gData['spot']) ) {
					// Show the specific series.
					$item = new CMintable_nft($this->gData,$url,$series,$spot);
					if( null != $item ) {
						echo $item->theCard($i);
					}

				} else {
					if(( $this->gData['series'] == $series) && ( $this->gData['spot'] == $spot) ) {
						// Show only the specific item
						$item = new CMintable_nft($this->gData,$url,$series,$spot);
						$item->centerIt();
						if( null != $item ) {
							echo $item->theCard($i);
						}
					}
				}
			}

			//if( $i >=5 ) {
			//	break;
			//}
		}
		echo '</div></center><div style="clear: both"></div>';
		echo '<center><div id="cardTrxnId" style="margin-top: 15px"></div></center>';

	}

	//
	// this is just a 'download prize' button below the NFT. Above it, it reads
	// 'click button to download your prize'
	//
	private function customPrize($theData,$arrProjectData) {

		$theSigningTime = time();
		$this->gData['theSigningTime'] = $theSigningTime;
		//$arrData = self::readJSON();

		$theStr = '';
		$theStr.= '<div id="customPrizeId" hidden>';
		$theStr.= '<div id="tokenHolderAddrId" hidden>'.$this->gData['tokenHolder'].'</div>';
		$theStr .= '<div id="customSigningTime" hidden>'.$theSigningTime.'</div>';
		$theStr .= '<div id="customTrxnId" hidden></div>';

		$loc = 'cards_demo';
		$file = 'prize.jpg';
		$param1 = "'".strval($loc)."'";
		$param2 = "'".strval($file)."'";
		$theOnClick = 'onclick="downloadPrize('.$param1.','.$param2.')"';

		// item
		$theStr.= '<center>';
		$theStr.= '<div style="width: 85%;margin-bottom: 15px;margin-top: 15px;background-color: #88edeb;">';

		// instructions first
		$theStr.='<div class="natural" style="margin-bottom: 15px;margin-top: 15px">Click Signature Download button to claim your prize.</div>';
		$theStr.= '<button class="natural" id="cardsPrizeId" style="margin-bottom: 15px"'.$theOnClick.' >Signature Download</button>'; // disabled

		$theStr.= '</div>';
		$theStr.= '</center>';
		$theStr.= '</div>';

		return $theStr;
	}

	//
	// This is the main callback from the core. We're going to build a 
	// custom mint section that shows all the cards.
	//
	public function customHTML() 
	{

		$theData = self::theData();
		if( isset($theData['customCode']) && (true == $theData['customCode']) ) 
		{
			$theStr = "<div class='customHTML'>";
			//$this->gData['theSigningTime'] = $theSigningTime;
			//$theStr .= '<div id="customSigningTime" hidden>'.$theSigningTime.'</div>';

			$arrProjectData = self::readJSON();
			//var_dump($arrProjectData);
			self::customMint($arrProjectData);

			// we now know how many cards were written to the page. Let's write that
			// out for the js code.
			$theStr.= '<div id="startingIndexId" hidden>'.$this->gData['startingIndex'].'</div>';
			$theStr.= '<div id="countOfCardsId" hidden>'.$this->gData['countOfCards'].'</div>';

			// If someone mints series 1 and spot 2, they will be presented with
			// a download button that will allow them to sign in order to get a download.
			$theStr.=self::customPrize($theData,$arrProjectData);

			$theStr .= "</div>";

			return $theStr;
		} else {
			return "";
		}
	}
}

function run_the_code() {

	$arrParams = [];
	if( isset($_GET['agent']) && is_numeric($_GET['agent'])) {
		$arrParams['agent']=$_GET['agent'];
		//echo "agent: ".$arrParams['agent']."<br>";
	}
	if( isset($_GET['display']) && ('mobile' == $_GET['display'])) {
		$arrParams['mobile']=true;
		//echo "mobile: ".$arrParams['mobile']."<br>";
	} else {
		if( $GLOBALS['globalMobile'] ) {
			$arrParams['mobile']=1; 
			//echo "mobile: ".$arrParams['mobile']."<br>";
		}
	}

	// allow for series and spot to be provided on the URL
	if( isset($_GET['series']) && is_numeric($_GET['series'])) {
		$arrParams['series']=$_GET['series'];
		//echo "series: ".$arrParams['series']."<br>";
	}
	if( isset($_GET['spot']) && is_numeric($_GET['spot'])) {
		$arrParams['spot']=$_GET['spot'];
		//echo "spot: ".$arrParams['spot']."<br>";
	}
	if( isset($_GET['token']) && is_numeric($_GET['token'])) {
		$arrParams['token']=$_GET['token'];
		//echo "token: ".$arrParams['token']."<br>";
	}

	if( isset($_GET['size'])) {
		if( ( 'small' == $_GET['size'] ) || ( 'medium' == $_GET['size'] ) || ( 'large' == $_GET['size'] ) ) {
			$arrParams['size']=$_GET['size'];
			//echo "size: ".$arrParams['size']."<br>";
		} else {
			echo "size on url is not valid: ".$_GET['size']." <br>";
		}
	}

	$cCustomNFT = new Custom_nft($arrParams);

	$plugin = new Theta_nft();
	$plugin->Init($cCustomNFT);
	$plugin->thePage($arrParams);
}
run_the_code();

