// 
// This page handles the js functionality for the custom cards minting.
//
let gVisitorIsAdmin = false;

// can't have this load until the page is loaded... format looks like:
document.addEventListener("DOMContentLoaded", async function (){
    console.log("In JavaScript custom routine");

    // to start, the user either holds this NFT or doesn't. We display different sets of data
    // and action based on this.

    if (window.ethereum) {
        await window.ethereum.request({ method: 'eth_accounts' });
        window.web3 = new Web3(window.ethereum);

        let accounts = await web3.eth.getAccounts();
        // reset this if we don't already have it.
        arrGlobals['visitor'] = accounts[0];
        //g_account = accounts[0];

        if (typeof arrGlobals['visitor'] === 'undefined' || (arrGlobals['visitor'] === null)) {
            console.log('Not Connected!');
            return;
        } else {
            console.log("The Account HERE: " + arrGlobals['visitor']);
        }

        // build a ABI that contains the owner and titled routines.
        let arrABI = [];
        arrABI = arrGlobals['I']['IERC721']['ABI'].concat(arrGlobals['I']['ISelNetV1']['ABI']);

        let LaContracObj = new window.web3.eth.Contract(arrABI, arrGlobals['customContract']);
        if (null == LaContracObj) {
            console.log('ER: getting customContract');
            return;
        }

        //arrGlobals['visitor']
        let resultOwner = await LaContracObj.methods.owner().call();
        //console.log('owner: ' + resultOwner);
        // is the visitor the owner?
        if (resultOwner.toLowerCase() == arrGlobals['visitor'].toLowerCase()) {
            //console.log('Yes, visitor is owner');
            gVisitorIsAdmin = true;
        } else {
            let resultTitled = await LaContracObj.methods.titled().call();
            //console.log('titled: ' + resultTitled);
            if (resultTitled.toLowerCase() == arrGlobals['visitor'].toLowerCase()) {
                //console.log('Yes, visitor is titled');
                gVisitorIsAdmin = true;
            }
        }

        // read the tokenHolder value. if it matches the visitor, enable the download button
        // for the prize.
        //tokenHolderAddrId
        let tokenHolderObj = document.getElementById("tokenHolderAddrId");
        if (null != tokenHolderObj) {
            let holderAddr = tokenHolderObj.innerHTML;
            if (holderAddr.toLowerCase() == arrGlobals['visitor'].toLowerCase()) {
                // enable customPrizeId
                let prizeSecObj = document.getElementById("customPrizeId");
                if (null != prizeSecObj) {
                    prizeSecObj.style.display = 'block';
                }
            }
        }


/*
        //TODO: This gets the balance of the visitor
        let resultCount = await LaContracObj.methods.balanceOf(arrGlobals['visitor']).call();
        console.log(resultCount);
        console.log('do it here.');
*/
        // The php code builds the framework for the cards, this
        // code fills in the details.
        let CountOfCards = 0;
        let startingIndex = 0;

        let cardsObj = document.getElementById("countOfCardsId");
        if (null != cardsObj) {
            CountOfCards = cardsObj.innerHTML;
        }
        console.log('CountOfCards: ' + CountOfCards);
        cardsObj = document.getElementById("startingIndexId");
        if (null != cardsObj) {
            startingIndex = cardsObj.innerHTML;
        }
        console.log('startingIndex: ' + startingIndex);

        // 'cardSeries_'.$_i.'_Id'
        // 'cardSpot_'.$_i.'_Id'
        if (CountOfCards > 0) {
            console.log('There are cards to fetch.');

            // Allocate the structure we need to call the contract.
            arrProjects[0]['contractObj'] = new window.web3.eth.Contract(arrGlobals['I']['ICardsV1']['ABI'], arrGlobals['customContract']);
            //let contract

            for (let j = startingIndex; j <= CountOfCards; j++) {
                let iSeries = 0;
                let iSpot = 0;
                // let's fetch the ids
                let cardSeriesId = 'cardSeries_' + j + '_Id';
                let obj = document.getElementById(cardSeriesId);
                if (null != obj) {
                    // read the innerHTML for the item that needs to be updated.
                    iSeries = Number(obj.innerHTML);
                    //console.log('Series: ' + obj.innerHTML);
                }

                let cardSpotId = 'cardSpot_' + j + '_Id';
                obj = document.getElementById(cardSpotId);
                if (null != obj) {
                    // read the innerHTML for the item that needs to be updated.
                    iSpot = Number(obj.innerHTML);
                    //console.log('Spot: ' + obj.innerHTML);
                }

                if (iSeries != 0 && iSpot != 0) {
                    // now set the $ImageLinkId and $ImageSrcId objects.
                    fetchCard(arrProjects[0]['contractObj'], iSeries, iSpot);
                }

                // here is where a delay would be added to the code.
                await delay(200);
            }
        }
    }
});

function updateCard(_iSeries, _iSpot, _arrCard) {
    //console.log('imageLink' + _iSeries + '_' + _iSpot + 'Id');
    //console.log('imageSrc' + _iSeries + '_' + _iSpot + 'Id');
    //console.log('source: ' + _arrCard['image']);

    // set the link
    let theImageLinkId = 'imageLink' + _iSeries + '_' + _iSpot + 'Id';
    let obj = document.getElementById(theImageLinkId);
    if (null != obj) {
        obj.href = _arrCard['image'];
    } 
    // now set the image
    let theImageSrcId = 'imageSrc' + _iSeries + '_' + _iSpot + 'Id';
    obj = document.getElementById(theImageSrcId);
    if (null != obj) {
        obj.src = _arrCard['image'];
    } 

    // now set the titie - 'title'.self::series().'_'.self::spot().'Id';
    let theTitleId = 'title' + _iSeries + '_' + _iSpot + 'Id';
    obj = document.getElementById(theTitleId);
    if (null != obj) {
        obj.innerHTML = _arrCard['name'];
    } 

    // now set the price - 'price'.self::series().'_'.self::spot().'Id';
    let thePriceId = 'price' + _iSeries + '_' + _iSpot + 'Id';
    obj = document.getElementById(thePriceId);
    if (null != obj) {
        let dollars = Number(_arrCard['cardsv1']['pennies']) / Number(100);
        obj.innerHTML = '$' + dollars;
    } 

    // for placement of new cards.
    let theplacePenniesId = 'placePennies' + _iSeries + '_' + _iSpot + 'Id';
    obj = document.getElementById(theplacePenniesId);
    if (null != obj) {
        obj.innerHTML = _arrCard['cardsv1']['pennies'];
    } 
    let theplaceLimitId = 'placeLimit' + _iSeries + '_' + _iSpot + 'Id';
    obj = document.getElementById(theplaceLimitId);
    if (null != obj) {
        obj.innerHTML = _arrCard['cardsv1']['limit'];
    } 
}

// check to see if this item is mintable. if so, enable it.
async function enableMinting(_contract, _iSeries, _iSpot, cardObj) {
    //console.log('enableMinting start');

    _contract.methods.cardInfo(_iSeries, _iSpot).call().then(infoObj => {
        if (null != infoObj) {
            if (infoObj['bMintable']) {
                //console.log('mintable!');
                // 'mint'.self::series().'_'.self::spot().'Id'
                let theMintId = 'mint' + _iSeries + '_' + _iSpot + 'Id';
                obj = document.getElementById(theMintId);
                if (null != obj) {
                    obj.style.display = 'block';
                }

                //console.log(infoObj);

                let theData = null;
                // Now setup the countOf info based on the total and limit.
                if (0 == infoObj['limit']) {
                    // there is no limit to the mint.
                    theData = infoObj['total'] + '/-';
                } else {
                    // constrained
                    if (infoObj['total'] < infoObj['limit']) {
                        theData = infoObj['total'] + '/' + infoObj['limit'];
                    } else {
                        theData = infoObj['total'] + '/' + infoObj['total'];
                    }
                }
                if (null != theData) {
                    let theLimitId = 'limit' + _iSeries + '_' + _iSpot + 'Id';
                    obj = document.getElementById(theLimitId);
                    if (null != obj) {
                        obj.innerHTML = theData;
                    }
                }

                // if it's mintable and we have the owner, show the mintToggle image.
                // set state of minting.
                if (gVisitorIsAdmin) {
                    let theMintToggleId = 'mintToggle' + _iSeries + '_' + _iSpot + 'Id';
                    obj = document.getElementById(theMintToggleId);
                    if (null != obj) {
                        //$this ->gData['root'].'images/minting_off.png';
                        obj.src = arrGlobals['root'] + 'images/minting_on.png';
                        obj.style.display = 'block'; // show it
                    }
                }

            } else {
                // if all the items are zero, this metadata has not been 
                // registered on the contract. Thus, we're going to want to 
                // offer the ability to register it.
                if ((0 == infoObj['limit']) && (0 == infoObj['pennies']) && (0 == infoObj['total'])) {
                    //console.log('Hide the card unless visitor is owner.');

                    if (false == gVisitorIsAdmin) {
                        let theCardId = 'card' + _iSeries + '_' + _iSpot + 'Id';
                        obj = document.getElementById(theCardId);
                        if (null != obj) {
                            obj.style.display = 'none';
                        }
                    } else {
                        // we want to show the registration and mint toggle functionality.
                        //console.log('show admin functionality');

                        let thePlaceId = 'place' + _iSeries + '_' + _iSpot + 'Id';
                        obj = document.getElementById(thePlaceId);
                        if (null != obj) {
                            obj.style.display = 'block'; // show it
                        }
                    }
                } else {
                    // we have some value registered, but it's not mintable. show disabled mint.
                    // 'mint'.self::series().'_'.self::spot().'Id'
                    let theMintId = 'mint' + _iSeries + '_' + _iSpot + 'Id';
                    obj = document.getElementById(theMintId);
                    if (null != obj) {
                        obj.style.opacity = 0.35;
                        obj.style.display = 'block';
                        obj.removeAttribute('onclick');
                    }

                    // if it's not mintable and we have the owner, show the mintToggle image.
                    // set state of minting.
                    if (gVisitorIsAdmin) {
                        let theMintToggleId = 'mintToggle' + _iSeries + '_' + _iSpot + 'Id';
                        obj = document.getElementById(theMintToggleId);
                        if (null != obj) {
                            //$this ->gData['root'].'images/minting_off.png';
                            obj.src = arrGlobals['root'] + 'images/minting_off.png';
                            obj.style.display = 'block'; // show it
                        }
                    }
                }
            }

        } else {
            console.log('failed to get obj');
        }
    });
}


//
// This routine fetches the metadata for the card.
//
async function fetchCard(_contract,_iSeries,_iSpot) {

    // build the data file
    // TODO: Fix this path-
    let theDataFile = arrGlobals['siteURL']+'nfts/cardsv1/metadata/cardsv1_' + _iSeries + '_' + _iSpot + '.json';

    let url = arrGlobals['siteURL'] + 'dsn/?data=' + theDataFile;
    //console.log('url: '+ url);

    fetch(url).then(response => {
        response.json().then(cardObj => {
            //console.log(cardObj);
            // Update the elements on the page that are associated with this card
            updateCard(_iSeries, _iSpot, cardObj);

            // check to see if it's mintable
            enableMinting(_contract, _iSeries, _iSpot, cardObj);
        }).catch(error => {
            console.log('handling JSON error');
            console.log('issue with metadata file: '+ _iSeries + '_'+ _iSpot);
        });
    });
}

//
// This function is going to mint the card for the user. We are given the
// series and spot from the OnClick function that was built for each card.
//
async function mintCard(_series, _spot) {
    //console.log('mintCard: ' + _series + ' ' + _spot);

    if (await IsCorrectNetwork()) {

        let mintWeiBI = BigInt(0);
        let mintWei = await arrProjects[0]['contractObj'].methods.cardMintPrice(_series, _spot).call();
        if (mintWei != null) {
            mintWeiBI = BigInt(mintWei);
            console.log('mintWei: ' + mintWeiBI.toString());
        }
/*
        // for testing...
        let mintPennies = await arrProjects[0]['contractObj'].methods.cardPenniesRead(_series, _spot).call();
        if (mintPennies != null) {
            console.log('mintPennies: ' + mintPennies);
        }
*/
        // build the parameters here.
        console.log('agent: ' + arrGlobals['agent']);
        console.log('website: ' + arrGlobals['website']);
        console.log('series: ' + _series);
        console.log('spot: ' + _spot);

        let currentGasPrice = await web3.eth.getGasPrice();

        document.body.style.cursor = 'wait';
        let dataObj = document.getElementById("cardTrxnId");
        try {
            // uint256 _AgentId, uint256 _websiteId, uint256 _seriesNum, uint256 _spotNum
            await arrProjects[0]['contractObj'].methods.cardMint(arrGlobals['agent'],arrGlobals['website'],_series,_spot).send({
                from: arrGlobals['visitor'],
                value: mintWeiBI.toString(),
                gasPrice: currentGasPrice
            }).on('error', (error) => {
                console.log('on handler');
                console.log(error);
            }).then(tx => {
                //console.log(tx);
                var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                console.log(transactionRef);
                dataObj.innerHTML = transactionRef;
            });
        } catch (error) {
            console.log(error.message);
            dataObj.innerHTML = error.message;
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';

    }
}

async function placeCard(_series, _spot) {
    console.log('placeCard: ' + _series + ' ' + _spot);

    if (await IsCorrectNetwork()) {

        // build the parameters here.
        console.log('series: ' + _series);
        console.log('spot: ' + _spot);
        let pennies = 0;
        let limit = 0;
        let theplacePenniesId = 'placePennies' + _series + '_' + _spot + 'Id';
        obj = document.getElementById(theplacePenniesId);
        if (null != obj) {
            pennies = Number(obj.innerHTML);
        }
        let theplaceLimitId = 'placeLimit' + _series + '_' + _spot + 'Id';
        obj = document.getElementById(theplaceLimitId);
        if (null != obj) {
            limit = Number(obj.innerHTML);
        } 
        console.log('pennies: ' + pennies);
        console.log('limit: ' + limit);

        let currentGasPrice = await web3.eth.getGasPrice();

        document.body.style.cursor = 'wait';
        let dataObj = document.getElementById("cardTrxnId");
        try {
            await arrProjects[0]['contractObj'].methods.cardNewSpot(_series, _spot, pennies, limit).send({
                from: arrGlobals['visitor'],
                gasPrice: currentGasPrice
            }).on('error', (error) => {
                console.log('on handler');
                console.log(error);
            }).then(tx => {
                //console.log(tx);
                var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                console.log(transactionRef);
                dataObj.innerHTML = transactionRef;
            });
        } catch (error) {
            console.log(error.message);
            dataObj.innerHTML = error.message;
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';
    }
}

async function mintToggleCard(_series, _spot) {
    console.log('mintToggleCard: ' + _series + ' ' + _spot);

    if (await IsCorrectNetwork()) {

        // build the parameters here.
        console.log('series: ' + _series);
        console.log('spot: ' + _spot);

        let currentGasPrice = await web3.eth.getGasPrice();

        document.body.style.cursor = 'wait';
        let dataObj = document.getElementById("cardTrxnId");
        try {
            await arrProjects[0]['contractObj'].methods.cardMintToggle(_series, _spot).send({
                from: arrGlobals['visitor'],
                gasPrice: currentGasPrice
            }).on('error', (error) => {
                console.log('on handler');
                console.log(error);
            }).then(tx => {
                //console.log(tx);
                var transactionRef = '<a href="http://www.thetascan.io/hash/?hash=' + tx.transactionHash + '" target="_blank">Trxn Link & Hash</a>';
                console.log(transactionRef);
                dataObj.innerHTML = transactionRef;
            });
        } catch (error) {
            console.log(error.message);
            dataObj.innerHTML = error.message;
        }
        dataObj.style.display = "block";
        document.body.style.cursor = 'default';
    }
}

async function downloadPrize(_loc, _file) {
    //console.log('download: ');
    console.log('download: ' + _loc + '/' + _file);

    if (await IsCorrectNetwork()) {

        // In order to grant instant access to this visitor, they will need to sign
        // this transaction which will be decoded on the server.
        let theTimestamp = document.getElementById("customSigningTime").innerHTML;
        //console.log("time: " + theTimestamp);
        const msg = "timestamp:" + theTimestamp + ",drmcontract:" + arrGlobals['customContract']; // g_requestedContractAddr;
        console.log(msg);

        let dataObj = document.getElementById("customTrxnId");
        dataObj.innerHTML = "";

        try {
            const from = arrGlobals['visitor'];
            //console.log(arrGlobals['visitor']);
            //const msg = `0x${Buffer.from(siweMessage, "utf8").toString("hex")}`;
            const sign = await window.ethereum // Or window.ethereum if you don't support EIP-6963. // provider
                .request({
                    method: "personal_sign",
                    params: [msg, from],
                });
            dataObj.innerHTML = "";
            //console.log("sign: "+ sign);
            //siweResult.innerHTML = sign;

            let theOrigin = window.location.origin;
            //console.log(theOrigin);
            let thePathTmp = window.location.pathname;
            //console.log(thePathTmp);
            let thePath = thePathTmp.replace("cardsv1/index", "cardsv1/cardsv1auth");
            //console.log(thePath);

            // TODO: This is the point in which we call the server to get the instant access data.
            let params1 = "signature=" + sign;
            let params2 = "address=" + arrGlobals['visitor'];
            let params3 = "timestamp=" + theTimestamp;
            let params4 = "drmcontract=" + arrGlobals['customContract']; // g_requestedContractAddr;
            let params5 = "rtype=download";
            let params6 = "loc=" + _loc;
            let params7 = "file=" + _file;
            //let params5 = "rtype=test";

            let theParams = params1 + "&" + params2 + "&" + params3 + "&" + params4 + "&" + params5 + "&" + params6 + "&" + params7;
            console.log(theParams);

            let fullURL = theOrigin + thePath + "?" + theParams;
            console.log(fullURL);

            // Here is where the code changes in order to get the blob rather than json

            fetch(fullURL, {
                method: "GET",
                headers: {
                    'Content-Type': 'image/jpeg',
                    Accept: 'image/jpeg'
                },
                mode: "cors",
                cache: "default",
            }).then(response => {
                console.log("The Fetch: ");
                console.log(response);

                //console.log("Request Headers:", response.url); // URL requested
                //console.log("Response Status:", response.status);
                //console.log("Response Content-Type:", response.headers.get("Content-Type"));

                response.blob().then(resultsblob => {

                    // For the download version, just want the results to say 'passed'.
                    console.log("Signature Results: ");
                    console.log(resultsblob);

                    const objectUrl = URL.createObjectURL(resultsblob);
                    const link = document.createElement('a');
                    link.href = objectUrl;
                    link.download = _file;
                    link.click();
                    URL.revokeObjectURL(objectUrl);
                })
            });

        } catch (error) {
            console.error(error);
            dataObj.innerHTML = error.message;
            //siweResult.innerHTML = `Error: ${error.message}`;
        }

        dataObj.style.display = "block";
    }
}

